/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.referencing.Fallback;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class InstallationScriptProvider
extends InstallationResources {
    protected static final String PREPARE = "Prepare";
    protected static final String FINISH = "Finish";
    private final Set<String> authorities;
    private final String[] resources;

    protected InstallationScriptProvider(String string, String ... stringArray) {
        ArgumentChecks.ensureNonNull("resources", stringArray);
        this.authorities = CollectionsExt.singletonOrEmpty(string);
        this.resources = stringArray;
    }

    @Override
    public Set<String> getAuthorities() {
        return this.authorities;
    }

    private void verifyAuthority(String string) {
        if (!this.authorities.contains(string)) {
            throw new IllegalArgumentException(Errors.format((short)45, "authority", string));
        }
    }

    @Override
    public String[] getResourceNames(String string) throws IOException {
        this.verifyAuthority(string);
        return (String[])this.resources.clone();
    }

    @Override
    public BufferedReader openScript(String string, int n) throws IOException {
        Charset charset;
        InputStream inputStream;
        this.verifyAuthority(string);
        ArgumentChecks.ensureValidIndex(this.resources.length, n);
        if (!"EPSG".equals(string)) {
            throw new IllegalStateException(Resources.format((short)66, string));
        }
        String string2 = this.resources[n];
        if (PREPARE.equals(string2) || FINISH.equals(string2)) {
            string2 = string + '_' + string2 + ".sql";
            inputStream = InstallationScriptProvider.class.getResourceAsStream(string2);
            charset = StandardCharsets.UTF_8;
        } else {
            inputStream = this.openStream(string2);
            charset = StandardCharsets.ISO_8859_1;
            string2 = string2.concat(".sql");
        }
        if (inputStream == null) {
            throw new FileNotFoundException(Errors.format((short)39, string2));
        }
        return new LineNumberReader(new InputStreamReader(inputStream, charset));
    }

    protected abstract InputStream openStream(String var1) throws IOException;

    static void log(LogRecord logRecord) {
        logRecord.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(EPSGFactory.class, "install", logRecord);
    }

    @Fallback
    static final class Default
    extends InstallationScriptProvider {
        private Path directory;
        private static final int FIRST_FILE = 1;

        Default(Locale locale) throws IOException {
            super("EPSG", InstallationScriptProvider.PREPARE, "Tables", "Data", "FKeys", InstallationScriptProvider.FINISH);
            Path path = DataDirectory.DATABASES.getDirectory();
            if (path != null && Files.isDirectory(path = path.resolve("ExternalSources"), new LinkOption[0])) {
                String[] stringArray = ((InstallationScriptProvider)this).resources;
                String[] stringArray2 = new String[stringArray.length - 1 - 1];
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, "EPSG_*.sql");
                Object object = null;
                try {
                    for (Path path2 : directoryStream) {
                        String string = path2.getFileName().toString();
                        for (int i = 0; i < stringArray2.length; ++i) {
                            String string2 = stringArray[1 + i];
                            if (!string.contains(string2)) continue;
                            if (stringArray2[i] != null) {
                                Default.log(Errors.getResources(locale).getLogRecord(Level.WARNING, (short)24, string2));
                                return;
                            }
                            stringArray2[i] = string;
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (directoryStream != null) {
                        if (object != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            directoryStream.close();
                        }
                    }
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    object = stringArray2[i];
                    if (object != null) {
                        stringArray[1 + i] = object;
                        continue;
                    }
                    path = null;
                }
                this.directory = path;
            }
        }

        @Override
        public Set<String> getAuthorities() {
            return this.directory != null ? super.getAuthorities() : Collections.emptySet();
        }

        @Override
        public String getLicense(String string, Locale locale, String string2) {
            return null;
        }

        @Override
        protected InputStream openStream(String string) throws IOException {
            return this.directory != null ? Files.newInputStream(this.directory.resolve(string), new OpenOption[0]) : null;
        }
    }
}

