/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import org.apache.uima.cas.impl.CommonAuxHeap;

final class LongHeap
extends CommonAuxHeap {
    long[] heap;

    LongHeap() {
        super(16, 0x1000000);
    }

    LongHeap(int heapBaseSize, int heapMultLimit) {
        super(heapBaseSize, heapMultLimit);
    }

    @Override
    final void initMemory() {
        this.heap = new long[this.heapBaseSize];
    }

    @Override
    final void initMemory(int size) {
        this.heap = new long[size];
    }

    @Override
    final int getCapacity() {
        return this.heap.length;
    }

    @Override
    void growHeapIfNeeded() {
        if (this.heap.length >= this.heapPos) {
            return;
        }
        long[] new_array = new long[this.computeNewArraySize(this.heap.length, this.heapPos, 2, this.heapMultLimit)];
        System.arraycopy(this.heap, 0, new_array, 0, this.heap.length);
        this.heap = new_array;
    }

    @Override
    void resetToZeros() {
        Arrays.fill(this.heap, 0, this.heapPos, 0L);
    }

    long getHeapValue(int offset) {
        return this.heap[offset];
    }

    void setHeapValue(long val, int pos) {
        this.heap[pos] = val;
    }

    int addLong(long val) {
        int pos = this.reserve(1);
        this.heap[pos] = val;
        return pos;
    }

    protected void reinit(long[] longHeap) {
        int argLength = longHeap.length;
        if (argLength > this.heap.length) {
            this.heap = new long[argLength];
        }
        System.arraycopy(longHeap, 0, this.heap, 0, argLength);
        this.heapPos = argLength;
    }
}

