/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.commons.exec;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertNull;

import java.time.Duration;

import org.junit.jupiter.api.Test;

/**
 * Tests {@link ExecuteWatchdog}.
 */
class ExecuteWatchdogTest {

    @Test
    void testBuilder() {
        assertNotNull(ExecuteWatchdog.builder().get());
        assertNull(ExecuteWatchdog.builder().get().getWatchdog());
        assertNotNull(ExecuteWatchdog.builder().setTimeout(null).get());
        assertEquals(Duration.ofMinutes(1), ExecuteWatchdog.builder().setTimeout(Duration.ofMinutes(1)).get().getWatchdog().getTimeout());
        assertNotNull(ExecuteWatchdog.builder().setThreadFactory(null).get());
        assertNotNull(ExecuteWatchdog.builder().setThreadFactory(null).setTimeout(Duration.ofMinutes(1)).get().getWatchdog().getThreadFactory());
    }
}
