/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.pool2.impl;

import java.time.Duration;

/**
 * Constants used in tests.
 */
class TestConstants {

    /**
     * A duration of one second.
     */
    public static final Duration ONE_SECOND_DURATION = Duration.ofSeconds(1);

    /**
     * A duration of one minute.
     */
    public static final Duration ONE_MINUTE_DURATION = Duration.ofMinutes(1);

    /**
     * A duration of one millisecond.
     */
    public static final Duration ONE_MILLISECOND_DURATION = Duration.ofMillis(1);

}
