/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.adlsv2;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import org.apache.iceberg.azure.adlsv2.VendedAdlsCredentialProvider;
import reactor.core.publisher.Mono;

class VendedAzureSasCredentialPolicy
implements HttpPipelinePolicy {
    private final String account;
    private final VendedAdlsCredentialProvider vendedAdlsCredentialProvider;
    private volatile AzureSasCredential azureSasCredential;
    private AzureSasCredentialPolicy azureSasCredentialPolicy;

    VendedAzureSasCredentialPolicy(String account, VendedAdlsCredentialProvider vendedAdlsCredentialProvider) {
        this.account = account;
        this.vendedAdlsCredentialProvider = vendedAdlsCredentialProvider;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        return this.maybeUpdateCredential().then(Mono.defer(() -> this.azureSasCredentialPolicy.process(httpPipelineCallContext, httpPipelineNextPolicy)));
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        this.maybeUpdateCredential().block();
        return this.azureSasCredentialPolicy.processSync(context, next);
    }

    private Mono<Void> maybeUpdateCredential() {
        return this.vendedAdlsCredentialProvider.credentialForAccount(this.account).flatMap(sasToken -> {
            if (this.azureSasCredential == null) {
                VendedAzureSasCredentialPolicy vendedAzureSasCredentialPolicy = this;
                synchronized (vendedAzureSasCredentialPolicy) {
                    if (this.azureSasCredential == null) {
                        this.azureSasCredential = new AzureSasCredential(sasToken);
                        this.azureSasCredentialPolicy = new AzureSasCredentialPolicy(this.azureSasCredential, false);
                        return Mono.empty();
                    }
                }
            }
            this.azureSasCredential.update(sasToken);
            return Mono.empty();
        });
    }
}

