/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authorization.expression;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuthorizationExpressionConverter {
    public static final Pattern PATTERN = Pattern.compile("([A-Z_]+)::([A-Z_]+)");
    public static final Pattern ANY_PATTERN = Pattern.compile("ANY\\(([^)]+)\\)");
    public static final String CAN_OPERATE_METADATA_PRIVILEGE = "CAN_OPERATE_METADATA_PRIVILEGE";
    public static final String CAN_SET_OWNER = "CAN_SET_OWNER";
    private static final String DENY_PREFIX = "DENY_";
    private static final Map<String, String> EXPRESSION_CACHE = new ConcurrentHashMap<String, String>();

    private AuthorizationExpressionConverter() {
    }

    public static String convertToOgnlExpression(String authorizationExpression) {
        return EXPRESSION_CACHE.computeIfAbsent(authorizationExpression, expression -> {
            String replacedExpression = AuthorizationExpressionConverter.replaceCanAccessMetadataPrivilege(expression);
            replacedExpression = AuthorizationExpressionConverter.replaceAnyPrivilege(replacedExpression);
            replacedExpression = AuthorizationExpressionConverter.replaceAnyExpressions(replacedExpression);
            Matcher matcher = PATTERN.matcher(replacedExpression);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String replacement;
                String type = matcher.group(1);
                String privilegeOrExpression = matcher.group(2);
                if ("OWNER".equals(privilegeOrExpression)) {
                    replacement = String.format("authorizer.isOwner(principal,METALAKE_NAME,%s,authorizationContext)", type);
                } else if (privilegeOrExpression.startsWith(DENY_PREFIX)) {
                    String privilege = privilegeOrExpression.substring(5);
                    replacement = String.format("authorizer.deny(principal,METALAKE_NAME,%s,@org.apache.gravitino.authorization.Privilege\\$Name@%s,authorizationContext)", type, privilege);
                } else {
                    replacement = "SELF".equals(privilegeOrExpression) ? String.format("authorizer.isSelf(@org.apache.gravitino.Entity\\$EntityType@%s,%s_NAME_IDENT)", type, type) : String.format("authorizer.authorize(principal,METALAKE_NAME,%s,@org.apache.gravitino.authorization.Privilege\\$Name@%s,authorizationContext)", type, privilegeOrExpression);
                }
                matcher.appendReplacement(result, replacement);
            }
            matcher.appendTail(result);
            return result.toString();
        });
    }

    public static String replaceAnyExpressions(String expression) {
        Matcher matcher = ANY_PATTERN.matcher(expression);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String innerContent = matcher.group(1);
            String[] parts = innerContent.split(",");
            if (parts.length < 2) {
                matcher.appendReplacement(result, Matcher.quoteReplacement(matcher.group(0)));
                continue;
            }
            String function = parts[0].trim();
            StringBuilder replacement = new StringBuilder();
            for (int i = 1; i < parts.length; ++i) {
                String scope = parts[i].trim();
                if (scope.isEmpty()) continue;
                if (replacement.length() > 0) {
                    replacement.append(" || ");
                }
                replacement.append(scope).append("::").append(function);
            }
            matcher.appendReplacement(result, replacement.toString());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String replaceCanAccessMetadataPrivilege(String expression) {
        return expression.replaceAll("CAN_ACCESS_METADATA", "( entityType == 'CATALOG' && (%s)) ||\n( entityType == 'SCHEMA' && (%s)) ||\n( entityType == 'TABLE' && (%s)) ||\n( entityType == 'MODEL' && (%s)) ||\n( entityType == 'FILESET' && (%s)) ||\n( entityType == 'TOPIC' && (%s)) ||\n( entityType == 'ROLE' && (%s)) ||\n( entityType == 'METALAKE' && (%s)) ||\n( entityType == 'POLICY' && (%s)) ||\n( entityType == 'TAG' && (%s)) ||\n( entityType == 'JOB' && (%s)) ||\n( entityType == 'JOB_TEMPLATE' && (%s)) ||\n( entityType == 'COLUMN' && (%s))\n".formatted("ANY_USE_CATALOG || ANY(OWNER, METALAKE, CATALOG)", "ANY(OWNER, METALAKE, CATALOG) ||\nANY_USE_CATALOG && (SCHEMA::OWNER || ANY_USE_SCHEMA)\n", "ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_SELECT_TABLE || ANY_MODIFY_TABLE)\n", "ANY(OWNER, METALAKE, CATALOG) ||\n SCHEMA_OWNER_WITH_USE_CATALOG ||\n  ANY_USE_CATALOG && ANY_USE_SCHEMA && (MODEL::OWNER || ANY_USE_MODEL)\n", "ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && (FILESET::OWNER || ANY_READ_FILESET || ANY_WRITE_FILESET)\n", "ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA && (TOPIC::OWNER || ANY_CONSUME_TOPIC || ANY_PRODUCE_TOPIC)\n", "METALAKE::OWNER || METALAKE::MANAGE_GRANTS\n|| ROLE::OWNER || ROLE::SELF\n", "METALAKE_USER", "METALAKE::OWNER || POLICY::OWNER || ANY_APPLY_POLICY\n", "METALAKE::OWNER || TAG::OWNER || ANY_APPLY_TAG", "METALAKE::OWNER || JOB::OWNER", "METALAKE::OWNER || JOB_TEMPLATE::OWNER || ANY_USE_JOB_TEMPLATE", "ANY(OWNER, METALAKE, CATALOG) ||\nSCHEMA_OWNER_WITH_USE_CATALOG ||\nANY_USE_CATALOG && ANY_USE_SCHEMA  && (TABLE::OWNER || ANY_SELECT_TABLE || ANY_MODIFY_TABLE)\n"));
    }

    public static String replaceAnyPrivilege(String expression) {
        expression = expression.replaceAll("SERVICE_ADMIN", "authorizer.isServiceAdmin()");
        expression = expression.replaceAll("METALAKE_USER", "authorizer.isMetalakeUser(METALAKE_NAME)");
        expression = expression.replaceAll("ANY_USE_CATALOG", "((ANY(USE_CATALOG, METALAKE, CATALOG)) && !(ANY(DENY_USE_CATALOG, METALAKE, CATALOG)))");
        expression = expression.replaceAll("ANY_USE_SCHEMA", "((ANY(USE_SCHEMA, METALAKE, CATALOG, SCHEMA)) && !(ANY(DENY_USE_SCHEMA, METALAKE, CATALOG, SCHEMA)))");
        expression = expression.replaceAll("ANY_CREATE_SCHEMA", "((ANY(CREATE_SCHEMA, METALAKE, CATALOG)) && !(ANY(DENY_CREATE_SCHEMA, METALAKE, CATALOG)))");
        expression = expression.replaceAll("ANY_SELECT_TABLE", "((ANY(SELECT_TABLE, METALAKE, CATALOG, SCHEMA, TABLE)) && !(ANY(DENY_SELECT_TABLE, METALAKE, CATALOG, SCHEMA, TABLE)) )");
        expression = expression.replaceAll("ANY_MODIFY_TABLE", "((ANY(MODIFY_TABLE, METALAKE, CATALOG, SCHEMA, TABLE)) && !(ANY(DENY_MODIFY_TABLE, METALAKE, CATALOG, SCHEMA, TABLE)))");
        expression = expression.replaceAll("ANY_CREATE_TABLE", "((ANY(CREATE_TABLE, METALAKE, CATALOG, SCHEMA, TABLE)) && !(ANY(DENY_CREATE_TABLE, METALAKE, CATALOG, SCHEMA, TABLE)))");
        expression = expression.replaceAll("ANY_CREATE_FILESET", "((ANY(CREATE_FILESET, METALAKE, CATALOG, SCHEMA)) && !(ANY(DENY_CREATE_FILESET, METALAKE, CATALOG, SCHEMA)))");
        expression = expression.replaceAll("SCHEMA_OWNER_WITH_USE_CATALOG", "SCHEMA::OWNER && ((ANY(USE_CATALOG, METALAKE, CATALOG)) && !(ANY(DENY_USE_CATALOG, METALAKE, CATALOG)))");
        expression = expression.replaceAll("ANY_USE_MODEL", "((ANY(USE_MODEL, METALAKE, CATALOG, SCHEMA, MODEL)) && !(ANY(DENY_USE_MODEL, METALAKE, CATALOG, SCHEMA, MODEL)))");
        expression = expression.replaceAll("ANY_LINK_MODEL_VERSION", "((ANY(LINK_MODEL_VERSION, METALAKE, CATALOG, SCHEMA, MODEL)) && !(ANY(DENY_LINK_MODEL_VERSION, METALAKE, CATALOG, SCHEMA, MODEL)))");
        expression = expression.replaceAll("ANY_REGISTER_MODEL", "((ANY(REGISTER_MODEL, METALAKE, CATALOG, SCHEMA)) && !(ANY(DENY_REGISTER_MODEL, METALAKE, CATALOG, SCHEMA)))");
        expression = expression.replaceAll("ANY_CREATE_TOPIC", "((ANY(CREATE_TOPIC, METALAKE, CATALOG, SCHEMA, TOPIC)) && !(ANY(DENY_CREATE_TOPIC, METALAKE, CATALOG, SCHEMA, TOPIC)))");
        expression = expression.replaceAll("ANY_PRODUCE_TOPIC", "((ANY(PRODUCE_TOPIC, METALAKE, CATALOG, SCHEMA, TOPIC))&& !(ANY(DENY_PRODUCE_TOPIC, METALAKE, CATALOG, SCHEMA, TOPIC)))");
        expression = expression.replaceAll("ANY_CONSUME_TOPIC", "((ANY(CONSUME_TOPIC, METALAKE, CATALOG, SCHEMA, TOPIC))&& !(ANY(DENY_CONSUME_TOPIC, METALAKE, CATALOG, SCHEMA, TOPIC)))");
        expression = expression.replaceAll("ANY_READ_FILESET", "((ANY(READ_FILESET, METALAKE, CATALOG, SCHEMA, FILESET))&& !(ANY(DENY_READ_FILESET, METALAKE, CATALOG, SCHEMA, FILESET)))");
        expression = expression.replaceAll("ANY_WRITE_FILESET", "((ANY(WRITE_FILESET, METALAKE, CATALOG, SCHEMA, FILESET))&& !(ANY(DENY_WRITE_FILESET, METALAKE, CATALOG, SCHEMA, FILESET)))");
        expression = expression.replaceAll("ANY_APPLY_TAG", "((ANY(APPLY_TAG, METALAKE, TAG))&& !(ANY(DENY_APPLY_TAG, METALAKE, TAG)))");
        expression = expression.replaceAll("ANY_APPLY_POLICY", "((ANY(APPLY_POLICY, METALAKE, POLICY))&& !(ANY(DENY_APPLY_POLICY, METALAKE, POLICY)))");
        expression = expression.replaceAll("ANY_USE_JOB_TEMPLATE", "((ANY(USE_JOB_TEMPLATE, METALAKE, JOB_TEMPLATE))&& !(ANY(DENY_USE_JOB_TEMPLATE, METALAKE, JOB_TEMPLATE)))");
        expression = expression.replaceAll(CAN_SET_OWNER, "authorizer.hasSetOwnerPermission(p_metalake,p_metadataObjectType,p_fullName,authorizationContext)");
        expression = expression.replaceAll(CAN_OPERATE_METADATA_PRIVILEGE, "authorizer.hasMetadataPrivilegePermission(p_metalake,p_type,p_fullName,authorizationContext)");
        return expression;
    }
}

