/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.parser.Parser;
import com.googlecode.aviator.parser.ScopeInfo;
import com.googlecode.aviator.runtime.FunctionParam;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class LambdaGenerator
implements CodeGenerator {
    private final List<FunctionParam> params = new ArrayList<FunctionParam>();
    private final CodeGenerator codeGenerator;
    private final CodeGenerator parentCodeGenerator;
    private final String className;
    private static final AtomicLong LAMBDA_COUNTER = new AtomicLong();
    private ScopeInfo scopeInfo;
    private final boolean newLexicalScope;
    private final boolean inheritEnv;

    public LambdaGenerator(AviatorEvaluatorInstance instance, CodeGenerator parentCodeGenerator, Parser parser, AviatorClassLoader classLoader, String sourceFile, boolean newLexicalScope, boolean inheritEnv) {
        this.parentCodeGenerator = parentCodeGenerator;
        this.codeGenerator = instance.newCodeGenerator(classLoader, sourceFile);
        this.codeGenerator.setParser(parser);
        this.newLexicalScope = newLexicalScope;
        this.inheritEnv = inheritEnv;
        this.className = "AviatorScript_" + System.currentTimeMillis() + "_" + LAMBDA_COUNTER.getAndIncrement();
    }

    public ScopeInfo getScopeInfo() {
        return this.scopeInfo;
    }

    public void setScopeInfo(ScopeInfo scopeInfo) {
        this.scopeInfo = scopeInfo;
    }

    @Override
    public void setParser(Parser parser) {
        this.codeGenerator.setParser(parser);
    }

    public LambdaFunctionBootstrap getLmabdaBootstrap() {
        Expression expression = this.getResult(!this.newLexicalScope);
        return new LambdaFunctionBootstrap(this.className, expression, this.params, this.inheritEnv);
    }

    public void addParam(FunctionParam name) {
        this.params.add(name);
    }

    @Override
    public void onShiftRight(Token<?> lookhead) {
        this.codeGenerator.onShiftRight(lookhead);
    }

    @Override
    public void onShiftLeft(Token<?> lookhead) {
        this.codeGenerator.onShiftLeft(lookhead);
    }

    @Override
    public void onUnsignedShiftRight(Token<?> lookhead) {
        this.codeGenerator.onUnsignedShiftRight(lookhead);
    }

    @Override
    public void onAssignment(Token<?> lookhead) {
        this.codeGenerator.onAssignment(lookhead);
    }

    @Override
    public void onBitOr(Token<?> lookhead) {
        this.codeGenerator.onBitOr(lookhead);
    }

    @Override
    public void onBitAnd(Token<?> lookhead) {
        this.codeGenerator.onBitAnd(lookhead);
    }

    @Override
    public void onBitXor(Token<?> lookhead) {
        this.codeGenerator.onBitXor(lookhead);
    }

    @Override
    public void onBitNot(Token<?> lookhead) {
        this.codeGenerator.onBitNot(lookhead);
    }

    @Override
    public void onAdd(Token<?> lookhead) {
        this.codeGenerator.onAdd(lookhead);
    }

    @Override
    public void onSub(Token<?> lookhead) {
        this.codeGenerator.onSub(lookhead);
    }

    @Override
    public void onMult(Token<?> lookhead) {
        this.codeGenerator.onMult(lookhead);
    }

    @Override
    public void onExponent(Token<?> lookhead) {
        this.codeGenerator.onExponent(lookhead);
    }

    @Override
    public void onDiv(Token<?> lookhead) {
        this.codeGenerator.onDiv(lookhead);
    }

    @Override
    public void onAndLeft(Token<?> lookhead) {
        this.codeGenerator.onAndLeft(lookhead);
    }

    @Override
    public void onAndRight(Token<?> lookhead) {
        this.codeGenerator.onAndRight(lookhead);
    }

    @Override
    public void onTernaryBoolean(Token<?> lookhead) {
        this.codeGenerator.onTernaryBoolean(lookhead);
    }

    @Override
    public void onTernaryLeft(Token<?> lookhead) {
        this.codeGenerator.onTernaryLeft(lookhead);
    }

    @Override
    public void onTernaryRight(Token<?> lookhead) {
        this.codeGenerator.onTernaryRight(lookhead);
    }

    @Override
    public void onTernaryEnd(Token<?> lookhead) {
        this.codeGenerator.onTernaryEnd(lookhead);
    }

    @Override
    public void onJoinLeft(Token<?> lookhead) {
        this.codeGenerator.onJoinLeft(lookhead);
    }

    @Override
    public void onJoinRight(Token<?> lookhead) {
        this.codeGenerator.onJoinRight(lookhead);
    }

    @Override
    public void onEq(Token<?> lookhead) {
        this.codeGenerator.onEq(lookhead);
    }

    @Override
    public void onMatch(Token<?> lookhead) {
        this.codeGenerator.onMatch(lookhead);
    }

    @Override
    public void onNeq(Token<?> lookhead) {
        this.codeGenerator.onNeq(lookhead);
    }

    @Override
    public void onLt(Token<?> lookhead) {
        this.codeGenerator.onLt(lookhead);
    }

    @Override
    public void onLe(Token<?> lookhead) {
        this.codeGenerator.onLe(lookhead);
    }

    @Override
    public void onGt(Token<?> lookhead) {
        this.codeGenerator.onGt(lookhead);
    }

    @Override
    public void onGe(Token<?> lookhead) {
        this.codeGenerator.onGe(lookhead);
    }

    @Override
    public void onMod(Token<?> lookhead) {
        this.codeGenerator.onMod(lookhead);
    }

    @Override
    public void onNot(Token<?> lookhead) {
        this.codeGenerator.onNot(lookhead);
    }

    @Override
    public void onNeg(Token<?> lookhead) {
        this.codeGenerator.onNeg(lookhead);
    }

    @Override
    public Expression getResult(boolean unboxObject) {
        return this.codeGenerator.getResult(unboxObject);
    }

    @Override
    public void onConstant(Token<?> lookhead) {
        this.codeGenerator.onConstant(lookhead);
    }

    @Override
    public void onMethodName(Token<?> lookhead) {
        this.codeGenerator.onMethodName(lookhead);
    }

    @Override
    public void onMethodParameter(Token<?> lookhead) {
        this.codeGenerator.onMethodParameter(lookhead);
    }

    @Override
    public void onMethodInvoke(Token<?> lookhead) {
        this.codeGenerator.onMethodInvoke(lookhead);
    }

    @Override
    public void onLambdaDefineStart(Token<?> lookhead) {
        this.codeGenerator.onLambdaDefineStart(lookhead);
    }

    @Override
    public void onLambdaArgument(Token<?> lookhead, FunctionParam param) {
        this.codeGenerator.onLambdaArgument(lookhead, param);
    }

    @Override
    public void onLambdaBodyStart(Token<?> lookhead) {
        this.codeGenerator.onLambdaBodyStart(lookhead);
    }

    @Override
    public void onLambdaBodyEnd(Token<?> lookhead) {
        this.parentCodeGenerator.onLambdaBodyEnd(lookhead);
    }

    @Override
    public void onArray(Token<?> lookhead) {
        this.codeGenerator.onArray(lookhead);
    }

    @Override
    public void onArrayIndexStart(Token<?> token) {
        this.codeGenerator.onArrayIndexStart(token);
    }

    @Override
    public void onArrayIndexEnd(Token<?> lookhead) {
        this.codeGenerator.onArrayIndexEnd(lookhead);
    }
}

