/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type.seq;

import com.googlecode.aviator.runtime.type.Collector;
import com.googlecode.aviator.runtime.type.seq.AbstractSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class IterableSequence
extends AbstractSequence<Object> {
    private final Iterable<Object> iterable;

    public IterableSequence(Iterable<Object> iterable) {
        this.iterable = iterable;
    }

    @Override
    public int hintSize() {
        if (this.iterable instanceof Collection) {
            return ((Collection)this.iterable).size();
        }
        return 10;
    }

    @Override
    public Collector newCollector(int size) {
        ArrayList coll;
        try {
            coll = (ArrayList)this.iterable.getClass().newInstance();
        }
        catch (Throwable t) {
            coll = new ArrayList(size > 0 ? size : 10);
        }
        final ArrayList container = coll;
        return new Collector(){

            @Override
            public void add(Object e) {
                container.add(e);
            }

            @Override
            public Object getRawContainer() {
                return container;
            }
        };
    }

    @Override
    public Iterator<Object> iterator() {
        return this.iterable.iterator();
    }
}

