/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.iceberg.service.IcebergExceptionMapper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionEvaluator;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetadataAuthorizationMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMetadataAuthorizationMethodInterceptor.class);

    protected abstract Map<Entity.EntityType, NameIdentifier> extractNameIdentifierFromParameters(Parameter[] var1, Object[] var2);

    protected Optional<AuthorizationHandler> createAuthorizationHandler(Parameter[] parameters, Object[] args) {
        return Optional.empty();
    }

    protected boolean isExceptionPropagate(Exception e) {
        return false;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        block11: {
            try {
                Map pathParams;
                AuthorizationExpressionEvaluator authorizationExpressionEvaluator;
                boolean authorizeResult;
                Method method = methodInvocation.getMethod();
                Parameter[] parameters = method.getParameters();
                AuthorizationExpression expressionAnnotation = method.getAnnotation(AuthorizationExpression.class);
                if (expressionAnnotation == null) break block11;
                String expression = expressionAnnotation.expression();
                Object[] args = methodInvocation.getArguments();
                Map<Entity.EntityType, NameIdentifier> nameIdentifierMap = this.extractNameIdentifierFromParameters(parameters, args);
                NameIdentifier metalakeIdent = nameIdentifierMap.get(Entity.EntityType.METALAKE);
                if (metalakeIdent != null) {
                    String currentUser = PrincipalUtils.getCurrentUserName();
                    try {
                        AuthorizationUtils.checkCurrentUser((String)metalakeIdent.name(), (String)currentUser);
                    }
                    catch (org.apache.gravitino.exceptions.ForbiddenException ex) {
                        LOG.info("User validation failed - User: '{}', Metalake: '{}', Reason: {}", new Object[]{currentUser, metalakeIdent.name(), ex.getMessage()});
                        return IcebergExceptionMapper.toRESTResponse(ex);
                    }
                    catch (Exception ex) {
                        LOG.error("Unexpected error during user validation - User: '{}', Metalake: '{}'", new Object[]{currentUser, metalakeIdent.name(), ex});
                        return IcebergExceptionMapper.toRESTResponse(new RuntimeException("Failed to validate user", ex));
                    }
                }
                Optional<AuthorizationHandler> handler = this.createAuthorizationHandler(parameters, args);
                boolean skipStandardCheck = false;
                if (handler.isPresent()) {
                    AuthorizationHandler authzHandler = handler.get();
                    authzHandler.process(nameIdentifierMap);
                    skipStandardCheck = authzHandler.authorizationCompleted();
                }
                if (!skipStandardCheck && !(authorizeResult = (authorizationExpressionEvaluator = new AuthorizationExpressionEvaluator(expression)).evaluate(nameIdentifierMap, pathParams = Utils.extractPathParamsFromParameters((Parameter[])parameters, (Object[])args), new AuthorizationRequestContext(), Optional.empty()))) {
                    MetadataObject.Type type = expressionAnnotation.accessMetadataType();
                    NameIdentifier accessMetadataName = nameIdentifierMap.get(Entity.EntityType.valueOf((String)type.name()));
                    String currentUser = PrincipalUtils.getCurrentUserName();
                    String methodName = method.getName();
                    String notAuthzMessage = String.format("User '%s' is not authorized to perform operation '%s' on metadata '%s' with expression '%s'", currentUser, methodName, accessMetadataName, expression);
                    LOG.info(notAuthzMessage);
                    return IcebergExceptionMapper.toRESTResponse((Throwable)new ForbiddenException(notAuthzMessage, new Object[0]));
                }
            }
            catch (Exception ex) {
                if (this.isExceptionPropagate(ex)) {
                    return IcebergExceptionMapper.toRESTResponse(ex);
                }
                String currentUser = PrincipalUtils.getCurrentUserName();
                String methodName = methodInvocation.getMethod().getName();
                String errorMessage = String.format("Authorization failed due to system internal error, User: '%s', Operation: '%s'", currentUser, methodName);
                LOG.info(errorMessage, (Throwable)ex);
                return IcebergExceptionMapper.toRESTResponse(new RuntimeException(errorMessage, ex));
            }
        }
        try {
            return methodInvocation.proceed();
        }
        catch (Throwable e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    protected static interface AuthorizationHandler {
        public void process(Map<Entity.EntityType, NameIdentifier> var1) throws ForbiddenException;

        public boolean authorizationCompleted();
    }
}

