/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.RadixTree;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.cache.BaseEntityCache;
import org.apache.gravitino.cache.EntityCache;
import org.apache.gravitino.cache.EntityCacheKey;
import org.apache.gravitino.cache.EntityCacheRelationKey;
import org.apache.gravitino.cache.EntityCacheWeigher;
import org.apache.gravitino.cache.ReverseIndexCache;
import org.apache.gravitino.cache.SegmentedLock;
import org.apache.gravitino.meta.GenericEntity;
import org.apache.gravitino.meta.ModelVersionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineEntityCache
extends BaseEntityCache {
    private static final int CACHE_CLEANUP_CORE_THREADS = 1;
    private static final int CACHE_CLEANUP_MAX_THREADS = 1;
    private static final int CACHE_CLEANUP_QUEUE_CAPACITY = 100;
    private static final int CACHE_MONITOR_PERIOD_MINUTES = 5;
    private static final int CACHE_MONITOR_INITIAL_DELAY_MINUTES = 0;
    private static final ExecutorService CLEANUP_EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100), r -> {
        Thread t = new Thread(r, "CaffeineEntityCache-Cleanup");
        t.setDaemon(true);
        return t;
    }, new ThreadPoolExecutor.CallerRunsPolicy());
    private static final Logger LOG = LoggerFactory.getLogger((String)CaffeineEntityCache.class.getName());
    private final SegmentedLock segmentedLock;
    private final Cache<EntityCacheRelationKey, List<Entity>> cacheData;
    private ReverseIndexCache reverseIndex;
    private RadixTree<EntityCacheRelationKey> cacheIndex = new ConcurrentRadixTree((NodeFactory)new DefaultCharArrayNodeFactory());
    private ScheduledExecutorService scheduler;
    private static final Set<SupportsRelationOperations.Type> RELATION_TYPES = Sets.newHashSet((Object[])new SupportsRelationOperations.Type[]{SupportsRelationOperations.Type.METADATA_OBJECT_ROLE_REL, SupportsRelationOperations.Type.ROLE_USER_REL, SupportsRelationOperations.Type.ROLE_GROUP_REL, SupportsRelationOperations.Type.POLICY_METADATA_OBJECT_REL, SupportsRelationOperations.Type.TAG_METADATA_OBJECT_REL});

    @VisibleForTesting
    public ReverseIndexCache getReverseIndex() {
        return this.reverseIndex;
    }

    public CaffeineEntityCache(Config cacheConfig) {
        super(cacheConfig);
        this.reverseIndex = new ReverseIndexCache();
        int lockSegments = (Integer)cacheConfig.get(Configs.CACHE_LOCK_SEGMENTS);
        this.segmentedLock = new SegmentedLock(lockSegments);
        Caffeine cacheDataBuilder = this.newBaseBuilder(cacheConfig);
        cacheDataBuilder.executor((Executor)CLEANUP_EXECUTOR).removalListener((key, value, cause) -> {
            if (cause == RemovalCause.EXPLICIT || cause == RemovalCause.REPLACED) {
                return;
            }
            try {
                this.invalidateExpiredItem((EntityCacheKey)key);
            }
            catch (Throwable t) {
                LOG.error("Failed to remove entity key={} value={} from cache asynchronously, cause={}", new Object[]{key, value, cause, t});
            }
        });
        this.cacheData = cacheDataBuilder.build();
        if (((Boolean)cacheConfig.get(Configs.CACHE_STATS_ENABLED)).booleanValue()) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.startCacheStatsMonitor();
        }
    }

    @VisibleForTesting
    public Cache<EntityCacheRelationKey, List<Entity>> getCacheData() {
        return this.cacheData;
    }

    @Override
    public <E extends Entity & HasIdentifier> Optional<List<E>> getIfPresent(SupportsRelationOperations.Type relType, NameIdentifier nameIdentifier, Entity.EntityType identType) {
        this.checkArguments(nameIdentifier, identType, relType);
        List entitiesFromCache = (List)this.cacheData.getIfPresent((Object)EntityCacheRelationKey.of(nameIdentifier, identType, relType));
        return Optional.ofNullable(entitiesFromCache).map(BaseEntityCache::convertEntities);
    }

    @Override
    public <E extends Entity & HasIdentifier> Optional<E> getIfPresent(NameIdentifier ident, Entity.EntityType type) {
        this.checkArguments(ident, type);
        List entitiesFromCache = (List)this.cacheData.getIfPresent((Object)EntityCacheRelationKey.of(ident, type));
        return Optional.ofNullable(entitiesFromCache).filter(l -> !l.isEmpty()).map(entities -> CaffeineEntityCache.convertEntity((Entity)entities.get(0)));
    }

    @Override
    public boolean invalidate(NameIdentifier ident, Entity.EntityType type, SupportsRelationOperations.Type relType) {
        this.checkArguments(ident, type, relType);
        return this.segmentedLock.withLock((Object)EntityCacheRelationKey.of(ident, type, relType), () -> {
            this.invalidateEntities(ident, type, Optional.of(relType));
            return true;
        });
    }

    @Override
    public boolean invalidate(NameIdentifier ident, Entity.EntityType type) {
        this.checkArguments(ident, type);
        return this.segmentedLock.withLock((Object)EntityCacheRelationKey.of(ident, type), () -> {
            RELATION_TYPES.forEach(relType -> {
                List relatedEntities = (List)this.cacheData.getIfPresent((Object)EntityCacheRelationKey.of(ident, type, relType));
                if (relatedEntities != null) {
                    relatedEntities.stream().filter(e -> StringUtils.isNotBlank((CharSequence)((HasIdentifier)((Object)e)).name())).forEach(entity -> {
                        NameIdentifier identifier = ((HasIdentifier)((Object)entity)).nameIdentifier();
                        if (entity instanceof GenericEntity) {
                            String metalakeName = ident.namespace().level(0);
                            Object[] names = (String[])ArrayUtils.addFirst((Object[])identifier.namespace().levels(), (Object)metalakeName);
                            names = (String[])ArrayUtils.add((Object[])names, (Object)identifier.name());
                            identifier = NameIdentifier.of((String[])names);
                        }
                        this.invalidateEntities(identifier, entity.type(), Optional.of(relType));
                    });
                }
            });
            RELATION_TYPES.forEach(relType -> this.invalidateEntities(ident, type, Optional.of(relType)));
            this.invalidateEntities(ident, type, Optional.empty());
            return true;
        });
    }

    @Override
    public boolean contains(NameIdentifier ident, Entity.EntityType type, SupportsRelationOperations.Type relType) {
        this.checkArguments(ident, type, relType);
        return this.cacheData.getIfPresent((Object)EntityCacheRelationKey.of(ident, type, relType)) != null;
    }

    @Override
    public boolean contains(NameIdentifier ident, Entity.EntityType type) {
        this.checkArguments(ident, type);
        return this.cacheData.getIfPresent((Object)EntityCacheRelationKey.of(ident, type)) != null;
    }

    @Override
    public long size() {
        return this.cacheIndex.size();
    }

    @Override
    public void clear() {
        this.segmentedLock.withGlobalLock(() -> this.cacheData.invalidateAll());
    }

    @Override
    public <E extends Entity & HasIdentifier> void put(NameIdentifier ident, Entity.EntityType type, SupportsRelationOperations.Type relType, List<E> entities) {
        this.checkArguments(ident, type, relType);
        Preconditions.checkArgument((entities != null ? 1 : 0) != 0, (Object)"Entities cannot be null");
        EntityCacheRelationKey entityCacheKey = EntityCacheRelationKey.of(ident, type, relType);
        this.segmentedLock.withLock((Object)entityCacheKey, () -> {
            if (entities.isEmpty()) {
                return;
            }
            this.syncEntitiesToCache(entityCacheKey, entities.stream().map(e -> e).collect(Collectors.toList()));
        });
    }

    @Override
    public <E extends Entity & HasIdentifier> void put(E entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        NameIdentifier identifier = CaffeineEntityCache.getIdentFromEntity(entity);
        EntityCacheRelationKey entityCacheKey = EntityCacheRelationKey.of(identifier, entity.type());
        this.segmentedLock.withLock((Object)entityCacheKey, () -> {
            this.invalidateOnKeyChange(entity);
            this.syncEntitiesToCache(entityCacheKey, Lists.newArrayList((Object[])new Entity[]{entity}));
        });
    }

    @Override
    public <E extends Entity & HasIdentifier> void invalidateOnKeyChange(E entity) {
        if (Objects.requireNonNull(entity.type()) == Entity.EntityType.MODEL_VERSION) {
            NameIdentifier modelIdent = ((ModelVersionEntity)entity).modelIdentifier();
            this.invalidate(modelIdent, Entity.EntityType.MODEL);
        }
    }

    @Override
    public <E extends Exception> void withCacheLock(EntityCacheKey key, EntityCache.ThrowingRunnable<E> action) throws E {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"Action cannot be null");
        this.segmentedLock.withLockAndThrow((Object)key, action);
    }

    public <E, T extends Exception> E withCacheLock(EntityCacheKey key, EntityCache.ThrowingSupplier<E, T> action) throws T {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"Action cannot be null");
        return this.segmentedLock.withLockAndThrow((Object)key, action);
    }

    @Override
    protected void invalidateExpiredItem(EntityCacheKey key) {
        this.segmentedLock.withLock((Object)key, () -> {
            this.reverseIndex.remove(key);
            this.cacheIndex.remove((CharSequence)key.toString());
        });
    }

    private void syncEntitiesToCache(EntityCacheRelationKey key, List<Entity> newEntities) {
        List existingEntities = (List)this.cacheData.getIfPresent((Object)key);
        if (existingEntities != null && key.relationType() != null) {
            LinkedHashSet merged = Sets.newLinkedHashSet((Iterable)existingEntities);
            merged.addAll(newEntities);
            newEntities = new ArrayList<Entity>(merged);
        }
        this.cacheData.put((Object)key, newEntities);
        for (Entity entity : newEntities) {
            this.reverseIndex.indexEntity(entity, key);
        }
        if (this.cacheData.policy().getIfPresentQuietly((Object)key) != null) {
            this.cacheIndex.put((CharSequence)key.toString(), (Object)key);
        }
    }

    private <KEY, VALUE> Caffeine<KEY, VALUE> newBaseBuilder(Config cacheConfig) {
        Caffeine builder = Caffeine.newBuilder();
        if (((Boolean)cacheConfig.get(Configs.CACHE_WEIGHER_ENABLED)).booleanValue()) {
            builder.maximumWeight(EntityCacheWeigher.getMaxWeight());
            builder.weigher((Weigher)EntityCacheWeigher.getInstance());
        } else {
            builder.maximumSize((long)((Integer)cacheConfig.get(Configs.CACHE_MAX_ENTRIES)).intValue());
        }
        if ((Long)cacheConfig.get(Configs.CACHE_EXPIRATION_TIME) > 0L) {
            builder.expireAfterWrite(((Long)cacheConfig.get(Configs.CACHE_EXPIRATION_TIME)).longValue(), TimeUnit.MILLISECONDS);
        }
        if (((Boolean)cacheConfig.get(Configs.CACHE_STATS_ENABLED)).booleanValue()) {
            builder.recordStats();
        }
        return builder;
    }

    private boolean invalidateEntities(NameIdentifier identifier, Entity.EntityType type, Optional<SupportsRelationOperations.Type> relTypeOpt) {
        ArrayDeque<EntityCacheRelationKey> queue = new ArrayDeque<EntityCacheRelationKey>();
        EntityCacheRelationKey valueForExactKey = (EntityCacheRelationKey)this.cacheIndex.getValueForExactKey((CharSequence)(relTypeOpt.isEmpty() ? EntityCacheRelationKey.of(identifier, type).toString() : EntityCacheRelationKey.of(identifier, type, relTypeOpt.get()).toString()));
        if (valueForExactKey == null) {
            valueForExactKey = EntityCacheRelationKey.of(identifier, type, relTypeOpt.orElse(null));
        }
        HashSet visited = Sets.newHashSet();
        queue.offer(valueForExactKey);
        while (!queue.isEmpty()) {
            EntityCacheKey currentKeyToRemove = (EntityCacheKey)queue.poll();
            if (visited.contains(currentKeyToRemove)) continue;
            visited.add(currentKeyToRemove);
            this.cacheData.invalidate((Object)currentKeyToRemove);
            this.cacheIndex.remove((CharSequence)currentKeyToRemove.toString());
            ArrayList relatedEntityKeysToRemove = Lists.newArrayList((Iterable)this.cacheIndex.getValuesForKeysStartingWith((CharSequence)currentKeyToRemove.identifier().toString()));
            queue.addAll(relatedEntityKeysToRemove);
            ArrayList reverseKeysToRemove = Lists.newArrayList(this.reverseIndex.getValuesForKeysStartingWith(currentKeyToRemove.identifier().toString()));
            reverseKeysToRemove.forEach(key -> key.stream().forEach(k -> this.reverseIndex.getValuesForKeysStartingWith(k.toString()).forEach(rsk -> rsk.forEach(v -> this.reverseIndex.remove((EntityCacheKey)v)))));
            this.reverseIndex.remove(currentKeyToRemove);
            HashSet toAdd = Sets.newHashSet((Iterable)reverseKeysToRemove.stream().flatMap(Collection::stream).collect(Collectors.toList()));
            queue.addAll(toAdd);
        }
        return true;
    }

    private void startCacheStatsMonitor() {
        this.scheduler.scheduleAtFixedRate(() -> {
            CacheStats stats = this.cacheData.stats();
            LOG.info("[Cache Stats] hitRate={}, hitCount={}, missCount={}, loadSuccess={}, loadFailure={}, evictions={}", new Object[]{String.format("%.4f", stats.hitRate()), stats.hitCount(), stats.missCount(), stats.loadSuccessCount(), stats.loadFailureCount(), stats.evictionCount()});
        }, 0L, 5L, TimeUnit.MINUTES);
    }

    private void checkArguments(NameIdentifier ident, Entity.EntityType type, SupportsRelationOperations.Type relType) {
        this.checkArguments(ident, type);
        Preconditions.checkArgument((relType != null ? 1 : 0) != 0, (Object)"relType cannot be null");
    }

    private void checkArguments(NameIdentifier ident, Entity.EntityType type) {
        Preconditions.checkArgument((ident != null ? 1 : 0) != 0, (Object)"NameIdentifier cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
    }
}

