/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.service;

import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.model.ErrorResponse;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.gravitino.exceptions.NotFoundException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LanceExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(LanceExceptionMapper.class);

    public static Response toRESTResponse(String instance, Exception ex) {
        LanceNamespaceException lanceException = ex instanceof LanceNamespaceException ? (LanceNamespaceException)ex : LanceExceptionMapper.toLanceNamespaceException(instance, ex);
        return LanceExceptionMapper.handleLanceNamespaceException(lanceException);
    }

    public Response toResponse(Exception ex) {
        return LanceExceptionMapper.toRESTResponse("", ex);
    }

    private static LanceNamespaceException toLanceNamespaceException(String instance, Exception ex) {
        if (ex instanceof NotFoundException) {
            return LanceNamespaceException.notFound((String)ex.getMessage(), (String)ex.getClass().getSimpleName(), (String)instance, (String)ExceptionUtils.getStackTrace((Throwable)ex));
        }
        if (ex instanceof IllegalArgumentException) {
            return LanceNamespaceException.badRequest((String)ex.getMessage(), (String)ex.getClass().getSimpleName(), (String)instance, (String)ExceptionUtils.getStackTrace((Throwable)ex));
        }
        if (ex instanceof TableAlreadyExistsException) {
            return LanceNamespaceException.conflict((String)ex.getMessage(), (String)ex.getClass().getSimpleName(), (String)instance, (String)ExceptionUtils.getStackTrace((Throwable)ex));
        }
        if (ex instanceof UnsupportedOperationException) {
            return LanceNamespaceException.unsupportedOperation((String)ex.getMessage(), (String)ex.getClass().getSimpleName(), (String)instance, (String)ExceptionUtils.getStackTrace((Throwable)ex));
        }
        LOG.warn("Lance REST server unexpected exception:", (Throwable)ex);
        return LanceNamespaceException.serverError((String)ex.getMessage(), (String)ex.getClass().getSimpleName(), (String)instance, (String)ExceptionUtils.getStackTrace((Throwable)ex));
    }

    private static Response handleLanceNamespaceException(LanceNamespaceException ex) {
        ErrorResponse errResp = new ErrorResponse();
        Optional errorResponse = ex.getErrorResponse();
        if (errorResponse.isPresent() && ((ErrorResponse)errorResponse.get()).getCode() != null) {
            errResp = (ErrorResponse)errorResponse.get();
        } else {
            errResp.setCode(Integer.valueOf(ex.getCode()));
            errResp.setError(ex.getMessage());
        }
        return Response.status((int)errResp.getCode()).entity((Object)errResp).build();
    }
}

