/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.jmx.JmxReporter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import io.prometheus.client.exporter.MetricsServlet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.metrics.GravitinoSampleBuilder;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsSystem
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsSystem.class);
    private final String name;
    private final MetricRegistry metricRegistry;
    private HashMap<String, MetricsSource> metricSources = new HashMap();
    private List<Reporter> metricsReporters = new ArrayList<Reporter>();
    private CollectorRegistry prometheusRegistry;

    public MetricsSystem() {
        this("");
    }

    public MetricsSystem(String name) {
        this.name = name;
        this.metricRegistry = new MetricRegistry();
        this.prometheusRegistry = new CollectorRegistry();
    }

    public synchronized void register(MetricsSource metricsSource) {
        LOG.info("Register {} to metrics system {}", (Object)metricsSource.getMetricsSourceName(), (Object)this.name);
        if (this.metricSources.containsKey(metricsSource.getMetricsSourceName())) {
            MetricsSource originalMetricsSource = this.metricSources.get(metricsSource.getMetricsSourceName());
            Preconditions.checkState((boolean)metricsSource.getClass().getName().equals(originalMetricsSource.getClass().getName()), (String)"Metrics source name %s is already registered, and it's class name is %s, but the new metrics source class name is %s", (Object)metricsSource.getMetricsSourceName(), (Object)originalMetricsSource.getClass().getName(), (Object)metricsSource.getClass().getName());
            this.unregister(originalMetricsSource);
        }
        this.metricSources.put(metricsSource.getMetricsSourceName(), metricsSource);
        this.metricRegistry.register(metricsSource.getMetricsSourceName(), (Metric)metricsSource.getMetricRegistry());
    }

    public synchronized void unregister(MetricsSource metricsSource) {
        MetricsSource oldMetricsSource = this.metricSources.get(metricsSource.getMetricsSourceName());
        if (oldMetricsSource == null) {
            LOG.info("Unregister {} metrics source failed, it's not registered", (Object)metricsSource.getMetricsSourceName());
            return;
        }
        if (!oldMetricsSource.equals(metricsSource)) {
            LOG.info("Unregister {} metrics source failed, it's not the same object that registered", (Object)metricsSource.getMetricsSourceName());
            return;
        }
        this.metricSources.remove(metricsSource.getMetricsSourceName());
        this.metricRegistry.removeMatching(MetricFilter.startsWith((String)(metricsSource.getMetricsSourceName() + ".")));
        LOG.info("Unregistered {} from metrics system {}", (Object)metricsSource.getMetricsSourceName(), (Object)this.name);
    }

    public MetricsSource getMetricsSource(String metricsSourceName) {
        return this.metricSources.get(metricsSourceName);
    }

    private void initAndStartMetricsReporter() {
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build();
        jmxReporter.start();
        this.metricsReporters.add((Reporter)jmxReporter);
    }

    public void start() {
        this.registerMetricsToPrometheusRegistry();
        this.initAndStartMetricsReporter();
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public void close() {
        this.metricsReporters.forEach(reporter -> {
            try {
                reporter.close();
            }
            catch (IOException exception) {
                LOG.warn("Close metrics reporter failed,", (Throwable)exception);
            }
        });
    }

    @VisibleForTesting
    static List<MapperConfig> getMetricNameAndLabelRules() {
        return Arrays.asList(new MapperConfig("iceberg-rest-server.*.*", "iceberg-rest-server_${1}", (Map)ImmutableMap.of((Object)"operation", (Object)"${0}")), new MapperConfig("lance-rest-server.*.*", "lance-rest-server_${1}", (Map)ImmutableMap.of((Object)"operation", (Object)"${0}")), new MapperConfig("gravitino-server.*.*", "gravitino-server_${1}", (Map)ImmutableMap.of((Object)"operation", (Object)"${0}")));
    }

    private void registerMetricsToPrometheusRegistry() {
        GravitinoSampleBuilder sampleBuilder = new GravitinoSampleBuilder(MetricsSystem.getMetricNameAndLabelRules());
        DropwizardExports dropwizardExports = new DropwizardExports(this.metricRegistry, (SampleBuilder)sampleBuilder);
        dropwizardExports.register(this.prometheusRegistry);
    }

    public MetricsServlet getPrometheusServlet() {
        return new MetricsServlet(this.prometheusRegistry);
    }
}

