/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.resolver.ArtifactResolver;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.gravitino.trino.connector.GravitinoConfig;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;

public class GravitinoConnectorPluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(GravitinoConnectorPluginManager.class);
    public static final String APP_CLASS_LOADER_NAME = "app";
    private static final String PLUGIN_NAME_PREFIX = "gravitino-";
    private static final String PLUGIN_CLASSLOADER_CLASS_NAME = "io.trino.server.PluginClassLoader";
    private static volatile GravitinoConnectorPluginManager instance;
    private Class<?> pluginLoaderClass;
    private final Map<String, Plugin> connectorPlugins = new HashMap<String, Plugin>();
    private final ClassLoader appClassloader;

    private GravitinoConnectorPluginManager(ClassLoader classLoader) {
        this.appClassloader = classLoader;
        try {
            this.pluginLoaderClass = this.appClassloader.loadClass(PLUGIN_CLASSLOADER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Can not load Plugin class loader", (Throwable)e);
        }
        if (GravitinoConfig.trinoConfig.contains("plugin.bundles")) {
            this.loadPluginsFromBundle();
        } else {
            this.loadPluginsFromFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GravitinoConnectorPluginManager instance(ClassLoader classLoader) {
        if (instance != null) {
            return instance;
        }
        Class<GravitinoConnectorPluginManager> clazz = GravitinoConnectorPluginManager.class;
        synchronized (GravitinoConnectorPluginManager.class) {
            if (instance == null) {
                if (!APP_CLASS_LOADER_NAME.equals(classLoader.getName())) {
                    throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Can not initialize GravitinoConnectorPluginManager when classLoader is not appClassLoader");
                }
                instance = new GravitinoConnectorPluginManager(classLoader);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static GravitinoConnectorPluginManager instance() {
        if (instance == null) {
            throw new IllegalStateException("Need to call the function instance(ClassLoader) first");
        }
        return instance;
    }

    private void loadPluginsFromFile() {
        try {
            String jarPath = GravitinoConnectorPluginManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            String pluginDir = Paths.get(jarPath, new String[0]).getParent().getParent().toString();
            Arrays.stream(new File(pluginDir).listFiles()).forEach(file -> {
                this.loadPlugin(pluginDir, file.getName());
                LOG.info("Load plugin {}/{} successful", (Object)pluginDir, (Object)file.getName());
            });
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Error while loading plugins from file", (Throwable)e);
        }
    }

    private void loadPlugin(String pluginPath, String pluginName) {
        String dirName = pluginPath + "/" + pluginName;
        File directory = new File(dirName);
        File[] pluginFiles = directory.listFiles();
        if (pluginFiles == null || pluginFiles.length == 0) {
            LOG.warn("Can not load plugin {} from empty directory {}", (Object)pluginName, (Object)dirName);
            return;
        }
        List<URL> files = Arrays.stream(pluginFiles).map(File::toURI).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toList();
        this.loadPluginWithUrls(files, pluginName);
    }

    private void loadPluginWithUrls(List<URL> urls, String pluginName) {
        try {
            Constructor<?> constructor = this.pluginLoaderClass.getConstructor(String.class, List.class, ClassLoader.class, List.class);
            String classLoaderName = PLUGIN_NAME_PREFIX + pluginName;
            Object pluginClassLoader = constructor.newInstance(classLoaderName, urls, this.appClassloader, List.of("io.trino.spi.", "com.fasterxml.jackson.annotation.", "io.airlift.slice.", "org.openjdk.jol.", "io.opentelemetry.api.", "io.opentelemetry.context."));
            ServiceLoader<Plugin> serviceLoader = ServiceLoader.load(Plugin.class, (ClassLoader)pluginClassLoader);
            ImmutableList pluginList = ImmutableList.copyOf(serviceLoader);
            if (pluginList.isEmpty()) {
                LOG.warn("The {} plugin directory does not found connector SIP interface", (Object)pluginName);
                return;
            }
            Plugin plugin = (Plugin)pluginList.get(0);
            if (plugin.getConnectorFactories() == null || !plugin.getConnectorFactories().iterator().hasNext()) {
                LOG.warn("The {} plugin does not contains any ConnectorFactories ", (Object)pluginName);
                return;
            }
            this.connectorPlugins.put(pluginName, (Plugin)pluginList.get(0));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Failed to load Plugin " + pluginName, (Throwable)e);
        }
    }

    private void loadPluginsFromBundle() {
        ArtifactResolver artifactResolver = new ArtifactResolver(ArtifactResolver.USER_LOCAL_REPO, new String[]{"https://repo1.maven.org/maven2/"});
        String value = GravitinoConfig.trinoConfig.getProperty("plugin.bundles");
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        splitter.splitToList((CharSequence)value).forEach(v -> {
            int start = v.indexOf("trino-");
            if (start == -1) {
                return;
            }
            int end = v.indexOf(47, start);
            if (end == -1) {
                return;
            }
            String key = v.substring(start, end).replace("trino-", "");
            try {
                this.loadPluginByPom(artifactResolver.resolvePom(new File((String)v)), key);
            }
            catch (Exception e) {
                LOG.error("Fatal error in load plugin by {}", v, (Object)e);
            }
        });
    }

    private void loadPluginByPom(List<Artifact> artifacts, String pluginName) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Artifact artifact : artifacts) {
                if (artifact.getFile() == null) {
                    throw new RuntimeException("Could not resolve artifact: " + String.valueOf(artifact));
                }
                File file = artifact.getFile().getCanonicalFile();
                urls.add(file.toURI().toURL());
            }
            File root = new File(artifacts.get(0).getFile().getParentFile().getCanonicalFile(), "plugin-discovery");
            urls.add(root.toURI().toURL());
            this.loadPluginWithUrls(urls, pluginName);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Error while loading plugins from pom", (Throwable)e);
        }
    }

    public void installPlugin(String pluginName, Plugin plugin) {
        this.connectorPlugins.put(pluginName, plugin);
    }

    public Connector createConnector(String connectorName, Map<String, String> config, ConnectorContext context) {
        Connector connector;
        Plugin plugin = this.connectorPlugins.get(connectorName);
        if (plugin == null) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Can not found plugin for connector " + connectorName);
        }
        ThreadContextClassLoader ignored = new ThreadContextClassLoader(plugin.getClass().getClassLoader());
        try {
            ConnectorFactory connectorFactory = (ConnectorFactory)plugin.getConnectorFactories().iterator().next();
            Connector connector2 = connectorFactory.create(connectorName, config, context);
            LOG.info("create connector {} with config {} successful", (Object)connectorName, config);
            connector = connector2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Failed to create connector " + connectorName, (Throwable)e);
            }
        }
        ignored.close();
        return connector;
    }

    public ClassLoader getClassLoader(String classLoaderName) {
        if (classLoaderName.equals(APP_CLASS_LOADER_NAME)) {
            return this.appClassloader;
        }
        Plugin plugin = this.connectorPlugins.get(classLoaderName.substring(PLUGIN_NAME_PREFIX.length()));
        if (plugin == null) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Can not found class loader for " + classLoaderName);
        }
        return plugin.getClass().getClassLoader();
    }

    public ClassLoader getAppClassloader() {
        return this.appClassloader;
    }
}

