/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.SortedMerge;
import org.apache.iceberg.variants.SerializedObject;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantUtil;
import org.apache.iceberg.variants.VariantValue;

public class ShreddedObject
implements VariantObject {
    private final VariantMetadata metadata;
    private final VariantObject unshredded;
    private final Map<String, VariantValue> shreddedFields = Maps.newHashMap();
    private final Set<String> removedFields = Sets.newHashSet();
    private SerializationState serializationState = null;

    ShreddedObject(VariantMetadata metadata) {
        this(metadata, null);
    }

    ShreddedObject(VariantMetadata metadata, VariantObject unshredded) {
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"Invalid metadata: null");
        this.metadata = metadata;
        this.unshredded = unshredded;
    }

    @VisibleForTesting
    VariantMetadata metadata() {
        return this.metadata;
    }

    private Set<String> nameSet() {
        TreeSet names = Sets.newTreeSet(this.shreddedFields.keySet());
        if (this.unshredded != null) {
            Iterables.addAll((Collection)names, (Iterable)this.unshredded.fieldNames());
        }
        names.removeAll(this.removedFields);
        return names;
    }

    public Iterable<String> fieldNames() {
        return this.nameSet();
    }

    public int numFields() {
        return this.nameSet().size();
    }

    public void remove(String field) {
        this.shreddedFields.remove(field);
        this.removedFields.add(field);
    }

    public void put(String field, VariantValue value) {
        Preconditions.checkArgument((this.metadata.id(field) >= 0 ? 1 : 0) != 0, (String)"Cannot find field name in metadata: %s", (Object)field);
        this.shreddedFields.put(field, value);
        this.serializationState = null;
    }

    public VariantValue get(String field) {
        if (this.removedFields.contains(field)) {
            return null;
        }
        VariantValue value = this.shreddedFields.get(field);
        if (value != null) {
            return value;
        }
        if (this.unshredded != null) {
            return this.unshredded.get(field);
        }
        return null;
    }

    public int sizeInBytes() {
        if (null == this.serializationState) {
            this.serializationState = new SerializationState(this.metadata, this.unshredded, this.shreddedFields, this.removedFields);
        }
        return this.serializationState.size();
    }

    public int writeTo(ByteBuffer buffer, int offset) {
        Preconditions.checkArgument((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0, (Object)"Invalid byte order: big endian");
        if (null == this.serializationState) {
            this.serializationState = new SerializationState(this.metadata, this.unshredded, this.shreddedFields, this.removedFields);
        }
        return this.serializationState.writeTo(buffer, offset);
    }

    public String toString() {
        return VariantObject.asString((VariantObject)this);
    }

    private static class SerializationState {
        private final VariantMetadata metadata;
        private final Map<String, ByteBuffer> unshreddedFields;
        private final Map<String, VariantValue> shreddedFields;
        private final int dataSize;
        private final int numElements;
        private final boolean isLarge;
        private final int fieldIdSize;
        private final int offsetSize;

        private SerializationState(VariantMetadata metadata, VariantObject unshredded, Map<String, VariantValue> shreddedFields, Set<String> removedFields) {
            this.metadata = metadata;
            this.fieldIdSize = VariantUtil.sizeOf((int)metadata.dictionarySize());
            this.shreddedFields = Maps.newHashMap(shreddedFields);
            int totalDataSize = 0;
            ImmutableMap.Builder unshreddedBuilder = ImmutableMap.builder();
            if (unshredded instanceof SerializedObject) {
                SerializedObject serialized = (SerializedObject)unshredded;
                for (Map.Entry field : serialized.fields()) {
                    String name = (String)field.getKey();
                    boolean replaced = shreddedFields.containsKey(name) || removedFields.contains(name);
                    if (replaced) continue;
                    ByteBuffer value = serialized.sliceValue(((Integer)field.getValue()).intValue());
                    unshreddedBuilder.put((Object)name, (Object)value);
                    totalDataSize += value.remaining();
                }
            } else if (unshredded != null) {
                for (String name : unshredded.fieldNames()) {
                    boolean replaced = shreddedFields.containsKey(name) || removedFields.contains(name);
                    if (replaced) continue;
                    shreddedFields.put(name, unshredded.get(name));
                }
            }
            this.unshreddedFields = unshreddedBuilder.build();
            this.numElements = this.unshreddedFields.size() + shreddedFields.size();
            this.isLarge = this.numElements > 255;
            for (VariantValue value : shreddedFields.values()) {
                totalDataSize += value.sizeInBytes();
            }
            this.dataSize = totalDataSize;
            this.offsetSize = VariantUtil.sizeOf((int)totalDataSize);
        }

        private int size() {
            return 1 + (this.isLarge ? 4 : 1) + this.numElements * this.fieldIdSize + (1 + this.numElements) * this.offsetSize + this.dataSize;
        }

        private int writeTo(ByteBuffer buffer, int offset) {
            int fieldIdListOffset = offset + 1 + (this.isLarge ? 4 : 1);
            int offsetListOffset = fieldIdListOffset + this.numElements * this.fieldIdSize;
            int dataOffset = offsetListOffset + (1 + this.numElements) * this.offsetSize;
            byte header = VariantUtil.objectHeader((boolean)this.isLarge, (int)this.fieldIdSize, (int)this.offsetSize);
            VariantUtil.writeByte((ByteBuffer)buffer, (int)header, (int)offset);
            VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)this.numElements, (int)(offset + 1), (int)(this.isLarge ? 4 : 1));
            CloseableIterable fields = SortedMerge.of(() -> this.unshreddedFields.keySet().stream().sorted().iterator(), () -> this.shreddedFields.keySet().stream().sorted().iterator());
            int nextValueOffset = 0;
            int index = 0;
            for (String field : fields) {
                int id = this.metadata.id(field);
                Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (String)"Invalid metadata, missing: %s", (Object)field);
                VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)id, (int)(fieldIdListOffset + index * this.fieldIdSize), (int)this.fieldIdSize);
                VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextValueOffset, (int)(offsetListOffset + index * this.offsetSize), (int)this.offsetSize);
                VariantValue shreddedValue = this.shreddedFields.get(field);
                int valueSize = shreddedValue != null ? shreddedValue.writeTo(buffer, dataOffset + nextValueOffset) : VariantUtil.writeBufferAbsolute((ByteBuffer)buffer, (int)(dataOffset + nextValueOffset), (ByteBuffer)this.unshreddedFields.get(field));
                nextValueOffset += valueSize;
                ++index;
            }
            VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextValueOffset, (int)(offsetListOffset + index * this.offsetSize), (int)this.offsetSize);
            return dataOffset - offset + this.dataSize;
        }
    }
}

