/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Locale;
import org.apache.polaris.core.storage.ImmutableFileStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.immutables.PolarisImmutable;

@JsonSerialize(as=ImmutableFileStorageConfigurationInfo.class)
@JsonDeserialize(as=ImmutableFileStorageConfigurationInfo.class)
@JsonTypeName(value="FileStorageConfigurationInfo")
@PolarisImmutable
public abstract class FileStorageConfigurationInfo
extends PolarisStorageConfigurationInfo {
    public static ImmutableFileStorageConfigurationInfo.Builder builder() {
        return ImmutableFileStorageConfigurationInfo.builder();
    }

    @Override
    public String getFileIoImplClassName() {
        return "org.apache.iceberg.hadoop.HadoopFileIO";
    }

    @Override
    public PolarisStorageConfigurationInfo.StorageType getStorageType() {
        return PolarisStorageConfigurationInfo.StorageType.FILE;
    }

    @Override
    public void validatePrefixForStorageType(String loc) {
        if (this.getStorageType().getPrefixes().stream().noneMatch(p -> loc.toLowerCase(Locale.ROOT).startsWith((String)p)) && !loc.startsWith("file:/") && !loc.startsWith("/") && !loc.equals("*")) {
            throw new IllegalArgumentException(String.format("Location prefix not allowed: '%s', expected prefix: file:// or / or *", loc));
        }
    }
}

