/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.rest;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.iceberg.rest.Endpoint;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.RealmConfig;

public class PolarisEndpoints {
    public static final Endpoint V1_LIST_GENERIC_TABLES = Endpoint.create((String)"GET", (String)"polaris/v1/{prefix}/namespaces/{namespace}/generic-tables");
    public static final Endpoint V1_LOAD_GENERIC_TABLE = Endpoint.create((String)"GET", (String)"polaris/v1/{prefix}/namespaces/{namespace}/generic-tables/{generic-table}");
    public static final Endpoint V1_CREATE_GENERIC_TABLE = Endpoint.create((String)"POST", (String)"polaris/v1/{prefix}/namespaces/{namespace}/generic-tables");
    public static final Endpoint V1_DELETE_GENERIC_TABLE = Endpoint.create((String)"DELETE", (String)"polaris/v1/{prefix}/namespaces/{namespace}/generic-tables/{generic-table}");
    public static final Set<Endpoint> GENERIC_TABLE_ENDPOINTS = ImmutableSet.builder().add((Object)V1_LIST_GENERIC_TABLES).add((Object)V1_CREATE_GENERIC_TABLE).add((Object)V1_DELETE_GENERIC_TABLE).add((Object)V1_LOAD_GENERIC_TABLE).build();
    public static final Endpoint V1_LIST_POLICIES = Endpoint.create((String)"GET", (String)"/polaris/v1/{prefix}/namespaces/{namespace}/policies");
    public static final Endpoint V1_CREATE_POLICY = Endpoint.create((String)"POST", (String)"/polaris/v1/{prefix}/namespaces/{namespace}/policies");
    public static final Endpoint V1_LOAD_POLICY = Endpoint.create((String)"GET", (String)"/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}");
    public static final Endpoint V1_UPDATE_POLICY = Endpoint.create((String)"PUT", (String)"/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}");
    public static final Endpoint V1_DROP_POLICY = Endpoint.create((String)"DELETE", (String)"/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}");
    public static final Endpoint V1_ATTACH_POLICY = Endpoint.create((String)"PUT", (String)"/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}/mappings");
    public static final Endpoint V1_DETACH_POLICY = Endpoint.create((String)"POST", (String)"/polaris/v1/{prefix}/namespaces/{namespace}/policies/{policy-name}/mappings");
    public static final Endpoint V1_GET_APPLICABLE_POLICIES = Endpoint.create((String)"GET", (String)"/polaris/v1/{prefix}/applicable-policies");
    public static final Set<Endpoint> POLICY_STORE_ENDPOINTS = ImmutableSet.builder().add((Object)V1_LIST_POLICIES).add((Object)V1_CREATE_POLICY).add((Object)V1_LOAD_POLICY).add((Object)V1_UPDATE_POLICY).add((Object)V1_DROP_POLICY).add((Object)V1_ATTACH_POLICY).add((Object)V1_DETACH_POLICY).add((Object)V1_GET_APPLICABLE_POLICIES).build();

    public static Set<Endpoint> getSupportedGenericTableEndpoints(RealmConfig realmConfig) {
        boolean genericTableEnabled = realmConfig.getConfig(FeatureConfiguration.ENABLE_GENERIC_TABLES);
        return genericTableEnabled ? GENERIC_TABLE_ENDPOINTS : ImmutableSet.of();
    }

    public static Set<Endpoint> getSupportedPolicyEndpoints(RealmConfig realmConfig) {
        boolean policyStoreEnabled = realmConfig.getConfig(FeatureConfiguration.ENABLE_POLICY_STORE);
        return policyStoreEnabled ? POLICY_STORE_ENDPOINTS : ImmutableSet.of();
    }
}

