/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.polaris.core.storage.StorageAccessConfig;
import org.immutables.value.Generated;

@Generated(from="StorageAccessConfig", generator="Immutables")
public final class ImmutableStorageAccessConfig
implements StorageAccessConfig {
    private final ImmutableMap<String, String> credentials;
    private final ImmutableMap<String, String> extraProperties;
    private final ImmutableMap<String, String> internalProperties;
    private final Instant expiresAt;
    private final boolean supportsCredentialVending;
    private transient int hashCode;

    private ImmutableStorageAccessConfig(Builder builder) {
        this.credentials = builder.credentials.build();
        this.extraProperties = builder.extraProperties.build();
        this.internalProperties = builder.internalProperties.build();
        this.expiresAt = builder.expiresAt;
        this.supportsCredentialVending = builder.supportsCredentialVendingIsSet() ? builder.supportsCredentialVending : StorageAccessConfig.super.supportsCredentialVending();
    }

    private ImmutableStorageAccessConfig(ImmutableMap<String, String> credentials, ImmutableMap<String, String> extraProperties, ImmutableMap<String, String> internalProperties, Instant expiresAt, boolean supportsCredentialVending) {
        this.credentials = credentials;
        this.extraProperties = extraProperties;
        this.internalProperties = internalProperties;
        this.expiresAt = expiresAt;
        this.supportsCredentialVending = supportsCredentialVending;
    }

    public ImmutableMap<String, String> credentials() {
        return this.credentials;
    }

    public ImmutableMap<String, String> extraProperties() {
        return this.extraProperties;
    }

    public ImmutableMap<String, String> internalProperties() {
        return this.internalProperties;
    }

    @Override
    public Optional<Instant> expiresAt() {
        return Optional.ofNullable(this.expiresAt);
    }

    @Override
    public boolean supportsCredentialVending() {
        return this.supportsCredentialVending;
    }

    public final ImmutableStorageAccessConfig withCredentials(Map<String, ? extends String> entries) {
        if (this.credentials == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableStorageAccessConfig((ImmutableMap<String, String>)newValue, this.extraProperties, this.internalProperties, this.expiresAt, this.supportsCredentialVending);
    }

    public final ImmutableStorageAccessConfig withExtraProperties(Map<String, ? extends String> entries) {
        if (this.extraProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableStorageAccessConfig(this.credentials, (ImmutableMap<String, String>)newValue, this.internalProperties, this.expiresAt, this.supportsCredentialVending);
    }

    public final ImmutableStorageAccessConfig withInternalProperties(Map<String, ? extends String> entries) {
        if (this.internalProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableStorageAccessConfig(this.credentials, this.extraProperties, (ImmutableMap<String, String>)newValue, this.expiresAt, this.supportsCredentialVending);
    }

    public final ImmutableStorageAccessConfig withExpiresAt(Instant value) {
        Instant newValue = Objects.requireNonNull(value, "expiresAt");
        if (this.expiresAt == newValue) {
            return this;
        }
        return new ImmutableStorageAccessConfig(this.credentials, this.extraProperties, this.internalProperties, newValue, this.supportsCredentialVending);
    }

    public final ImmutableStorageAccessConfig withExpiresAt(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.expiresAt == value) {
            return this;
        }
        return new ImmutableStorageAccessConfig(this.credentials, this.extraProperties, this.internalProperties, value, this.supportsCredentialVending);
    }

    public final ImmutableStorageAccessConfig withSupportsCredentialVending(boolean value) {
        if (this.supportsCredentialVending == value) {
            return this;
        }
        return new ImmutableStorageAccessConfig(this.credentials, this.extraProperties, this.internalProperties, this.expiresAt, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStorageAccessConfig && this.equalsByValue((ImmutableStorageAccessConfig)another);
    }

    private boolean equalsByValue(ImmutableStorageAccessConfig another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.credentials.equals(another.credentials) && this.extraProperties.equals(another.extraProperties) && this.internalProperties.equals(another.internalProperties) && Objects.equals(this.expiresAt, another.expiresAt) && this.supportsCredentialVending == another.supportsCredentialVending;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.credentials.hashCode();
        h += (h << 5) + this.extraProperties.hashCode();
        h += (h << 5) + this.internalProperties.hashCode();
        h += (h << 5) + Objects.hashCode(this.expiresAt);
        h += (h << 5) + Booleans.hashCode((boolean)this.supportsCredentialVending);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StorageAccessConfig").omitNullValues().add("credentials", this.credentials).add("extraProperties", this.extraProperties).add("internalProperties", this.internalProperties).add("expiresAt", (Object)this.expiresAt).add("supportsCredentialVending", this.supportsCredentialVending).toString();
    }

    public static ImmutableStorageAccessConfig copyOf(StorageAccessConfig instance) {
        if (instance instanceof ImmutableStorageAccessConfig) {
            return (ImmutableStorageAccessConfig)instance;
        }
        return ImmutableStorageAccessConfig.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableStorageAccessConfig.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StorageAccessConfig", generator="Immutables")
    public static final class Builder
    implements StorageAccessConfig.Builder {
        private static final long OPT_BIT_SUPPORTS_CREDENTIAL_VENDING = 1L;
        private long optBits;
        private ImmutableMap.Builder<String, String> credentials = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> extraProperties = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> internalProperties = ImmutableMap.builder();
        private Instant expiresAt;
        private boolean supportsCredentialVending;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StorageAccessConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllCredentials(instance.credentials());
            this.putAllExtraProperties(instance.extraProperties());
            this.putAllInternalProperties(instance.internalProperties());
            Optional<Instant> expiresAtOptional = instance.expiresAt();
            if (expiresAtOptional.isPresent()) {
                this.expiresAt(expiresAtOptional);
            }
            this.supportsCredentialVending(instance.supportsCredentialVending());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putCredential(String key, String value) {
            this.credentials.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCredential(Map.Entry<String, ? extends String> entry) {
            this.credentials.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentials(Map<String, ? extends String> entries) {
            this.credentials = ImmutableMap.builder();
            return this.putAllCredentials(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCredentials(Map<String, ? extends String> entries) {
            this.credentials.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putExtraProperty(String key, String value) {
            this.extraProperties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraProperty(Map.Entry<String, ? extends String> entry) {
            this.extraProperties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder extraProperties(Map<String, ? extends String> entries) {
            this.extraProperties = ImmutableMap.builder();
            return this.putAllExtraProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraProperties(Map<String, ? extends String> entries) {
            this.extraProperties.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putInternalProperty(String key, String value) {
            this.internalProperties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putInternalProperty(Map.Entry<String, ? extends String> entry) {
            this.internalProperties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder internalProperties(Map<String, ? extends String> entries) {
            this.internalProperties = ImmutableMap.builder();
            return this.putAllInternalProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllInternalProperties(Map<String, ? extends String> entries) {
            this.internalProperties.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = Objects.requireNonNull(expiresAt, "expiresAt");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiresAt(Optional<? extends Instant> expiresAt) {
            this.expiresAt = expiresAt.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder supportsCredentialVending(boolean supportsCredentialVending) {
            this.supportsCredentialVending = supportsCredentialVending;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.optBits = 0L;
            this.credentials = ImmutableMap.builder();
            this.extraProperties = ImmutableMap.builder();
            this.internalProperties = ImmutableMap.builder();
            this.expiresAt = null;
            this.supportsCredentialVending = false;
            return this;
        }

        @Override
        public ImmutableStorageAccessConfig build() {
            return new ImmutableStorageAccessConfig(this);
        }

        private boolean supportsCredentialVendingIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

