/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity.table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.table.TableLikeEntity;

public class IcebergTableLikeEntity
extends TableLikeEntity {
    public static final String METADATA_LOCATION_KEY = "metadata-location";
    public static final String USER_SPECIFIED_WRITE_DATA_LOCATION_KEY = "write.data.path";
    public static final String USER_SPECIFIED_WRITE_METADATA_LOCATION_KEY = "write.metadata.path";
    public static final String LAST_ADMITTED_NOTIFICATION_TIMESTAMP_KEY = "last-notification-timestamp";
    public static final String FORMAT_VERSION = "format-version";
    public static final String TABLE_UUID = "table-uuid";
    public static final String LOCATION = "location";
    public static final String LAST_SEQUENCE_NUMBER = "last-sequence-number";
    public static final String LAST_UPDATED_MILLIS = "last-updated-ms";
    public static final String LAST_COLUMN_ID = "last-column-id";
    public static final String SCHEMA = "schema";
    public static final String SCHEMAS = "schemas";
    public static final String CURRENT_SCHEMA_ID = "current-schema-id";
    public static final String PARTITION_SPEC = "partition-spec";
    public static final String PARTITION_SPECS = "partition-specs";
    public static final String DEFAULT_SPEC_ID = "default-spec-id";
    public static final String LAST_PARTITION_ID = "last-partition-id";
    public static final String DEFAULT_SORT_ORDER_ID = "default-sort-order-id";
    public static final String SORT_ORDERS = "sort-orders";
    public static final String PROPERTIES = "properties";
    public static final String CURRENT_SNAPSHOT_ID = "current-snapshot-id";
    public static final String REFS = "refs";
    public static final String SNAPSHOTS = "snapshots";
    public static final String SNAPSHOT_ID = "snapshot-id";
    public static final String TIMESTAMP_MS = "timestamp-ms";
    public static final String SNAPSHOT_LOG = "snapshot-log";
    public static final String METADATA_FILE = "metadata-file";
    public static final String METADATA_LOG = "metadata-log";
    public static final String STATISTICS = "statistics";
    public static final String PARTITION_STATISTICS = "partition-statistics";
    public static final String ENCRYPTION_KEYS = "encryption-keys";
    public static final String NEXT_ROW_ID = "next-row-id";

    public IcebergTableLikeEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
        PolarisEntitySubType subType = this.getSubType();
        Preconditions.checkState((subType == PolarisEntitySubType.ICEBERG_TABLE || subType == PolarisEntitySubType.ICEBERG_VIEW ? 1 : 0) != 0, (String)"Invalid entity sub type: %s", (Object)((Object)subType));
    }

    @Nullable
    public static IcebergTableLikeEntity of(@Nullable PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new IcebergTableLikeEntity(sourceEntity);
        }
        return null;
    }

    @JsonIgnore
    public String getMetadataLocation() {
        return this.getInternalPropertiesAsMap().get(METADATA_LOCATION_KEY);
    }

    @JsonIgnore
    public Optional<Long> getLastAdmittedNotificationTimestamp() {
        return Optional.ofNullable(this.getInternalPropertiesAsMap().get(LAST_ADMITTED_NOTIFICATION_TIMESTAMP_KEY)).map(Long::parseLong);
    }

    @Override
    @JsonIgnore
    public String getBaseLocation() {
        return this.getPropertiesAsMap().get(LOCATION);
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<IcebergTableLikeEntity, Builder> {
        public Builder(PolarisEntitySubType subType, TableIdentifier identifier, Map<String, String> properties, Map<String, String> internalProperties, String metadataLocation) {
            this.setType(PolarisEntityType.TABLE_LIKE);
            this.setSubType(subType);
            this.setProperties(properties);
            this.setInternalProperties((Map)internalProperties);
            this.setTableIdentifier(identifier);
            this.setMetadataLocation(metadataLocation);
        }

        public Builder(PolarisEntitySubType subType, TableIdentifier identifier, String metadataLocation) {
            this.setType(PolarisEntityType.TABLE_LIKE);
            this.setSubType(subType);
            this.setTableIdentifier(identifier);
            this.setMetadataLocation(metadataLocation);
        }

        public Builder(IcebergTableLikeEntity original) {
            super(original);
        }

        @Override
        public IcebergTableLikeEntity build() {
            return new IcebergTableLikeEntity(this.buildBase());
        }

        public Builder setTableIdentifier(TableIdentifier identifier) {
            Namespace namespace = identifier.namespace();
            this.setParentNamespace(namespace);
            this.setName(identifier.name());
            return this;
        }

        public Builder setParentNamespace(Namespace namespace) {
            if (namespace != null && !namespace.isEmpty()) {
                this.internalProperties.put("parent-namespace", RESTUtil.encodeNamespace((Namespace)namespace));
            }
            return this;
        }

        public Builder setBaseLocation(String location) {
            this.properties.put(IcebergTableLikeEntity.LOCATION, location);
            return this;
        }

        @Override
        public Builder setInternalProperties(@Nonnull Map<String, String> internalProperties) {
            HashMap<String, String> newInternalProperties = new HashMap<String, String>();
            if (this.internalProperties.get("parent-namespace") != null) {
                newInternalProperties.put("parent-namespace", (String)this.internalProperties.get("parent-namespace"));
            }
            if (this.internalProperties.get(IcebergTableLikeEntity.METADATA_LOCATION_KEY) != null) {
                newInternalProperties.put(IcebergTableLikeEntity.METADATA_LOCATION_KEY, (String)this.internalProperties.get(IcebergTableLikeEntity.METADATA_LOCATION_KEY));
            }
            if (this.internalProperties.get(IcebergTableLikeEntity.LAST_ADMITTED_NOTIFICATION_TIMESTAMP_KEY) != null) {
                newInternalProperties.put(IcebergTableLikeEntity.LAST_ADMITTED_NOTIFICATION_TIMESTAMP_KEY, (String)this.internalProperties.get(IcebergTableLikeEntity.LAST_ADMITTED_NOTIFICATION_TIMESTAMP_KEY));
            }
            newInternalProperties.putAll(internalProperties);
            return (Builder)super.setInternalProperties(newInternalProperties);
        }

        public Builder setMetadataLocation(String location) {
            this.internalProperties.put(IcebergTableLikeEntity.METADATA_LOCATION_KEY, location);
            return this;
        }

        public Builder setLastNotificationTimestamp(long timestamp) {
            this.internalProperties.put(IcebergTableLikeEntity.LAST_ADMITTED_NOTIFICATION_TIMESTAMP_KEY, String.valueOf(timestamp));
            return this;
        }
    }
}

