/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.polaris.extension.auth.opa.OpaAuthorizationConfig;
import org.immutables.value.Generated;

@Generated(from="OpaAuthorizationConfig.AuthenticationConfig", generator="Immutables")
public final class ImmutableAuthenticationConfig
implements OpaAuthorizationConfig.AuthenticationConfig {
    private final OpaAuthorizationConfig.AuthenticationType type;
    private final OpaAuthorizationConfig.BearerTokenConfig bearer;
    private transient int hashCode;

    private ImmutableAuthenticationConfig(OpaAuthorizationConfig.AuthenticationType type, OpaAuthorizationConfig.BearerTokenConfig bearer) {
        this.type = type;
        this.bearer = bearer;
    }

    @Override
    public OpaAuthorizationConfig.AuthenticationType type() {
        return this.type;
    }

    @Override
    public Optional<OpaAuthorizationConfig.BearerTokenConfig> bearer() {
        return Optional.ofNullable(this.bearer);
    }

    public final ImmutableAuthenticationConfig withType(OpaAuthorizationConfig.AuthenticationType value) {
        OpaAuthorizationConfig.AuthenticationType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableAuthenticationConfig(newValue, this.bearer);
    }

    public final ImmutableAuthenticationConfig withBearer(OpaAuthorizationConfig.BearerTokenConfig value) {
        OpaAuthorizationConfig.BearerTokenConfig newValue = Objects.requireNonNull(value, "bearer");
        if (this.bearer == newValue) {
            return this;
        }
        return new ImmutableAuthenticationConfig(this.type, newValue);
    }

    public final ImmutableAuthenticationConfig withBearer(Optional<? extends OpaAuthorizationConfig.BearerTokenConfig> optional) {
        OpaAuthorizationConfig.BearerTokenConfig value = optional.orElse(null);
        if (this.bearer == value) {
            return this;
        }
        return new ImmutableAuthenticationConfig(this.type, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthenticationConfig && this.equalsByValue((ImmutableAuthenticationConfig)another);
    }

    private boolean equalsByValue(ImmutableAuthenticationConfig another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.type.equals((Object)another.type) && Objects.equals(this.bearer, another.bearer);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.bearer);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AuthenticationConfig").omitNullValues().add("type", (Object)this.type).add("bearer", (Object)this.bearer).toString();
    }

    public static ImmutableAuthenticationConfig copyOf(OpaAuthorizationConfig.AuthenticationConfig instance) {
        if (instance instanceof ImmutableAuthenticationConfig) {
            return (ImmutableAuthenticationConfig)instance;
        }
        return ImmutableAuthenticationConfig.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableAuthenticationConfig.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OpaAuthorizationConfig.AuthenticationConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private OpaAuthorizationConfig.AuthenticationType type;
        private OpaAuthorizationConfig.BearerTokenConfig bearer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OpaAuthorizationConfig.AuthenticationConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            Optional<OpaAuthorizationConfig.BearerTokenConfig> bearerOptional = instance.bearer();
            if (bearerOptional.isPresent()) {
                this.bearer(bearerOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(OpaAuthorizationConfig.AuthenticationType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bearer(OpaAuthorizationConfig.BearerTokenConfig bearer) {
            this.bearer = Objects.requireNonNull(bearer, "bearer");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bearer(Optional<? extends OpaAuthorizationConfig.BearerTokenConfig> bearer) {
            this.bearer = bearer.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 1L;
            this.type = null;
            this.bearer = null;
            return this;
        }

        public ImmutableAuthenticationConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthenticationConfig(this.type, this.bearer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build AuthenticationConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

