/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.commons.model.ModelStatus;
import org.apache.iotdb.commons.model.ModelTable;
import org.apache.iotdb.commons.model.ModelType;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.read.model.GetModelInfoPlan;
import org.apache.iotdb.confignode.consensus.request.read.model.ShowModelPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.CreateModelPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.UpdateModelInfoPlan;
import org.apache.iotdb.confignode.consensus.response.model.GetModelInfoResp;
import org.apache.iotdb.confignode.consensus.response.model.ModelTableResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ModelInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelInfo.class);
    private static final String SNAPSHOT_FILENAME = "model_info.snapshot";
    private ModelTable modelTable;
    private final Map<String, List<Integer>> modelNameToNodes;
    private final ReadWriteLock modelTableLock = new ReentrantReadWriteLock();
    private static final Set<String> builtInForecastModel = new HashSet<String>();
    private static final Set<String> builtInAnomalyDetectionModel = new HashSet<String>();

    public ModelInfo() {
        this.modelTable = new ModelTable();
        this.modelNameToNodes = new HashMap<String, List<Integer>>();
    }

    public boolean contain(String modelName) {
        return this.modelTable.containsModel(modelName);
    }

    public void acquireModelTableReadLock() {
        LOGGER.info("acquire ModelTableReadLock");
        this.modelTableLock.readLock().lock();
    }

    public void releaseModelTableReadLock() {
        LOGGER.info("release ModelTableReadLock");
        this.modelTableLock.readLock().unlock();
    }

    public void acquireModelTableWriteLock() {
        LOGGER.info("acquire ModelTableWriteLock");
        this.modelTableLock.writeLock().lock();
    }

    public void releaseModelTableWriteLock() {
        LOGGER.info("release ModelTableWriteLock");
        this.modelTableLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createModel(CreateModelPlan plan) {
        try {
            this.acquireModelTableWriteLock();
            String modelName = plan.getModelName();
            this.modelTable.addModel(new ModelInformation(modelName, ModelStatus.LOADING));
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to add model [%s] in ModelTable on Config Nodes, because of %s", plan.getModelName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            TSStatus tSStatus = new TSStatus(TSStatusCode.CREATE_MODEL_ERROR.getStatusCode()).setMessage(errorMessage);
            return tSStatus;
        }
        finally {
            this.releaseModelTableWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus dropModelInNode(int aiNodeId) {
        this.acquireModelTableWriteLock();
        try {
            for (Map.Entry<String, List<Integer>> entry : this.modelNameToNodes.entrySet()) {
                entry.getValue().remove((Object)aiNodeId);
                if (!entry.getValue().isEmpty()) continue;
                this.modelTable.removeModel(entry.getKey());
                this.modelNameToNodes.remove(entry.getKey());
            }
            this.modelTable.clearFailedModel();
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseModelTableWriteLock();
        }
    }

    public TSStatus dropModel(String modelName) {
        TSStatus status;
        this.acquireModelTableWriteLock();
        if (this.modelTable.containsModel(modelName)) {
            this.modelTable.removeModel(modelName);
            this.modelNameToNodes.remove(modelName);
            status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        } else {
            status = new TSStatus(TSStatusCode.DROP_MODEL_ERROR.getStatusCode()).setMessage(String.format("model [%s] has not been created.", modelName));
        }
        this.releaseModelTableWriteLock();
        return status;
    }

    public List<Integer> getNodeIds(String modelName) {
        return this.modelNameToNodes.getOrDefault(modelName, Collections.emptyList());
    }

    private ModelInformation getModelByName(String modelName) {
        ModelType modelType = this.checkModelType(modelName);
        if (modelType != ModelType.USER_DEFINED) {
            if (modelType == ModelType.BUILT_IN_FORECAST && builtInForecastModel.contains(modelName)) {
                return new ModelInformation(ModelType.BUILT_IN_FORECAST, modelName);
            }
            if (modelType == ModelType.BUILT_IN_ANOMALY_DETECTION && builtInAnomalyDetectionModel.contains(modelName)) {
                return new ModelInformation(ModelType.BUILT_IN_ANOMALY_DETECTION, modelName);
            }
        } else {
            return this.modelTable.getModelInformationById(modelName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelTableResp showModel(ShowModelPlan plan) {
        this.acquireModelTableReadLock();
        try {
            ModelTableResp modelTableResp = new ModelTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
            if (plan.isSetModelName()) {
                ModelInformation modelInformation = this.getModelByName(plan.getModelName());
                if (modelInformation != null) {
                    modelTableResp.addModelInformation(modelInformation);
                }
            } else {
                modelTableResp.addModelInformation(this.modelTable.getAllModelInformation());
                for (String modelName : builtInForecastModel) {
                    modelTableResp.addModelInformation(new ModelInformation(ModelType.BUILT_IN_FORECAST, modelName));
                }
                for (String modelName : builtInAnomalyDetectionModel) {
                    modelTableResp.addModelInformation(new ModelInformation(ModelType.BUILT_IN_ANOMALY_DETECTION, modelName));
                }
            }
            Iterator<String> iterator = modelTableResp;
            return iterator;
        }
        catch (IOException e) {
            LOGGER.warn("Fail to get ModelTable", (Throwable)e);
            ModelTableResp modelTableResp = new ModelTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()));
            return modelTableResp;
        }
        finally {
            this.releaseModelTableReadLock();
        }
    }

    private boolean containsBuiltInModelName(Set<String> builtInModelSet, String modelName) {
        for (String builtInModelName : builtInModelSet) {
            if (!builtInModelName.equalsIgnoreCase(modelName)) continue;
            return true;
        }
        return false;
    }

    public ModelType checkModelType(String modelName) {
        if (this.containsBuiltInModelName(builtInForecastModel, modelName)) {
            return ModelType.BUILT_IN_FORECAST;
        }
        if (this.containsBuiltInModelName(builtInAnomalyDetectionModel, modelName)) {
            return ModelType.BUILT_IN_ANOMALY_DETECTION;
        }
        return ModelType.USER_DEFINED;
    }

    private int getAvailableAINodeForModel(String modelName, ModelType modelType) {
        if (modelType == ModelType.USER_DEFINED) {
            List<Integer> aiNodeIds = this.modelNameToNodes.get(modelName);
            if (aiNodeIds != null) {
                return aiNodeIds.get(0);
            }
        } else {
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetModelInfoResp getModelInfo(GetModelInfoPlan plan) {
        this.acquireModelTableReadLock();
        try {
            String modelName = plan.getModelId();
            ModelType modelType = this.checkModelType(modelName);
            ModelInformation modelInformation = modelType != ModelType.USER_DEFINED ? new ModelInformation(modelType, modelName) : this.modelTable.getModelInformationById(modelName);
            if (modelInformation == null) {
                GetModelInfoResp getModelInfoResp;
                TSStatus errorStatus = new TSStatus(TSStatusCode.GET_MODEL_INFO_ERROR.getStatusCode());
                errorStatus.setMessage(String.format("model [%s] has not been created.", modelName));
                GetModelInfoResp getModelInfoResp2 = getModelInfoResp = new GetModelInfoResp(errorStatus);
                return getModelInfoResp2;
            }
            GetModelInfoResp getModelInfoResp = new GetModelInfoResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
            PublicBAOS buffer = new PublicBAOS();
            DataOutputStream stream = new DataOutputStream((OutputStream)buffer);
            modelInformation.serialize(stream);
            int aiNodeId = this.getAvailableAINodeForModel(modelName, modelType);
            if (aiNodeId == -1) {
                TSStatus errorStatus = new TSStatus(TSStatusCode.GET_MODEL_INFO_ERROR.getStatusCode());
                errorStatus.setMessage(String.format("There is no AINode with %s available", modelName));
                GetModelInfoResp getModelInfoResp3 = getModelInfoResp = new GetModelInfoResp(errorStatus);
                return getModelInfoResp3;
            }
            getModelInfoResp.setTargetAINodeId(aiNodeId);
            GetModelInfoResp getModelInfoResp4 = getModelInfoResp;
            return getModelInfoResp4;
        }
        catch (IOException e) {
            LOGGER.warn("Fail to get model info", (Throwable)e);
            GetModelInfoResp getModelInfoResp = new GetModelInfoResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()));
            return getModelInfoResp;
        }
        finally {
            this.releaseModelTableReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus updateModelInfo(UpdateModelInfoPlan plan) {
        this.acquireModelTableWriteLock();
        try {
            String modelName = plan.getModelName();
            if (this.modelTable.containsModel(modelName)) {
                this.modelTable.updateModel(modelName, plan.getModelInformation());
            }
            if (!plan.getNodeIds().isEmpty()) {
                this.modelNameToNodes.put(modelName, plan.getNodeIds());
            }
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseModelTableWriteLock();
        }
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot of ModelInfo, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        this.acquireModelTableReadLock();
        try {
            boolean bl;
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                this.modelTable.serialize(fileOutputStream);
                ReadWriteIOUtils.write((int)this.modelNameToNodes.size(), (OutputStream)fileOutputStream);
                for (Map.Entry<String, List<Integer>> entry : this.modelNameToNodes.entrySet()) {
                    ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)fileOutputStream);
                    ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)fileOutputStream);
                    for (Integer nodeId : entry.getValue()) {
                        ReadWriteIOUtils.write((int)nodeId, (OutputStream)fileOutputStream);
                    }
                }
                fileOutputStream.getFD().sync();
                bl = true;
            }
            return bl;
        }
        finally {
            this.releaseModelTableReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot of ModelInfo, snapshot file [{}] does not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.acquireModelTableWriteLock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
            this.modelTable.clear();
            this.modelTable = ModelTable.deserialize((InputStream)fileInputStream);
            int size = ReadWriteIOUtils.readInt((InputStream)fileInputStream);
            for (int i = 0; i < size; ++i) {
                String modelName = ReadWriteIOUtils.readString((InputStream)fileInputStream);
                int nodeSize = ReadWriteIOUtils.readInt((InputStream)fileInputStream);
                LinkedList<Integer> nodes = new LinkedList<Integer>();
                for (int j = 0; j < nodeSize; ++j) {
                    nodes.add(ReadWriteIOUtils.readInt((InputStream)fileInputStream));
                }
                this.modelNameToNodes.put(modelName, nodes);
            }
        }
        finally {
            this.releaseModelTableWriteLock();
        }
    }

    static {
        builtInForecastModel.add("arima");
        builtInForecastModel.add("naive_forecaster");
        builtInForecastModel.add("stl_forecaster");
        builtInForecastModel.add("holtwinters");
        builtInForecastModel.add("exponential_smoothing");
        builtInForecastModel.add("timer_xl");
        builtInForecastModel.add("sundial");
        builtInAnomalyDetectionModel.add("gaussian_hmm");
        builtInAnomalyDetectionModel.add("gmm_hmm");
        builtInAnomalyDetectionModel.add("stray");
    }
}

