/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DecimalLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Extract;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericDataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.ExpressionFormatter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class Expression
extends Node {
    protected Expression(@Nullable NodeLocation location) {
        super(location);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExpression(this, context);
    }

    @Override
    public final String toString() {
        return ExpressionFormatter.formatExpression(this);
    }

    public TableExpressionType getExpressionType() {
        throw new UnsupportedOperationException("getExpressionType is not implemented yet: " + this.getClass().getSimpleName());
    }

    protected void serialize(ByteBuffer byteBuffer) {
    }

    protected void serialize(DataOutputStream stream) throws IOException {
    }

    public static void serialize(Expression expression, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((short)expression.getExpressionType().getExpressionTypeInShortEnum(), (ByteBuffer)byteBuffer);
        expression.serialize(byteBuffer);
    }

    public static void serialize(Expression expression, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)expression.getExpressionType().getExpressionTypeInShortEnum(), (OutputStream)stream);
        expression.serialize(stream);
    }

    public static Expression deserialize(ByteBuffer byteBuffer) {
        short type = ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
        Expression expression = null;
        switch (type) {
            case 1: {
                expression = new ArithmeticBinaryExpression(byteBuffer);
                break;
            }
            case 2: {
                expression = new ArithmeticUnaryExpression(byteBuffer);
                break;
            }
            case 3: {
                expression = new LikePredicate(byteBuffer);
                break;
            }
            case 4: {
                expression = new InListExpression(byteBuffer);
                break;
            }
            case 5: {
                expression = new IsNotNullPredicate(byteBuffer);
                break;
            }
            case 6: {
                expression = new IsNullPredicate(byteBuffer);
                break;
            }
            case 7: {
                expression = new FunctionCall(byteBuffer);
                break;
            }
            case 8: {
                expression = new Identifier(byteBuffer);
                break;
            }
            case 9: {
                expression = new Cast(byteBuffer);
                break;
            }
            case 10: {
                expression = new GenericDataType(byteBuffer);
                break;
            }
            case 11: {
                expression = new BetweenPredicate(byteBuffer);
                break;
            }
            case 12: {
                expression = new InPredicate(byteBuffer);
                break;
            }
            case 13: {
                expression = new LogicalExpression(byteBuffer);
                break;
            }
            case 14: {
                expression = new NotExpression(byteBuffer);
                break;
            }
            case 15: {
                expression = new ComparisonExpression(byteBuffer);
                break;
            }
            case 16: {
                expression = new BinaryLiteral(byteBuffer);
                break;
            }
            case 17: {
                expression = new BooleanLiteral(byteBuffer);
                break;
            }
            case 18: {
                expression = new DecimalLiteral(byteBuffer);
                break;
            }
            case 19: {
                expression = new DoubleLiteral(byteBuffer);
                break;
            }
            case 20: {
                expression = new GenericLiteral(byteBuffer);
                break;
            }
            case 21: {
                expression = new LongLiteral(byteBuffer);
                break;
            }
            case 22: {
                expression = new NullLiteral(byteBuffer);
                break;
            }
            case 23: {
                expression = new StringLiteral(byteBuffer);
                break;
            }
            case 24: {
                expression = new SymbolReference(byteBuffer);
                break;
            }
            case 25: {
                expression = new CoalesceExpression(byteBuffer);
                break;
            }
            case 26: {
                expression = new SimpleCaseExpression(byteBuffer);
                break;
            }
            case 27: {
                expression = new SearchedCaseExpression(byteBuffer);
                break;
            }
            case 28: {
                expression = new WhenClause(byteBuffer);
                break;
            }
            case 31: {
                expression = new Row(byteBuffer);
                break;
            }
            case 32: {
                expression = new Extract(byteBuffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid expression type: " + type);
            }
        }
        return expression;
    }
}

