/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class LoadModelStatement
extends Statement
implements IConfigStatement {
    private final String modelId;
    private final List<String> deviceIdList;

    public LoadModelStatement(String modelId, List<String> deviceIdList) {
        this.modelId = modelId;
        this.deviceIdList = deviceIdList;
    }

    public String getModelId() {
        return this.modelId;
    }

    public List<String> getDeviceIdList() {
        return this.deviceIdList;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitLoadModel(this, context);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadModelStatement that = (LoadModelStatement)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.deviceIdList, that.deviceIdList);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.deviceIdList);
    }

    public String toString() {
        return "LoadModelStatement{modelId='" + this.modelId + '\'' + ", deviceIdList=" + this.deviceIdList + '}';
    }
}

