/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.udf;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.UDFTable;
import org.apache.iotdb.commons.udf.UDFType;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinAggregationFunction;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinScalarFunction;
import org.apache.iotdb.commons.udf.service.UDFClassLoader;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.plan.relational.function.TableBuiltinTableFunction;
import org.apache.iotdb.db.queryengine.plan.udf.BuiltinAggregationFunction;
import org.apache.iotdb.db.queryengine.plan.udf.BuiltinScalarFunction;
import org.apache.iotdb.db.queryengine.plan.udf.BuiltinTimeSeriesGeneratingFunction;
import org.apache.iotdb.udf.api.UDF;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFManagementException;
import org.apache.iotdb.udf.api.relational.SQLFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFManagementService.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final UDFTable udfTable = new UDFTable();

    private UDFManagementService() {
        for (BuiltinTimeSeriesGeneratingFunction builtinTimeSeriesGeneratingFunction : BuiltinTimeSeriesGeneratingFunction.values()) {
            String functionName = builtinTimeSeriesGeneratingFunction.getFunctionName();
            this.udfTable.addUDFInformation(functionName, new UDFInformation(functionName.toUpperCase(), builtinTimeSeriesGeneratingFunction.getClassName(), UDFType.TREE_AVAILABLE));
            this.udfTable.addFunctionAndClass(Model.TREE, functionName, builtinTimeSeriesGeneratingFunction.getFunctionClass());
        }
    }

    public void acquireLock() {
        this.lock.lock();
    }

    public void releaseLock() {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(UDFInformation udfInformation, ByteBuffer jarFile) throws Exception {
        Model model = this.checkAndGetModel(udfInformation);
        try {
            this.acquireLock();
            this.checkIfRegistered(model, udfInformation);
            this.saveJarFile(udfInformation.getJarName(), jarFile);
            this.doRegister(model, udfInformation);
        }
        finally {
            this.releaseLock();
        }
    }

    public Model checkAndGetModel(UDFInformation udfInformation) {
        if (!udfInformation.isAvailable()) {
            throw new UDFManagementException("UDFInformation is not available");
        }
        Model model = udfInformation.getUdfType().isTreeModel() ? Model.TREE : Model.TABLE;
        return model;
    }

    private Class<?> getBaseClass(Model model) {
        if (Model.TREE.equals((Object)model)) {
            return UDF.class;
        }
        return SQLFunction.class;
    }

    public boolean checkIsBuiltInFunctionName(Model model, String functionName) throws UDFManagementException {
        if (Model.TREE.equals((Object)model)) {
            return BuiltinAggregationFunction.getNativeFunctionNames().contains(functionName.toLowerCase()) || BuiltinTimeSeriesGeneratingFunction.getNativeFunctionNames().contains(functionName.toUpperCase()) || BuiltinScalarFunction.getNativeFunctionNames().contains(functionName.toLowerCase());
        }
        return TableBuiltinScalarFunction.getBuiltInScalarFunctionName().contains(functionName.toLowerCase()) || TableBuiltinAggregationFunction.getBuiltInAggregateFunctionName().contains(functionName.toLowerCase()) || TableBuiltinTableFunction.getBuiltInTableFunctionName().contains(functionName.toLowerCase());
    }

    private void checkIfRegistered(Model model, UDFInformation udfInformation) throws UDFManagementException {
        if (this.checkIsBuiltInFunctionName(model, udfInformation.getFunctionName())) {
            String errorMessage = String.format("Failed to register UDF %s(%s), because the given function name conflicts with the built-in function name", udfInformation.getFunctionName(), udfInformation.getClassName());
            LOGGER.warn(errorMessage);
            throw new UDFManagementException(errorMessage);
        }
        String functionName = udfInformation.getFunctionName();
        String className = udfInformation.getClassName();
        UDFInformation information = this.udfTable.getUDFInformation(model, functionName);
        if (information == null) {
            return;
        }
        if (UDFExecutableManager.getInstance().hasFileUnderInstallDir(udfInformation.getJarName()) && UDFExecutableManager.getInstance().isLocalJarConflicted(udfInformation)) {
            String errorMessage = String.format("Failed to register function %s(%s), because existed md5 of jar file for function %s is different from the new jar file. ", functionName, className, functionName);
            LOGGER.warn(errorMessage);
            throw new UDFManagementException(errorMessage);
        }
    }

    private void saveJarFile(String jarName, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer != null) {
            UDFExecutableManager.getInstance().saveToInstallDir(byteBuffer, jarName);
        }
    }

    public void doRegister(Model model, UDFInformation udfInformation) throws UDFManagementException {
        String functionName = udfInformation.getFunctionName();
        String className = udfInformation.getClassName();
        try {
            UDFClassLoader currentActiveClassLoader = UDFClassLoaderManager.getInstance().updateAndGetActiveClassLoader();
            this.updateAllRegisteredClasses(model, currentActiveClassLoader);
            Class<?> functionClass = Class.forName(className, true, (ClassLoader)currentActiveClassLoader);
            this.getBaseClass(model).cast(functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            this.udfTable.addUDFInformation(functionName, udfInformation);
            this.udfTable.addFunctionAndClass(model, functionName, functionClass);
        }
        catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to register UDF %s(%s), because its instance can not be constructed successfully. Exception: %s", functionName.toUpperCase(), className, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new UDFManagementException(errorMessage);
        }
    }

    private void updateAllRegisteredClasses(Model model, UDFClassLoader activeClassLoader) throws ClassNotFoundException {
        for (UDFInformation information : this.getUDFInformation(model)) {
            this.udfTable.updateFunctionClass(information, activeClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(Model model, String functionName, boolean needToDeleteJar) throws Exception {
        try {
            this.acquireLock();
            UDFInformation information = this.udfTable.getUDFInformation(model, functionName);
            if (information == null) {
                return;
            }
            this.udfTable.removeUDFInformation(model, functionName);
            this.udfTable.removeFunctionClass(model, functionName);
            if (needToDeleteJar) {
                UDFExecutableManager.getInstance().removeFileUnderLibRoot(information.getJarName());
                UDFExecutableManager.getInstance().removeFileUnderTemporaryRoot(functionName.toUpperCase() + ".txt");
            }
        }
        finally {
            this.releaseLock();
        }
    }

    public <T> T reflect(String functionName, Class<T> clazz) {
        Model model;
        if (UDF.class.isAssignableFrom(clazz)) {
            model = Model.TREE;
        } else if (SQLFunction.class.isAssignableFrom(clazz)) {
            model = Model.TABLE;
        } else {
            throw new UDFManagementException("Unsupported UDF class type. Only UDF and SQLFunction are supported.");
        }
        UDFInformation information = this.udfTable.getUDFInformation(model, functionName);
        if (information == null) {
            String errorMessage = String.format("Failed to reflect UDF instance, because UDF %s has not been registered.", functionName.toUpperCase());
            LOGGER.warn(errorMessage);
            throw new UDFException(errorMessage);
        }
        try {
            return clazz.cast(this.udfTable.getFunctionClass(model, functionName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String errorMessage = String.format("Failed to reflect UDF %s(%s) instance, because %s", functionName, information.getClassName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new UDFException(errorMessage);
        }
    }

    public UDFInformation[] getUDFInformation(Model model) {
        return this.udfTable.getUDFInformationList(model).toArray(new UDFInformation[0]);
    }

    public UDFInformation getUDFInformation(Model model, String functionName) {
        return this.udfTable.getUDFInformation(model, functionName);
    }

    @TestOnly
    public void deregisterAll() throws UDFManagementException {
        for (UDFInformation information : this.getUDFInformation(Model.TREE)) {
            try {
                this.deregister(Model.TREE, information.getFunctionName(), false);
            }
            catch (Exception e) {
                throw new UDFManagementException(e.getMessage());
            }
        }
        for (UDFInformation information : this.getUDFInformation(Model.TABLE)) {
            try {
                this.deregister(Model.TABLE, information.getFunctionName(), false);
            }
            catch (Exception e) {
                throw new UDFManagementException(e.getMessage());
            }
        }
    }

    public static UDFManagementService getInstance() {
        return UDFManagementServiceHolder.INSTANCE;
    }

    private static class UDFManagementServiceHolder {
        private static final UDFManagementService INSTANCE = new UDFManagementService();

        private UDFManagementServiceHolder() {
        }
    }
}

