/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.XMLEventAllocator;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.swap.BuilderSwap;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlReader;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlParserSession
extends ReaderParserSession {
    private static final int UNKNOWN = 0;
    private static final int OBJECT = 1;
    private static final int ARRAY = 2;
    private static final int STRING = 3;
    private static final int NUMBER = 4;
    private static final int BOOLEAN = 5;
    private static final int NULL = 6;
    private final XmlParser ctx;
    private final StringBuilder rsb = new StringBuilder();

    public static Builder create(XmlParser ctx) {
        return new Builder(ctx);
    }

    private static int getJsonType(String s) {
        if (s == null) {
            return 0;
        }
        char c = s.charAt(0);
        return switch (c) {
            case 'o' -> {
                if (s.equals("object")) {
                    yield 1;
                }
                yield 0;
            }
            case 'a' -> {
                if (s.equals("array")) {
                    yield 2;
                }
                yield 0;
            }
            case 's' -> {
                if (s.equals("string")) {
                    yield 3;
                }
                yield 0;
            }
            case 'b' -> {
                if (s.equals("boolean")) {
                    yield 5;
                }
                yield 0;
            }
            case 'n' -> {
                c = s.charAt(2);
                switch (c) {
                    case 'm': {
                        if (s.equals("number")) {
                            yield 4;
                        }
                        yield 0;
                    }
                    case 'l': {
                        if (s.equals("null")) {
                            yield 6;
                        }
                        yield 0;
                    }
                }
                yield 4;
            }
            default -> 0;
        };
    }

    protected XmlParserSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    private String getAttributeName(XmlReader r, int i) {
        return this.decodeString(r.getAttributeLocalName(i));
    }

    private String getAttributeValue(XmlReader r, int i) {
        return this.decodeString(r.getAttributeValue(i));
    }

    private String getElementAsString(XmlReader r) {
        int t = r.getEventType();
        if (t > 2) {
            throw ThrowableUtils.rex((String)"Invalid event type on stream reader for elementToString() method: ''{0}''", (Object[])new Object[]{XmlUtils.toReadableEvent(r)});
        }
        this.rsb.setLength(0);
        this.rsb.append("<").append(t == 1 ? "" : "/").append(r.getLocalName());
        if (t == 1) {
            for (int i = 0; i < r.getAttributeCount(); ++i) {
                this.rsb.append(' ').append(r.getAttributeName(i)).append('=').append('\'').append(r.getAttributeValue(i)).append('\'');
            }
        }
        this.rsb.append('>');
        return this.rsb.toString();
    }

    private String getElementName(XmlReader r) {
        return this.decodeString(r.getLocalName());
    }

    private String getNameProperty(XmlReader r) {
        return this.decodeString(r.getAttributeValue(null, XmlParserSession.getNamePropertyName()));
    }

    private String getText(XmlReader r) {
        return this.getText(r, true);
    }

    private String getText(XmlReader r, boolean trim) {
        String s = r.getText();
        if (trim) {
            s = s.trim();
        }
        if (s.isEmpty()) {
            return null;
        }
        return this.decodeString(s);
    }

    private Object getUnknown(XmlReader r) throws IOException, ParseException, ExecutableException, XMLStreamException {
        if (r.getEventType() != 1) {
            throw new ParseException((ParserSession)this, "Parser must be on START_ELEMENT to read next text.", new Object[0]);
        }
        JsonMap m = null;
        if (r.getAttributeCount() > 0) {
            m = new JsonMap(this);
            for (int i = 0; i < r.getAttributeCount(); ++i) {
                String key = this.getAttributeName(r, i);
                String val = r.getAttributeValue(i);
                if (this.isSpecialAttr(key)) continue;
                m.put(key, (Object)val);
            }
        }
        int eventType = r.next();
        StringBuilder sb = this.getStringBuilder();
        block1: while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                sb.append(r.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new ParseException((ParserSession)this, "Unexpected end of document when reading element text content", new Object[0]);
                }
                if (eventType == 1) {
                    if (m == null) {
                        m = new JsonMap(this);
                    }
                    int depth = 0;
                    do {
                        int event;
                        int n = event = eventType == -1 ? r.nextTag() : eventType;
                        if (event == 1) {
                            ++depth;
                            String currAttr = this.getNameProperty(r);
                            if (currAttr == null) {
                                currAttr = this.getElementName(r);
                            }
                            String key = this.convertAttrToType(null, currAttr, this.string());
                            Object value = this.parseAnything(this.object(), currAttr, r, null, false, null);
                            if (m.containsKey(key)) {
                                Object o = m.get(key);
                                if (o instanceof JsonList) {
                                    JsonList o2 = (JsonList)o;
                                    o2.add(value);
                                } else {
                                    m.put(key, (Object)new JsonList(o, value).setBeanSession(this));
                                }
                            } else {
                                m.put(key, value);
                            }
                        } else if (event == 2) {
                            --depth;
                            break block1;
                        }
                        eventType = -1;
                    } while (depth > 0);
                    break;
                }
                throw new ParseException((ParserSession)this, "Unexpected event type ''{0}''", eventType);
            }
            eventType = r.next();
        }
        String s = sb.toString().trim();
        this.returnStringBuilder(sb);
        s = this.decodeString(s);
        if (Utils.nn((Object)m)) {
            if (!s.isEmpty()) {
                m.put("contents", (Object)s);
            }
            return m;
        }
        return s;
    }

    private boolean isSpecialAttr(String key) {
        return key.equals(this.getBeanTypePropertyName(null)) || key.equals(XmlParserSession.getNamePropertyName());
    }

    private <T> BeanMap<T> parseIntoBean(XmlReader r, BeanMap<T> m, boolean isNil) throws IOException, ParseException, ExecutableException, XMLStreamException {
        BeanMeta<T> bMeta = m.getMeta();
        XmlBeanMeta xmlMeta = this.getXmlBeanMeta(bMeta);
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String key = this.getAttributeName(r, i);
            if ("nil".equals(key) || this.isSpecialAttr(key)) continue;
            String val = r.getAttributeValue(i);
            String ns = r.getAttributeNamespace(i);
            BeanPropertyMeta bpm = xmlMeta.getPropertyMeta(key);
            if (bpm == null) {
                if (Utils.nn((Object)xmlMeta.getAttrsProperty())) {
                    xmlMeta.getAttrsProperty().add(m, key, key, val);
                    continue;
                }
                if (ns != null) continue;
                this.onUnknownProperty(key, m, val);
                continue;
            }
            try {
                bpm.set(m, key, val);
                continue;
            }
            catch (BeanRuntimeException e) {
                this.onBeanSetterException(bpm, e);
                throw e;
            }
        }
        BeanPropertyMeta cp = xmlMeta.getContentProperty();
        XmlFormat cpf = xmlMeta.getContentFormat();
        boolean trim = cp == null || !cpf.isOneOf(XmlFormat.MIXED_PWS, XmlFormat.TEXT_PWS);
        ClassMeta<Object> cpcm = cp == null ? this.object() : cp.getClassMeta();
        StringBuilder sb = null;
        BeanRegistry breg = cp == null ? null : cp.getBeanRegistry();
        LinkedList<String> l = null;
        int depth = 0;
        do {
            String s;
            int event;
            if ((event = r.next()) == 4) {
                if (Utils.nn((Object)cp) && cpf.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS)) {
                    if (cpcm.isCollectionOrArray()) {
                        if (l == null) {
                            l = new LinkedList<String>();
                        }
                        l.add(this.getText(r, false));
                        continue;
                    }
                    cp.set(m, null, this.getText(r, trim));
                    continue;
                }
                if (cpf == XmlFormat.ELEMENTS || !Utils.nn((Object)(s = this.getText(r, trim)))) continue;
                if (sb == null) {
                    sb = this.getStringBuilder();
                }
                sb.append(s);
                continue;
            }
            if (event == 1) {
                BeanPropertyMeta pMeta;
                if (Utils.nn((Object)cp) && cpf.isOneOf(XmlFormat.TEXT, XmlFormat.TEXT_PWS)) {
                    s = this.parseText(r);
                    if (Utils.nn((Object)s)) {
                        if (sb == null) {
                            sb = this.getStringBuilder();
                        }
                        sb.append(s);
                    }
                    --depth;
                    continue;
                }
                if (cpf == XmlFormat.XMLTEXT) {
                    if (sb == null) {
                        sb = this.getStringBuilder();
                    }
                    sb.append(this.getElementAsString(r));
                    ++depth;
                    continue;
                }
                if (Utils.nn((Object)cp) && cpf.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS)) {
                    if (this.isWhitespaceElement(r) && (breg == null || !breg.hasName(r.getLocalName()))) {
                        if (cpcm.isCollectionOrArray()) {
                            if (l == null) {
                                l = new LinkedList();
                            }
                            l.add(this.parseWhitespaceElement(r));
                            continue;
                        }
                        cp.set(m, null, this.parseWhitespaceElement(r));
                        continue;
                    }
                    if (cpcm.isCollectionOrArray()) {
                        if (l == null) {
                            l = new LinkedList();
                        }
                        l.add((String)this.parseAnything(cpcm.getElementType(), cp.getName(), r, m.getBean(false), false, cp));
                        continue;
                    }
                    cp.set(m, null, this.parseAnything(cpcm, cp.getName(), r, m.getBean(false), false, cp));
                    continue;
                }
                if (Utils.nn((Object)cp) && cpf == XmlFormat.ELEMENTS) {
                    cp.add(m, null, this.parseAnything(cpcm.getElementType(), cp.getName(), r, m.getBean(false), false, cp));
                    continue;
                }
                String currAttr = this.getNameProperty(r);
                if (currAttr == null) {
                    currAttr = this.getElementName(r);
                }
                if ((pMeta = xmlMeta.getPropertyMeta(currAttr)) == null) {
                    Object value = this.parseAnything(this.object(), currAttr, r, m.getBean(false), false, null);
                    this.onUnknownProperty(currAttr, m, value);
                    continue;
                }
                this.setCurrentProperty(pMeta);
                XmlFormat xf = this.getXmlBeanPropertyMeta(pMeta).getXmlFormat();
                if (xf == XmlFormat.COLLAPSED) {
                    ClassMeta<?> et = pMeta.getClassMeta().getElementType();
                    value = this.parseAnything(et, currAttr, r, m.getBean(false), false, pMeta);
                    XmlParserSession.setName(et, value, currAttr);
                    pMeta.add(m, currAttr, value);
                } else if (xf == XmlFormat.ATTR) {
                    pMeta.set(m, currAttr, this.getAttributeValue(r, 0));
                    r.nextTag();
                } else {
                    ClassMeta<?> cm = pMeta.getClassMeta();
                    value = this.parseAnything(cm, currAttr, r, m.getBean(false), false, pMeta);
                    XmlParserSession.setName(cm, value, currAttr);
                    pMeta.set(m, currAttr, value);
                }
                this.setCurrentProperty(null);
                continue;
            }
            if (event == 2) {
                if (depth > 0) {
                    if (cpf == XmlFormat.XMLTEXT) {
                        if (sb == null) {
                            sb = this.getStringBuilder();
                        }
                        sb.append(this.getElementAsString(r));
                    } else {
                        throw new ParseException("End element found where one was not expected.  {0}", XmlUtils.toReadableEvent(r));
                    }
                }
                --depth;
                continue;
            }
            if (event == 5) continue;
            throw new ParseException("Unexpected event type: {0}", XmlUtils.toReadableEvent(r));
        } while (depth >= 0);
        if (Utils.nn((Object)cp) && !isNil) {
            Object o;
            if (Utils.nn((Object)sb)) {
                cp.set(m, null, sb.toString());
            } else if (Utils.nn((Object)l)) {
                cp.set(m, null, XmlUtils.collapseTextNodes((LinkedList<Object>)l));
            } else if (cpcm.isCollectionOrArray() && (o = cp.get(m, null)) == null) {
                cp.set(m, cp.getName(), CollectionUtils.list((Object[])new Object[0]));
            }
        }
        this.returnStringBuilder(sb);
        return m;
    }

    private <E> Collection<E> parseIntoCollection(XmlReader r, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException, XMLStreamException {
        int depth = 0;
        int argIndex = 0;
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                ++depth;
                ClassMeta<Object> elementType = type == null ? this.object() : (type.isArgs() ? type.getArg(argIndex++) : type.getElementType());
                Object value = this.parseAnything(elementType, null, r, l, false, pMeta);
                l.add(value);
                continue;
            }
            if (event != 2) continue;
            --depth;
            return l;
        } while (depth > 0);
        return l;
    }

    private <K, V> Map<K, V> parseIntoMap(XmlReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException, XMLStreamException {
        V value;
        K key;
        int depth = 0;
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String a = r.getAttributeLocalName(i);
            if (this.isSpecialAttr(a)) continue;
            key = this.trim(this.convertAttrToType(m, a, keyType));
            value = this.trim(this.convertAttrToType(m, r.getAttributeValue(i), valueType));
            XmlParserSession.setName(valueType, value, key);
            m.put(key, (JsonList)value);
        }
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                ++depth;
                String currAttr = this.getNameProperty(r);
                if (currAttr == null) {
                    currAttr = this.getElementName(r);
                }
                key = this.convertAttrToType(m, currAttr, keyType);
                value = this.parseAnything(valueType, currAttr, r, m, false, pMeta);
                XmlParserSession.setName(valueType, value, currAttr);
                if (valueType.isObject() && m.containsKey(key)) {
                    V o = m.get(key);
                    if (o instanceof List) {
                        List o2 = (List)o;
                        o2.add(value);
                        continue;
                    }
                    m.put(key, new JsonList(o, value).setBeanSession(this));
                    continue;
                }
                m.put(key, (JsonList)value);
                continue;
            }
            if (event != 2) continue;
            --depth;
            return m;
        } while (depth > 0);
        return m;
    }

    protected final String decodeString(String s) {
        if (s == null) {
            return null;
        }
        this.rsb.setLength(0);
        s = XmlUtils.decode(s, this.rsb);
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        try {
            return this.parseAnything(type, null, this.getXmlReader(pipe), this.getOuter(), true, null);
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws Exception {
        ClassMeta cm = this.getClassMeta(c.getClass(), elementType);
        return this.parseIntoCollection(pipe, c, (Type)((Object)cm.getElementType()));
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        ClassMeta cm = this.getClassMeta(m.getClass(), keyType, valueType);
        return this.parseIntoMap(pipe, m, (Type)((Object)cm.getKeyType()), (Type)((Object)cm.getValueType()));
    }

    protected String getElementText(XmlReader r) throws XMLStreamException, IOException, ParseException {
        return this.decodeString(r.getElementText().trim());
    }

    protected final XMLEventAllocator getEventAllocator() {
        return this.ctx.getEventAllocator();
    }

    protected final XMLReporter getReporter() {
        return this.ctx.getReporter();
    }

    protected final XMLResolver getResolver() {
        return this.ctx.getResolver();
    }

    protected XmlBeanMeta getXmlBeanMeta(BeanMeta<?> bm) {
        return this.ctx.getXmlBeanMeta(bm);
    }

    protected XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getXmlBeanPropertyMeta(bpm);
    }

    protected XmlClassMeta getXmlClassMeta(ClassMeta<?> cm) {
        return this.ctx.getXmlClassMeta(cm);
    }

    protected final XmlReader getXmlReader(ParserPipe pipe) throws IOException, XMLStreamException {
        return new XmlReader(pipe, this.isValidating(), this.getReporter(), this.getResolver(), this.getEventAllocator());
    }

    protected final boolean isPreserveRootElement() {
        return this.ctx.isPreserveRootElement();
    }

    protected final boolean isValidating() {
        return this.ctx.isValidating();
    }

    protected boolean isWhitespaceElement(XmlReader r) {
        return false;
    }

    protected <T> T parseAnything(ClassMeta<T> eType, String currAttr, XmlReader r, Object outer, boolean isRoot, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException, XMLStreamException {
        ClassMeta<?> tcm;
        if (eType == null) {
            eType = this.object();
        }
        ObjectSwap<T, ?> swap = eType.getSwap(this);
        BuilderSwap<Object, T> builder = eType.getBuilderSwap(this);
        ClassMeta<Object> sType = null;
        sType = Utils.nn(builder) ? builder.getBuilderClassMeta(this) : (Utils.nn(swap) ? swap.getSwapClassMeta(this) : eType);
        if (sType.isOptional()) {
            return (T)Utils.opt(this.parseAnything(eType.getElementType(), currAttr, r, outer, isRoot, pMeta));
        }
        this.setCurrentClass(sType);
        String wrapperAttr = isRoot && this.isPreserveRootElement() ? r.getName().getLocalPart() : null;
        String typeAttr = r.getAttributeValue(null, this.getBeanTypePropertyName(eType));
        boolean isNil = "true".equals(r.getAttributeValue(null, "nil"));
        int jsonType = XmlParserSession.getJsonType(typeAttr);
        String elementName = this.getElementName(r);
        if (jsonType == 0) {
            if (elementName == null || elementName.equals(currAttr)) {
                jsonType = 0;
            } else {
                typeAttr = elementName;
                jsonType = XmlParserSession.getJsonType(elementName);
            }
        }
        if ((tcm = this.getClassMeta(typeAttr, pMeta, eType)) == null && Utils.nn((Object)elementName) && !elementName.equals(currAttr)) {
            tcm = this.getClassMeta(elementName, pMeta, eType);
        }
        if (Utils.nn(tcm)) {
            eType = tcm;
            sType = eType;
        }
        Object o = null;
        if (jsonType == 6) {
            r.nextTag();
            return null;
        }
        if (sType.isObject()) {
            if (jsonType == 1) {
                JsonMap m = new JsonMap(this);
                this.parseIntoMap(r, m, this.string(), this.object(), pMeta);
                if (Utils.nn((Object)wrapperAttr)) {
                    m = new JsonMap(this).append(wrapperAttr, m);
                }
                o = this.cast(m, pMeta, eType);
            } else if (jsonType == 2) {
                o = this.parseIntoCollection(r, new JsonList(this), null, pMeta);
            } else if (jsonType == 3) {
                o = this.getElementText(r);
                if (sType.isChar()) {
                    o = StringUtils.parseCharacter(o);
                }
            } else if (jsonType == 4) {
                o = StringUtils.parseNumber((String)this.getElementText(r), null);
            } else if (jsonType == 5) {
                o = Boolean.parseBoolean(this.getElementText(r));
            } else if (jsonType == 0) {
                o = this.getUnknown(r);
            }
        } else if (sType.isBoolean()) {
            o = Boolean.parseBoolean(this.getElementText(r));
        } else if (sType.isCharSequence()) {
            o = this.getElementText(r);
        } else if (sType.isChar()) {
            o = StringUtils.parseCharacter((Object)this.getElementText(r));
        } else if (sType.isMap()) {
            Map m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : this.newGenericMap(sType);
            o = this.parseIntoMap(r, m, sType.getKeyType(), sType.getValueType(), pMeta);
            if (Utils.nn((Object)wrapperAttr)) {
                o = new JsonMap(this).append(wrapperAttr, m);
            }
        } else if (sType.isCollection()) {
            Collection<Object> l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new JsonList(this);
            o = this.parseIntoCollection(r, l, sType, pMeta);
        } else if (sType.isNumber()) {
            o = StringUtils.parseNumber((String)this.getElementText(r), (Class)sType.inner());
        } else if (Utils.nn(builder) || sType.canCreateNewBean(outer)) {
            if (this.getXmlClassMeta(sType).getFormat() == XmlFormat.COLLAPSED) {
                String fieldName = r.getLocalName();
                BeanMap<Object> m = Utils.nn(builder) ? this.toBeanMap(builder.create(this, eType)) : this.newBeanMap(outer, sType.inner());
                BeanPropertyMeta bpm = this.getXmlBeanMeta(m.getMeta()).getPropertyMeta(fieldName);
                ClassMeta<Object> cm = m.getMeta().getClassMeta();
                Object value = this.parseAnything(cm, currAttr, r, m.getBean(false), false, null);
                XmlParserSession.setName(cm, value, currAttr);
                bpm.set(m, currAttr, value);
                o = Utils.nn(builder) ? builder.build(this, m.getBean(), eType) : m.getBean();
            } else {
                BeanMap<Object> m = Utils.nn(builder) ? this.toBeanMap(builder.create(this, eType)) : this.newBeanMap(outer, sType.inner());
                m = this.parseIntoBean(r, m, isNil);
                o = Utils.nn(builder) ? builder.build(this, m.getBean(), eType) : m.getBean();
            }
        } else if (sType.isArray() || sType.isArgs()) {
            ArrayList l = (ArrayList)this.parseIntoCollection(r, CollectionUtils.list((Object[])new Object[0]), sType, pMeta);
            o = this.toArray(sType, l);
        } else if (sType.canCreateNewInstanceFromString(outer)) {
            o = sType.newInstanceFromString(outer, this.getElementText(r));
        } else if (Utils.nn((Object)sType.getProxyInvocationHandler())) {
            JsonMap m = new JsonMap(this);
            this.parseIntoMap(r, m, this.string(), this.object(), pMeta);
            if (Utils.nn((Object)wrapperAttr)) {
                m = new JsonMap(this).append(wrapperAttr, m);
            }
            o = this.newBeanMap(outer, sType.inner()).load(m).getBean();
        } else {
            throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}'', property: ''{2}''", Utils.cn(sType), sType.getNotABeanReason(), pMeta == null ? null : pMeta.getName());
        }
        if (Utils.nn(swap) && Utils.nn((Object)o)) {
            o = this.unswap(swap, o, eType);
        }
        if (Utils.nn((Object)outer)) {
            XmlParserSession.setParent(eType, o, outer);
        }
        return (T)o;
    }

    protected String parseText(XmlReader r) throws IOException, XMLStreamException, ParseException {
        StringBuilder sb2 = this.getStringBuilder();
        int depth = 0;
        while (true) {
            int et;
            if ((et = r.getEventType()) == 1) {
                sb2.append(this.getElementAsString(r));
                ++depth;
            } else if (et == 4) {
                sb2.append(this.getText(r));
            } else if (et == 2) {
                sb2.append(this.getElementAsString(r));
                if (--depth <= 0) break;
            }
            et = r.next();
        }
        String s = sb2.toString();
        this.returnStringBuilder(sb2);
        return s;
    }

    protected String parseWhitespaceElement(XmlReader r) throws IOException, XMLStreamException, ParseException {
        return null;
    }

    public static class Builder
    extends ReaderParserSession.Builder {
        private XmlParser ctx;

        protected Builder(XmlParser ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public XmlParserSession build() {
            return new XmlParserSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder outer(Object value) {
            super.outer(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }
    }
}

