/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.BeanContext;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ReaderParser;

public class ParserSet {
    private final ConcurrentHashMap<String, ParserMatch> cache = new ConcurrentHashMap();
    private final MediaType[] mediaTypes;
    private final Parser[] mediaTypeParsers;
    final Parser[] entries;

    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public ParserSet(Builder builder) {
        this.entries = (Parser[])builder.entries.stream().map(this::build).toArray(Parser[]::new);
        List lmt = CollectionUtils.list((Object[])new MediaType[0]);
        List l = CollectionUtils.list((Object[])new Parser[0]);
        for (Parser e : this.entries) {
            e.getMediaTypes().forEach(x -> {
                lmt.add(x);
                l.add(e);
            });
        }
        this.mediaTypes = (MediaType[])CollectionUtils.array((Collection)lmt, MediaType.class);
        this.mediaTypeParsers = (Parser[])CollectionUtils.array((Collection)l, Parser.class);
    }

    public Builder copy() {
        return new Builder(this);
    }

    public Parser getParser(MediaType mediaType) {
        ParserMatch pm = this.getParserMatch(mediaType);
        return pm == null ? null : pm.getParser();
    }

    public Parser getParser(String contentTypeHeader) {
        ParserMatch pm = this.getParserMatch(contentTypeHeader);
        return pm == null ? null : pm.getParser();
    }

    public ParserMatch getParserMatch(MediaType mediaType) {
        return this.getParserMatch(mediaType.toString());
    }

    public ParserMatch getParserMatch(String contentTypeHeader) {
        ParserMatch pm = this.cache.get(contentTypeHeader);
        if (Utils.nn((Object)pm)) {
            return pm;
        }
        MediaType ct = MediaType.of(contentTypeHeader);
        int match = ct.match(CollectionUtils.l((Object[])this.mediaTypes));
        if (match >= 0) {
            pm = new ParserMatch(this.mediaTypes[match], this.mediaTypeParsers[match]);
            this.cache.putIfAbsent(contentTypeHeader, pm);
        }
        return this.cache.get(contentTypeHeader);
    }

    public List<Parser> getParsers() {
        return CollectionUtils.u((List)CollectionUtils.l((Object[])this.entries));
    }

    public List<MediaType> getSupportedMediaTypes() {
        return CollectionUtils.u((List)CollectionUtils.l((Object[])this.mediaTypes));
    }

    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    private Parser build(Object o) {
        if (o instanceof Parser) {
            Parser o2 = (Parser)o;
            return o2;
        }
        return ((Parser.Builder)o).build();
    }

    public static class Builder
    extends BeanBuilder<ParserSet> {
        List<Object> entries;
        private BeanContext.Builder bcBuilder;

        protected Builder(BeanStore beanStore) {
            super(ParserSet.class, beanStore);
            this.entries = CollectionUtils.list((Object[])new Object[0]);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.bcBuilder = copyFrom.bcBuilder == null ? null : copyFrom.bcBuilder.copy();
            this.entries = CollectionUtils.list((Object[])new Object[0]);
            copyFrom.entries.stream().map(this::copyBuilder).forEach((? super T x) -> this.entries.add(x));
        }

        protected Builder(ParserSet copyFrom) {
            super(copyFrom.getClass(), BeanStore.INSTANCE);
            this.entries = CollectionUtils.list((Object[])copyFrom.entries);
        }

        public Builder add(Class<?> ... values) {
            List l = CollectionUtils.list((Object[])new Object[0]);
            for (Class<?> v : values) {
                if (!v.getSimpleName().equals("NoInherit")) continue;
                this.clear();
            }
            for (Class<?> v : values) {
                if (Parser.class.isAssignableFrom(v)) {
                    l.add(this.createBuilder(v));
                    continue;
                }
                if (v.getSimpleName().equals("NoInherit")) continue;
                throw ThrowableUtils.rex((String)"Invalid type passed to ParserSet.Builder.add(): {0}", (Object[])new Object[]{Utils.cn(v)});
            }
            this.entries.addAll(0, l);
            return this;
        }

        public Builder add(Parser ... s) {
            CollectionUtils.prependAll(this.entries, (Object[])s);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            return this.forEach(x -> x.apply(work));
        }

        public Builder beanContext(BeanContext.Builder value) {
            this.bcBuilder = value;
            this.forEach(x -> x.beanContext(value));
            return this;
        }

        public final Builder beanContext(Consumer<BeanContext.Builder> operation) {
            if (Utils.nn((Object)this.bcBuilder)) {
                operation.accept(this.bcBuilder);
            }
            return this;
        }

        public boolean canApply(AnnotationWorkList work) {
            for (Object o : this.entries) {
                if (!(o instanceof Parser.Builder) || !((Parser.Builder)o).canApply(work)) continue;
                return true;
            }
            return false;
        }

        public Builder clear() {
            this.entries.clear();
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public <B extends Parser.Builder> Builder forEach(Class<B> type, Consumer<B> action) {
            this.builders(type).forEach(action);
            return this;
        }

        public Builder forEach(Consumer<Parser.Builder> action) {
            this.builders(Parser.Builder.class).forEach(action);
            return this;
        }

        public Builder forEachISP(Consumer<InputStreamParser.Builder> action) {
            return this.forEach(InputStreamParser.Builder.class, action);
        }

        public Builder forEachRP(Consumer<ReaderParser.Builder> action) {
            return this.forEach(ReaderParser.Builder.class, action);
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public List<Object> inner() {
            return this.entries;
        }

        public Builder set(Class<?> ... values) {
            List l = CollectionUtils.list((Object[])new Object[0]);
            for (Class<?> v : values) {
                if (v.getSimpleName().equals("Inherit")) {
                    l.addAll(this.entries);
                    continue;
                }
                if (Parser.class.isAssignableFrom(v)) {
                    l.add(this.createBuilder(v));
                    continue;
                }
                throw ThrowableUtils.rex((String)"Invalid type passed to ParserGrouup.Builder.set(): {0}", (Object[])new Object[]{Utils.cn(v)});
            }
            this.entries = l;
            return this;
        }

        public String toString() {
            return this.entries.stream().map(this::toString).collect(Collectors.joining(",", "[", "]"));
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        private <T extends Parser.Builder> Stream<T> builders(Class<T> type) {
            return this.entries.stream().filter(x -> type.isInstance(x)).map(x -> (Parser.Builder)type.cast(x));
        }

        private Object copyBuilder(Object o) {
            if (o instanceof Parser.Builder) {
                Parser.Builder x = (Parser.Builder)o;
                Parser.Builder x2 = x.copy();
                if (Utils.neq(x.getClass(), x2.getClass())) {
                    throw ThrowableUtils.rex((String)"Copy method not implemented on class {0}", (Object[])new Object[]{Utils.cn((Object)x)});
                }
                x = x2;
                if (Utils.nn((Object)this.bcBuilder)) {
                    x.beanContext(this.bcBuilder);
                }
                return x;
            }
            return o;
        }

        private Object createBuilder(Object o) {
            if (o instanceof Class) {
                Class o2 = (Class)o;
                ConstructorInfo ci = ReflectionUtils.info((Class)o2).getPublicConstructor(c -> c.getParameterCount() == 0).orElse(null);
                if (Utils.nn((Object)ci)) {
                    return ci.newInstance(new Object[0]);
                }
                Parser.Builder b = Parser.createParserBuilder((Class)o);
                if (Utils.nn((Object)this.bcBuilder)) {
                    b.beanContext(this.bcBuilder);
                }
                o = b;
            }
            return o;
        }

        private String toString(Object o) {
            if (o == null) {
                return "null";
            }
            if (o instanceof Parser.Builder) {
                return "builder:" + Utils.cn((Object)o);
            }
            return "parser:" + Utils.cn((Object)o);
        }

        @Override
        protected ParserSet buildDefault() {
            return new ParserSet(this);
        }
    }

    public static abstract class NoInherit
    extends Parser {
        protected NoInherit(Parser.Builder builder) {
            super(builder);
        }
    }

    public static abstract class Inherit
    extends Parser {
        protected Inherit(Parser.Builder builder) {
            super(builder);
        }
    }
}

