/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.Context;
import org.apache.juneau.Enablement;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.ExecutableInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.html.HtmlWidgetVar;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.Thrown;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.MethodNotAllowed;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.http.response.NotImplemented;
import org.apache.juneau.http.response.PreconditionFailed;
import org.apache.juneau.http.response.Unauthorized;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.rest.OverrideableHttpServletRequest;
import org.apache.juneau.rest.ResourceSupplier;
import org.apache.juneau.rest.RestChild;
import org.apache.juneau.rest.RestChildMatch;
import org.apache.juneau.rest.RestChildren;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestOpInvoker;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestOperations;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestDestroy;
import org.apache.juneau.rest.annotation.RestEndCall;
import org.apache.juneau.rest.annotation.RestInit;
import org.apache.juneau.rest.annotation.RestInject;
import org.apache.juneau.rest.annotation.RestInjectAnnotation;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.annotation.RestPostCall;
import org.apache.juneau.rest.annotation.RestPostInit;
import org.apache.juneau.rest.annotation.RestPreCall;
import org.apache.juneau.rest.annotation.RestStartCall;
import org.apache.juneau.rest.arg.AttributeArg;
import org.apache.juneau.rest.arg.ContentArg;
import org.apache.juneau.rest.arg.DefaultArg;
import org.apache.juneau.rest.arg.FormDataArg;
import org.apache.juneau.rest.arg.HasFormDataArg;
import org.apache.juneau.rest.arg.HasQueryArg;
import org.apache.juneau.rest.arg.HeaderArg;
import org.apache.juneau.rest.arg.HttpServletRequestArgs;
import org.apache.juneau.rest.arg.HttpServletResponseArgs;
import org.apache.juneau.rest.arg.HttpSessionArgs;
import org.apache.juneau.rest.arg.InputStreamParserArg;
import org.apache.juneau.rest.arg.MethodArg;
import org.apache.juneau.rest.arg.ParserArg;
import org.apache.juneau.rest.arg.PathArg;
import org.apache.juneau.rest.arg.PathRemainderArg;
import org.apache.juneau.rest.arg.QueryArg;
import org.apache.juneau.rest.arg.ReaderParserArg;
import org.apache.juneau.rest.arg.RequestBeanArg;
import org.apache.juneau.rest.arg.ResponseBeanArg;
import org.apache.juneau.rest.arg.ResponseCodeArg;
import org.apache.juneau.rest.arg.ResponseHeaderArg;
import org.apache.juneau.rest.arg.RestContextArgs;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.arg.RestOpArgList;
import org.apache.juneau.rest.arg.RestOpContextArgs;
import org.apache.juneau.rest.arg.RestOpSessionArgs;
import org.apache.juneau.rest.arg.RestRequestArgs;
import org.apache.juneau.rest.arg.RestResponseArgs;
import org.apache.juneau.rest.arg.RestSessionArgs;
import org.apache.juneau.rest.debug.BasicDebugEnablement;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttributeMap;
import org.apache.juneau.rest.logger.BasicCallLogger;
import org.apache.juneau.rest.logger.CallLogger;
import org.apache.juneau.rest.processor.HttpEntityProcessor;
import org.apache.juneau.rest.processor.HttpResourceProcessor;
import org.apache.juneau.rest.processor.HttpResponseProcessor;
import org.apache.juneau.rest.processor.InputStreamProcessor;
import org.apache.juneau.rest.processor.PlainTextPojoProcessor;
import org.apache.juneau.rest.processor.ReaderProcessor;
import org.apache.juneau.rest.processor.ResponseBeanProcessor;
import org.apache.juneau.rest.processor.ResponseProcessor;
import org.apache.juneau.rest.processor.ResponseProcessorList;
import org.apache.juneau.rest.processor.SerializedPojoProcessor;
import org.apache.juneau.rest.processor.ThrowableProcessor;
import org.apache.juneau.rest.rrpc.RrpcRestOpContext;
import org.apache.juneau.rest.staticfile.BasicStaticFiles;
import org.apache.juneau.rest.staticfile.StaticFiles;
import org.apache.juneau.rest.stats.MethodExecStats;
import org.apache.juneau.rest.stats.MethodExecStore;
import org.apache.juneau.rest.stats.MethodInvoker;
import org.apache.juneau.rest.stats.RestContextStats;
import org.apache.juneau.rest.stats.ThrownStore;
import org.apache.juneau.rest.swagger.BasicSwaggerProvider;
import org.apache.juneau.rest.swagger.SwaggerProvider;
import org.apache.juneau.rest.util.DefaultClassList;
import org.apache.juneau.rest.util.DefaultSettingsMap;
import org.apache.juneau.rest.util.MethodList;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPath;
import org.apache.juneau.rest.util.UrlPathMatch;
import org.apache.juneau.rest.util.UrlPathMatcher;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.vars.LocalizationVar;
import org.apache.juneau.rest.vars.RequestAttributeVar;
import org.apache.juneau.rest.vars.RequestFormDataVar;
import org.apache.juneau.rest.vars.RequestHeaderVar;
import org.apache.juneau.rest.vars.RequestPathVar;
import org.apache.juneau.rest.vars.RequestQueryVar;
import org.apache.juneau.rest.vars.RequestSwaggerVar;
import org.apache.juneau.rest.vars.RequestVar;
import org.apache.juneau.rest.vars.SerializedRequestAttrVar;
import org.apache.juneau.rest.vars.ServletInitParamVar;
import org.apache.juneau.rest.vars.SwaggerVar;
import org.apache.juneau.rest.vars.UrlEncodeVar;
import org.apache.juneau.rest.vars.UrlVar;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.SerializerSet;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarList;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public class RestContext
extends Context {
    private static final Map<Class<?>, RestContext> REGISTRY = new ConcurrentHashMap();
    protected final boolean allowContentParam;
    protected final boolean renderResponseStackTraces;
    protected final long maxInput;
    protected final AtomicBoolean initialized = new AtomicBoolean(false);
    protected final BasicHttpException initException;
    protected final BeanContext beanContext;
    protected final BeanStore beanStore;
    protected final BeanStore rootBeanStore;
    protected final Builder builder;
    protected final CallLogger callLogger;
    protected final Charset defaultCharset;
    protected final Class<?> resourceClass;
    protected final Class<? extends RestOpArg>[] restOpArgs;
    protected final ConcurrentHashMap<Locale, Swagger> swaggerCache = new ConcurrentHashMap();
    protected final Config config;
    protected final DebugEnablement debugEnablement;
    protected final DefaultClassList defaultClasses;
    protected final DefaultSettingsMap defaultSettings;
    protected final EncoderSet encoders;
    protected final HeaderList defaultRequestHeaders;
    protected final HeaderList defaultResponseHeaders;
    protected final HttpPartParser partParser;
    protected final HttpPartSerializer partSerializer;
    protected final Instant startTime;
    protected final JsonSchemaGenerator jsonSchemaGenerator;
    protected final List<MediaType> consumes;
    protected final List<MediaType> produces;
    protected final Logger logger;
    protected final Messages messages;
    protected final MethodExecStore methodExecStore;
    protected final NamedAttributeMap defaultRequestAttributes;
    protected final ParserSet parsers;
    protected final RestChildren restChildren;
    protected final RestContext parentContext;
    protected final RestOperations restOperations;
    protected final ResponseProcessor[] responseProcessors;
    protected final SerializerSet serializers;
    protected final Set<String> allowedHeaderParams;
    protected final Set<String> allowedMethodHeaders;
    protected final Set<String> allowedMethodParams;
    protected final StaticFiles staticFiles;
    protected final String clientVersionHeader;
    protected final String fullPath;
    protected final String path;
    protected final String uriAuthority;
    protected final String uriContext;
    protected final SwaggerProvider swaggerProvider;
    protected final ThrownStore thrownStore;
    protected final ThreadLocal<RestSession> localSession = new ThreadLocal();
    protected final UriRelativity uriRelativity;
    protected final UriResolution uriResolution;
    protected final UrlPathMatcher pathMatcher;
    protected final VarResolver varResolver;
    private final MethodInvoker[] destroyMethods;
    private final MethodInvoker[] endCallMethods;
    private final MethodInvoker[] postInitChildFirstMethods;
    private final MethodInvoker[] postInitMethods;
    private final MethodInvoker[] startCallMethods;
    private final MethodList postCallMethods;
    private final MethodList preCallMethods;
    private final Supplier<?> resource;

    public static Builder create(Class<?> resourceClass, RestContext parentContext, ServletConfig servletConfig) throws ServletException {
        return new Builder(resourceClass, parentContext, servletConfig);
    }

    public static final Map<Class<?>, RestContext> getGlobalRegistry() {
        return CollectionUtils.u(REGISTRY);
    }

    static ServletException servletException(String msg, Object ... args) {
        return new ServletException(Utils.f((String)msg, (Object[])args));
    }

    static ServletException servletException(Throwable t, String msg, Object ... args) {
        return new ServletException(Utils.f((String)msg, (Object[])args), t);
    }

    public RestContext(Builder builder) throws Exception {
        super((Context.Builder)builder);
        this.startTime = Instant.now();
        REGISTRY.put(builder.resourceClass, this);
        BasicHttpException _initException = null;
        try {
            this.builder = builder;
            this.defaultClasses = builder.defaultClasses();
            this.defaultSettings = builder.defaultSettings();
            this.parentContext = builder.parentContext;
            this.resource = builder.resource;
            this.resourceClass = builder.resourceClass;
            this.rootBeanStore = builder.rootBeanStore();
            BeanStore bs = this.beanStore = builder.beanStore();
            this.beanStore.addBean(BeanStore.class, (Object)this.beanStore).addBean(RestContext.class, (Object)this).addBean(Object.class, this.resource.get()).addBean(DefaultSettingsMap.class, (Object)this.defaultSettings).addBean(Builder.class, (Object)builder).addBean(AnnotationWorkList.class, (Object)builder.getApplied());
            this.path = Utils.nn((Object)builder.path) ? builder.path : "";
            this.fullPath = (String)(this.parentContext == null ? "" : this.parentContext.fullPath + "/") + this.path;
            Object p = this.path;
            if (!((String)p).endsWith("/*")) {
                p = (String)p + "/*";
            }
            this.pathMatcher = UrlPathMatcher.of((String)p);
            this.allowContentParam = !builder.disableContentParam;
            this.allowedHeaderParams = RestContext.newCaseInsensitiveSet(Utils.opt((Object)builder.allowedHeaderParams).map(x -> "NONE".equals(x) ? "" : x).orElse(""));
            this.allowedMethodHeaders = RestContext.newCaseInsensitiveSet(Utils.opt((Object)builder.allowedMethodHeaders).map(x -> "NONE".equals(x) ? "" : x).orElse(""));
            this.allowedMethodParams = RestContext.newCaseInsensitiveSet(Utils.opt((Object)builder.allowedMethodParams).map(x -> "NONE".equals(x) ? "" : x).orElse(""));
            this.clientVersionHeader = builder.clientVersionHeader;
            this.defaultCharset = builder.defaultCharset;
            this.maxInput = builder.maxInput;
            this.renderResponseStackTraces = builder.renderResponseStackTraces;
            this.uriAuthority = builder.uriAuthority;
            this.uriContext = builder.uriContext;
            this.uriRelativity = builder.uriRelativity;
            this.uriResolution = builder.uriResolution;
            this.beanContext = (BeanContext)bs.add(BeanContext.class, (Object)builder.beanContext().build());
            this.encoders = (EncoderSet)bs.add(EncoderSet.class, (Object)((EncoderSet)builder.encoders().build()));
            this.serializers = (SerializerSet)bs.add(SerializerSet.class, (Object)((SerializerSet)builder.serializers().build()));
            this.parsers = (ParserSet)bs.add(ParserSet.class, (Object)((ParserSet)builder.parsers().build()));
            this.logger = (Logger)bs.add(Logger.class, (Object)builder.logger());
            this.thrownStore = (ThrownStore)bs.add(ThrownStore.class, (Object)((ThrownStore)builder.thrownStore().build()));
            this.methodExecStore = (MethodExecStore)bs.add(MethodExecStore.class, (Object)((MethodExecStore)builder.methodExecStore().thrownStoreOnce(this.thrownStore).build()));
            this.messages = (Messages)bs.add(Messages.class, (Object)((Messages)builder.messages().build()));
            this.varResolver = (VarResolver)bs.add(VarResolver.class, (Object)((VarResolver)builder.varResolver().bean(Messages.class, (Object)this.messages).build()));
            this.config = (Config)bs.add(Config.class, (Object)builder.config().resolving(this.varResolver.createSession()));
            this.responseProcessors = (ResponseProcessor[])bs.add(ResponseProcessor[].class, (Object)((ResponseProcessorList)builder.responseProcessors().build()).toArray());
            this.callLogger = (CallLogger)bs.add(CallLogger.class, (Object)((CallLogger)builder.callLogger().orElse(null)));
            this.partSerializer = (HttpPartSerializer)bs.add(HttpPartSerializer.class, (Object)((HttpPartSerializer)builder.partSerializer().create()));
            this.partParser = (HttpPartParser)bs.add(HttpPartParser.class, (Object)((HttpPartParser)builder.partParser().create()));
            this.jsonSchemaGenerator = (JsonSchemaGenerator)bs.add(JsonSchemaGenerator.class, (Object)builder.jsonSchemaGenerator().build());
            this.staticFiles = (StaticFiles)bs.add(StaticFiles.class, (Object)((StaticFiles)builder.staticFiles().orElse(null)));
            bs.add(FileFinder.class, (Object)this.staticFiles);
            this.defaultRequestHeaders = (HeaderList)bs.add(HeaderList.class, (Object)builder.defaultRequestHeaders(), "defaultRequestHeaders");
            this.defaultResponseHeaders = (HeaderList)bs.add(HeaderList.class, (Object)builder.defaultResponseHeaders(), "defaultResponseHeaders");
            this.defaultRequestAttributes = (NamedAttributeMap)bs.add(NamedAttributeMap.class, (Object)builder.defaultRequestAttributes(), "defaultRequestAttributes");
            this.restOpArgs = ((RestOpArgList)builder.restOpArgs().build()).asArray();
            this.debugEnablement = (DebugEnablement)bs.add(DebugEnablement.class, (Object)((DebugEnablement)builder.debugEnablement().orElse(null)));
            this.startCallMethods = (MethodInvoker[])builder.startCallMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.endCallMethods = (MethodInvoker[])builder.endCallMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.postInitMethods = (MethodInvoker[])builder.postInitMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.postInitChildFirstMethods = (MethodInvoker[])builder.postInitChildFirstMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.destroyMethods = (MethodInvoker[])builder.destroyMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.preCallMethods = builder.preCallMethods();
            this.postCallMethods = builder.postCallMethods();
            this.restOperations = (RestOperations)builder.restOperations(this).build();
            this.restChildren = (RestChildren)builder.restChildren(this).build();
            this.swaggerProvider = (SwaggerProvider)bs.add(SwaggerProvider.class, (Object)((SwaggerProvider)builder.swaggerProvider().orElse(null)));
            List<RestOpContext> opContexts = this.restOperations.getOpContexts();
            this.produces = builder.produces().orElseGet(() -> {
                Set s = opContexts.isEmpty() ? Collections.emptySet() : CollectionUtils.toSet((Collection)((RestOpContext)opContexts.get(0)).getSerializers().getSupportedMediaTypes());
                opContexts.forEach(x -> s.retainAll(x.getSerializers().getSupportedMediaTypes()));
                return CollectionUtils.u((List)CollectionUtils.toList((Collection)s));
            });
            this.consumes = builder.consumes().orElseGet(() -> {
                Set s = opContexts.isEmpty() ? Collections.emptySet() : CollectionUtils.toSet((Collection)((RestOpContext)opContexts.get(0)).getParsers().getSupportedMediaTypes());
                opContexts.forEach(x -> s.retainAll(x.getParsers().getSupportedMediaTypes()));
                return CollectionUtils.u((List)CollectionUtils.toList((Collection)s));
            });
        }
        catch (BasicHttpException e) {
            _initException = e;
            throw e;
        }
        catch (Exception e) {
            _initException = new InternalServerError((Throwable)e);
            throw e;
        }
        finally {
            this.initException = _initException;
        }
    }

    public RestSession.Builder createSession() {
        return RestSession.create(this);
    }

    public void destroy() {
        for (MethodInvoker x : this.destroyMethods) {
            try {
                x.invoke(this.beanStore, this.getResource());
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, RestContext.unwrap(e), () -> Utils.f((String)"Error occurred invoking servlet-destroy method ''{0}''.", (Object[])new Object[]{x.getFullName()}));
            }
        }
        this.restChildren.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object resource, HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        if (Utils.nn((Object)((Object)this.localSession.get()))) {
            System.err.println("WARNING:  Thread-local call object was not cleaned up from previous request.  " + String.valueOf((Object)this) + ", thread=[" + Thread.currentThread().getId() + "]");
        }
        RestSession.Builder sb = this.createSession().resource(resource).req(r1).res(r2).logger(this.getCallLogger());
        try {
            Optional<RestChildMatch> childMatch;
            if (Utils.nn((Object)((Object)this.initException))) {
                throw this.initException;
            }
            if (this.pathMatcher.hasVars() && this.parentContext == null) {
                String sp = sb.req().getServletPath();
                String pi = sb.getPathInfoUndecoded();
                UrlPath upi2 = UrlPath.of((String)(pi == null ? sp : sp + pi));
                UrlPathMatch uppm = this.pathMatcher.match(upi2);
                if (Utils.nn((Object)uppm) && !uppm.hasEmptyVars()) {
                    sb.pathVars(uppm.getVars());
                    sb.req((HttpServletRequest)new OverrideableHttpServletRequest(sb.req()).pathInfo(Utils.nullIfEmpty((String)StringUtils.urlDecode((String)uppm.getSuffix()))).servletPath(uppm.getPrefix()));
                } else {
                    RestSession call = sb.build();
                    call.debug(this.isDebug(call)).status(404).finish();
                    return;
                }
            }
            if ((childMatch = this.restChildren.findMatch(sb)).isPresent()) {
                UrlPathMatch uppm = childMatch.get().getPathMatch();
                RestContext rc = childMatch.get().getChildContext();
                if (!uppm.hasEmptyVars()) {
                    sb.pathVars(uppm.getVars());
                    OverrideableHttpServletRequest childRequest = new OverrideableHttpServletRequest(sb.req()).pathInfo(Utils.nullIfEmpty((String)StringUtils.urlDecode((String)uppm.getSuffix()))).servletPath(sb.req().getServletPath() + uppm.getPrefix());
                    rc.execute(rc.getResource(), (HttpServletRequest)childRequest, sb.res());
                } else {
                    RestSession call = sb.build();
                    call.debug(this.isDebug(call)).status(404).finish();
                }
                return;
            }
        }
        catch (Throwable e) {
            this.handleError(sb.build(), this.convertThrowable(e));
        }
        RestSession s = sb.build();
        try {
            this.localSession.set(s);
            s.debug(this.isDebug(s));
            this.startCall(s);
            s.run();
        }
        catch (Throwable e) {
            this.handleError(s, this.convertThrowable(e));
        }
        finally {
            try {
                s.finish();
                this.endCall(s);
            }
            finally {
                this.localSession.remove();
            }
        }
    }

    public Set<String> getAllowedHeaderParams() {
        return this.allowedHeaderParams;
    }

    public Set<String> getAllowedMethodHeaders() {
        return this.allowedMethodHeaders;
    }

    public Set<String> getAllowedMethodParams() {
        return this.allowedMethodParams;
    }

    public AnnotationWorkList getAnnotations() {
        return this.builder.getApplied();
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public BeanStore getBeanStore() {
        return this.beanStore;
    }

    public ServletConfig getBuilder() {
        return this.builder;
    }

    public CallLogger getCallLogger() {
        return this.callLogger;
    }

    public String getClientVersionHeader() {
        return this.clientVersionHeader;
    }

    public Config getConfig() {
        return this.config;
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public DebugEnablement getDebugEnablement() {
        return this.debugEnablement;
    }

    public NamedAttributeMap getDefaultRequestAttributes() {
        return this.defaultRequestAttributes;
    }

    public HeaderList getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    public HeaderList getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    public EncoderSet getEncoders() {
        return this.encoders;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    public RestSession getLocalSession() {
        RestSession rc = this.localSession.get();
        if (rc == null) {
            throw new InternalServerError("No active request on current thread.", new Object[0]);
        }
        return rc;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public MethodExecStore getMethodExecStore() {
        return this.methodExecStore;
    }

    public ParserSet getParsers() {
        return this.parsers;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public String getPath() {
        return this.path;
    }

    public UrlPathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public Object getResource() {
        return this.resource.get();
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public RestChildren getRestChildren() {
        return this.restChildren;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public BeanStore getRootBeanStore() {
        return this.rootBeanStore;
    }

    public SerializerSet getSerializers() {
        return this.serializers;
    }

    public String getServletInitParameter(String name) {
        return this.builder.getInitParameter(name);
    }

    public StaticFiles getStaticFiles() {
        return this.staticFiles;
    }

    public RestContextStats getStats() {
        return new RestContextStats(this.startTime, this.getMethodExecStore().getStatsByTotalTime());
    }

    public Optional<Swagger> getSwagger(Locale locale) {
        Swagger s = this.swaggerCache.get(locale);
        if (s == null) {
            try {
                s = this.swaggerProvider.getSwagger(this, locale);
                if (Utils.nn((Object)s)) {
                    this.swaggerCache.put(locale, s);
                }
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e);
            }
        }
        return Utils.opt((Object)s);
    }

    public SwaggerProvider getSwaggerProvider() {
        return this.swaggerProvider;
    }

    public ThrownStore getThrownStore() {
        return this.thrownStore;
    }

    public String getUriAuthority() {
        if (Utils.nn((Object)this.uriAuthority)) {
            return this.uriAuthority;
        }
        if (Utils.nn((Object)((Object)this.parentContext))) {
            return this.parentContext.getUriAuthority();
        }
        return null;
    }

    public String getUriContext() {
        if (Utils.nn((Object)this.uriContext)) {
            return this.uriContext;
        }
        if (Utils.nn((Object)((Object)this.parentContext))) {
            return this.parentContext.getUriContext();
        }
        return null;
    }

    public UriRelativity getUriRelativity() {
        return this.uriRelativity;
    }

    public UriResolution getUriResolution() {
        return this.uriResolution;
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public boolean isAllowContentParam() {
        return this.allowContentParam;
    }

    public boolean isRenderResponseStackTraces() {
        return this.renderResponseStackTraces;
    }

    public synchronized RestContext postInit() throws ServletException {
        if (this.initialized.get()) {
            return this;
        }
        Object resource = this.getResource();
        MethodInfo mi = ClassInfo.of((Object)this.getResource()).getPublicMethod(x -> x.hasName("setContext") && x.hasParameterTypes(new Class[]{RestContext.class})).orElse(null);
        if (Utils.nn((Object)mi)) {
            try {
                mi.accessible().invoke(resource, new Object[]{this});
            }
            catch (ExecutableException e) {
                throw new ServletException(e.unwrap());
            }
        }
        for (MethodInvoker x2 : this.postInitMethods) {
            try {
                x2.invoke(this.beanStore, this.getResource());
            }
            catch (Exception e) {
                throw new ServletException(RestContext.unwrap(e));
            }
        }
        this.restChildren.postInit();
        return this;
    }

    public RestContext postInitChildFirst() throws ServletException {
        if (this.initialized.get()) {
            return this;
        }
        this.restChildren.postInitChildFirst();
        for (MethodInvoker x : this.postInitChildFirstMethods) {
            try {
                x.invoke(this.beanStore, this.getResource());
            }
            catch (Exception e) {
                throw new ServletException(RestContext.unwrap(e));
            }
        }
        this.initialized.set(true);
        return this;
    }

    private boolean isDebug(RestSession call) {
        return this.debugEnablement.isDebug(this, call.getRequest());
    }

    private static Set<String> newCaseInsensitiveSet(String value) {
        TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean contains(Object v) {
                return v == null ? false : super.contains(v);
            }
        };
        StringUtils.split((String)value, arg_0 -> RestContext.lambda$newCaseInsensitiveSet$14(s, arg_0));
        return CollectionUtils.u((Set)s);
    }

    private MethodInvoker toMethodInvoker(Method m) {
        return new MethodInvoker(m, this.getMethodExecStats(m));
    }

    private static Throwable unwrap(Throwable t) {
        if (t instanceof InvocationTargetException) {
            InvocationTargetException t2 = (InvocationTargetException)t;
            return t2.getTargetException();
        }
        return t;
    }

    protected Throwable convertThrowable(Throwable t) {
        Throwable t2;
        if (t instanceof InvocationTargetException) {
            t2 = (InvocationTargetException)t;
            t = ((InvocationTargetException)t2).getTargetException();
        }
        if (t instanceof ExecutableException) {
            ExecutableException t3 = (ExecutableException)t;
            t = t3.getTargetException();
        }
        if (t instanceof BasicHttpException) {
            t2 = (BasicHttpException)t;
            return t2;
        }
        ClassInfo ci = ClassInfo.of((Object)t);
        if (ci.hasAnnotation(Response.class)) {
            return t;
        }
        if (ci.isChildOf(ParseException.class) || ci.is(InvalidDataConversionException.class)) {
            return new BadRequest(t);
        }
        String n = Utils.cn((Object)t);
        if (Utils.co((String)n, (String)"AccessDenied") || Utils.co((String)n, (String)"Unauthorized")) {
            return new Unauthorized(t);
        }
        if (Utils.co((String)n, (String)"Empty") || Utils.co((String)n, (String)"NotFound")) {
            return new NotFound(t);
        }
        return t;
    }

    protected void endCall(RestSession session) {
        for (MethodInvoker x : this.endCallMethods) {
            try {
                x.invoke(session.getBeanStore(), session.getResource());
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, RestContext.unwrap(e), () -> Utils.f((String)"Error occurred invoking finish-call method ''{0}''.", (Object[])new Object[]{x.getFullName()}));
            }
        }
    }

    protected RestOpArg[] findRestOperationArgs(Method m, BeanStore beanStore) {
        MethodInfo mi = MethodInfo.of((Method)m);
        List params = mi.getParameters();
        RestOpArg[] ra = new RestOpArg[params.size()];
        beanStore = BeanStore.of((BeanStore)beanStore, (Object)this.getResource());
        for (int i = 0; i < params.size(); ++i) {
            ParameterInfo pi = (ParameterInfo)params.get(i);
            beanStore.addBean(ParameterInfo.class, (Object)pi);
            for (Class<? extends RestOpArg> c : this.restOpArgs) {
                try {
                    ra[i] = (RestOpArg)beanStore.createBean(RestOpArg.class).type(c).run();
                    if (!Utils.nn((Object)ra[i])) continue;
                    break;
                }
                catch (ExecutableException e) {
                    throw new InternalServerError(e.unwrap(), "Could not resolve parameter {0} on method {1}.", new Object[]{i, mi.getFullName()});
                }
            }
            if (ra[i] != null) continue;
            throw new InternalServerError("Could not resolve parameter {0} on method {1}.", new Object[]{i, mi.getFullName()});
        }
        return ra;
    }

    protected MethodExecStats getMethodExecStats(Method m) {
        return this.methodExecStore.getStats(m);
    }

    protected MethodList getPostCallMethods() {
        return this.postCallMethods;
    }

    protected MethodList getPreCallMethods() {
        return this.preCallMethods;
    }

    protected synchronized void handleError(RestSession session, Throwable e) throws IOException {
        BasicHttpException e3;
        session.exception(e);
        if (session.isDebug()) {
            e.printStackTrace();
        }
        int code = 500;
        ClassInfo ci = ClassInfo.of((Object)e);
        StatusCode r = ci.getAnnotations(StatusCode.class).findFirst().map(AnnotationInfo::inner).orElse(null);
        if (Utils.nn((Object)r) && r.value().length > 0) {
            code = r.value()[0];
        }
        BasicHttpException e2 = e instanceof BasicHttpException ? (e3 = (BasicHttpException)e) : new BasicHttpException(code, e);
        HttpServletRequest req = session.getRequest();
        HttpServletResponse res = session.getResponse();
        Throwable t = e2.getRootCause();
        if (Utils.nn((Object)t)) {
            Thrown t2 = HttpHeaders.thrown((Throwable[])new Throwable[]{t});
            res.setHeader(t2.getName(), t2.getValue());
        }
        try {
            res.setContentType("text/plain");
            res.setHeader("Content-Encoding", "identity");
            int statusCode = e2.getStatusLine().getStatusCode();
            res.setStatus(statusCode);
            PrintWriter w = null;
            try {
                w = res.getWriter();
            }
            catch (IllegalStateException x) {
                w = new PrintWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), IoUtils.UTF8));
            }
            try (PrintWriter w2 = w;){
                String httpMessage = RestUtils.getHttpResponseText(statusCode);
                if (Utils.nn((Object)httpMessage)) {
                    w2.append("HTTP ").append(String.valueOf(statusCode)).append(": ").append(httpMessage).append("\n\n");
                }
                if (this.isRenderResponseStackTraces()) {
                    e.printStackTrace(w2);
                } else {
                    w2.append(e2.getFullStackMessage(true));
                }
            }
        }
        catch (Exception e1) {
            req.setAttribute("Exception", (Object)e1);
        }
    }

    protected void handleNotFound(RestSession session) throws Exception {
        String onPath;
        String pathInfo = session.getPathInfo();
        String methodUC = session.getMethod();
        int rc = session.getStatus();
        String string = onPath = pathInfo == null ? " on no pathInfo" : String.format(" on path '%s'", pathInfo);
        if (rc == 404) {
            throw new NotFound("Method ''{0}'' not found on resource with matching pattern{1}.", new Object[]{methodUC, onPath});
        }
        if (rc == 412) {
            throw new PreconditionFailed("Method ''{0}'' not found on resource{1} with matching matcher.", new Object[]{methodUC, onPath});
        }
        if (rc == 405) {
            throw new MethodNotAllowed("Method ''{0}'' not found on resource{1}.", new Object[]{methodUC, onPath});
        }
        throw new ServletException("Invalid method response: " + rc, session.getException());
    }

    protected void postCall(RestOpSession session) throws Throwable {
        for (RestOpInvoker m : session.getContext().getPostCallMethods()) {
            m.invoke(session);
        }
    }

    protected void preCall(RestOpSession session) throws Throwable {
        for (RestOpInvoker m : session.getContext().getPreCallMethods()) {
            m.invoke(session);
        }
    }

    protected void processResponse(RestOpSession opSession) throws IOException, BasicHttpException, NotImplemented {
        int loops = 5;
        for (int i = 0; i < this.responseProcessors.length; ++i) {
            int j = this.responseProcessors[i].process(opSession);
            if (j == 1) {
                return;
            }
            if (j != 2) continue;
            if (loops-- < 0) {
                throw new InternalServerError("Too many processing loops.", new Object[0]);
            }
            i = -1;
        }
        Object output = opSession.getResponse().getContent().orElse(null);
        throw new NotImplemented("No response processors found to process output of type ''{0}''", new Object[]{Utils.cn(output)});
    }

    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"allowContentParam", (Object)this.allowContentParam).a((Object)"allowedHeaderParams", this.allowedHeaderParams).a((Object)"allowedMethodHeader", this.allowedMethodHeaders).a((Object)"allowedMethodParams", this.allowedMethodParams).a((Object)"beanStore", (Object)this.beanStore).a((Object)"clientVersionHeader", (Object)this.clientVersionHeader).a((Object)"consumes", this.consumes).a((Object)"defaultRequestHeaders", (Object)this.defaultRequestHeaders).a((Object)"defaultResponseHeaders", (Object)this.defaultResponseHeaders).a((Object)"partParser", (Object)this.partParser).a((Object)"partSerializer", (Object)this.partSerializer).a((Object)"produces", this.produces).a((Object)"renderResponseStackTraces", (Object)this.renderResponseStackTraces).a((Object)"responseProcessors", (Object)this.responseProcessors).a((Object)"restOpArgs", this.restOpArgs).a((Object)"staticFiles", (Object)this.staticFiles).a((Object)"swaggerProvider", (Object)this.swaggerProvider).a((Object)"uriAuthority", (Object)this.uriAuthority).a((Object)"uriContext", (Object)this.uriContext).a((Object)"uriRelativity", (Object)this.uriRelativity).a((Object)"uriResolution", (Object)this.uriResolution);
    }

    protected void startCall(RestSession session) throws BasicHttpException {
        for (MethodInvoker x : this.startCallMethods) {
            try {
                x.invoke(session.getBeanStore(), session.getContext().getResource());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new InternalServerError((Throwable)e, "Error occurred invoking start-call method ''{0}''.", new Object[]{x.getFullName()});
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof BasicHttpException) {
                    BasicHttpException t2 = (BasicHttpException)t;
                    throw t2;
                }
                throw new InternalServerError(t);
            }
        }
    }

    private static /* synthetic */ void lambda$newCaseInsensitiveSet$14(1 s, String x) {
        s.add(x);
    }

    public static class Builder
    extends Context.Builder
    implements ServletConfig {
        private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
        private static final Set<Class<?>> DELAYED_INJECTION = CollectionUtils.set((Object[])new Class[]{BeanContext.Builder.class, BeanStore.Builder.class, BeanStore.class, CallLogger.Builder.class, CallLogger.class, Config.class, DebugEnablement.Builder.class, DebugEnablement.class, EncoderSet.Builder.class, EncoderSet.class, FileFinder.Builder.class, FileFinder.class, HttpPartParser.class, HttpPartParser.Creator.class, HttpPartSerializer.class, HttpPartSerializer.Creator.class, JsonSchemaGenerator.Builder.class, JsonSchemaGenerator.class, Logger.class, Messages.Builder.class, Messages.class, MethodExecStore.Builder.class, MethodExecStore.class, ParserSet.Builder.class, ParserSet.class, ResponseProcessorList.Builder.class, ResponseProcessorList.class, RestChildren.Builder.class, RestChildren.class, RestOpArgList.Builder.class, RestOpArgList.class, RestOperations.Builder.class, RestOperations.class, SerializerSet.Builder.class, SerializerSet.class, StaticFiles.Builder.class, StaticFiles.class, SwaggerProvider.Builder.class, SwaggerProvider.class, ThrownStore.Builder.class, ThrownStore.class, VarList.class, VarResolver.Builder.class, VarResolver.class});
        private static final Set<String> DELAYED_INJECTION_NAMES = CollectionUtils.set((Object[])new String[]{"defaultRequestAttributes", "defaultRequestHeaders", "defaultResponseHeaders", "destroyMethods", "endCallMethods", "postCallMethods", "postInitChildFirstMethods", "postInitMethods", "preCallMethods", "startCallMethods"});
        private BeanContext.Builder beanContext;
        private BeanCreator<CallLogger> callLogger;
        private BeanCreator<DebugEnablement> debugEnablement;
        private BeanCreator<StaticFiles> staticFiles;
        private BeanCreator<SwaggerProvider> swaggerProvider;
        private BeanStore beanStore;
        private BeanStore rootBeanStore;
        private boolean disableContentParam = (Boolean)Utils.env((String)"RestContext.disableContentParam", (Object)false);
        private boolean initialized;
        private boolean renderResponseStackTraces = (Boolean)Utils.env((String)"RestContext.renderResponseStackTraces", (Object)false);
        private Charset defaultCharset = (Charset)Utils.env((String)"RestContext.defaultCharset").map(Charset::forName).orElse((Object)IoUtils.UTF8);
        private Class<? extends RestChildren> childrenClass = RestChildren.class;
        private Class<? extends RestOpContext> opContextClass = RestOpContext.class;
        private final Class<?> resourceClass;
        private Config config;
        private DefaultClassList defaultClasses;
        private DefaultSettingsMap defaultSettings;
        private EncoderSet.Builder encoders;
        private HeaderList defaultRequestHeaders;
        private HeaderList defaultResponseHeaders;
        private HttpPartParser.Creator partParser;
        private HttpPartSerializer.Creator partSerializer;
        private JsonSchemaGenerator.Builder jsonSchemaGenerator;
        private List<MediaType> consumes;
        private List<MediaType> produces;
        private List<Object> children = CollectionUtils.list((Object[])new Object[0]);
        private Logger logger;
        private long maxInput = (Long)Utils.env((String)"RestContext.maxInput").map(StringUtils::parseLongWithSuffix).orElse((Object)100000000L);
        private MethodExecStore.Builder methodExecStore;
        private MethodList destroyMethods;
        private MethodList endCallMethods;
        private MethodList postCallMethods;
        private MethodList postInitChildFirstMethods;
        private MethodList postInitMethods;
        private MethodList preCallMethods;
        private MethodList startCallMethods;
        private Messages.Builder messages;
        private NamedAttributeMap defaultRequestAttributes;
        private ParserSet.Builder parsers;
        private final RestContext parentContext;
        private RestChildren.Builder restChildren;
        private RestOpArgList.Builder restOpArgs;
        private RestOperations.Builder restOperations;
        private ResponseProcessorList.Builder responseProcessors;
        private ResourceSupplier resource;
        private SerializerSet.Builder serializers;
        private final ServletConfig inner;
        private String allowedHeaderParams = (String)Utils.env((String)"RestContext.allowedHeaderParams", (Object)"Accept,Content-Type");
        private String allowedMethodHeaders = (String)Utils.env((String)"RestContext.allowedMethodHeaders", (Object)"");
        private String allowedMethodParams = (String)Utils.env((String)"RestContext.allowedMethodParams", (Object)"HEAD,OPTIONS");
        private String clientVersionHeader = (String)Utils.env((String)"RestContext.clientVersionHeader", (Object)"Client-Version");
        private String path = null;
        private String uriAuthority = (String)Utils.env((String)"RestContext.uriAuthority").orElse(null);
        private String uriContext = (String)Utils.env((String)"RestContext.uriContext").orElse(null);
        private ThrownStore.Builder thrownStore;
        private UriRelativity uriRelativity = (UriRelativity)Utils.env((String)"RestContext.uriRelativity", (Object)UriRelativity.RESOURCE);
        private UriResolution uriResolution = (UriResolution)Utils.env((String)"RestContext.uriResolution", (Object)UriResolution.ROOT_RELATIVE);
        private VarResolver.Builder varResolver;

        private static <T extends Annotation> MethodList getAnnotatedMethods(Supplier<?> resource, Class<T> annotation, Predicate<T> predicate) {
            LinkedHashMap x = CollectionUtils.map();
            Object r = resource.get();
            AnnotationProvider ap = AP;
            ClassInfo.ofProxy(r).getAllMethodsTopDown().stream().filter(y -> y.hasAnnotation(annotation)).forEach(y -> CollectionUtils.rstream((List)ap.find(annotation, y, new AnnotationTraversal[0])).map(AnnotationInfo::inner).filter(z -> predicate == null || predicate.test(z)).forEach(z -> x.put(y.getSignature(), y.accessible().inner())));
            MethodList x2 = MethodList.of(x.values());
            return x2;
        }

        private static boolean isRestBeanMethod(MethodInfo mi) {
            RestInject x = mi.getAnnotations(RestInject.class).findFirst().map(AnnotationInfo::inner).orElse(null);
            return Utils.nn((Object)x) && x.methodScope().length == 0;
        }

        private static boolean isRestBeanMethod(MethodInfo mi, String name) {
            RestInject x = mi.getAnnotations(RestInject.class).findFirst().map(AnnotationInfo::inner).orElse(null);
            return Utils.nn((Object)x) && x.methodScope().length == 0 && x.name().equals(name);
        }

        protected Builder(Class<?> resourceClass, RestContext parentContext, ServletConfig servletConfig) {
            this.resourceClass = resourceClass;
            this.inner = servletConfig;
            this.parentContext = parentContext;
            if (Utils.nn((Object)((Object)parentContext))) {
                this.defaultClasses = parentContext.defaultClasses.copy();
                this.defaultSettings = parentContext.defaultSettings.copy();
                this.rootBeanStore = parentContext.rootBeanStore;
            } else {
                this.defaultClasses = DefaultClassList.create();
                this.defaultSettings = DefaultSettingsMap.create();
            }
        }

        public Builder allowedHeaderParams(String value) {
            this.allowedHeaderParams = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder allowedMethodHeaders(String value) {
            this.allowedMethodHeaders = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder allowedMethodParams(String value) {
            this.allowedMethodParams = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        public BeanContext.Builder beanContext() {
            if (this.beanContext == null) {
                this.beanContext = this.createBeanContext(this.beanStore(), this.resource());
            }
            return this.beanContext;
        }

        public BeanStore beanStore() {
            return this.beanStore;
        }

        public <T> Builder beanStore(Class<T> beanType, T bean) {
            this.beanStore().addBean(beanType, bean);
            return this;
        }

        public <T> Builder beanStore(Class<T> beanType, T bean, String name) {
            this.beanStore().addBean(beanType, bean, name);
            return this;
        }

        public RestContext build() {
            try {
                return (RestContext)((Object)this.beanStore().createBean(RestContext.class).type(this.getType().orElse(RestContext.class)).builder(Builder.class, (Object)this).run());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalServerError((Throwable)e, "Could not instantiate RestContext.", new Object[0]);
            }
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        public BeanCreator<CallLogger> callLogger() {
            if (this.callLogger == null) {
                this.callLogger = this.createCallLogger(this.beanStore, this.resource);
            }
            return this.callLogger;
        }

        public Builder callLogger(CallLogger value) {
            this.callLogger().impl((Object)((CallLogger)AssertionUtils.assertArgNotNull((String)"value", (Object)value)));
            return this;
        }

        public Builder callLogger(Class<? extends CallLogger> value) {
            this.callLogger().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder child(String path, Object child) {
            this.children.add(new RestChild((String)AssertionUtils.assertArgNotNull((String)"path", (Object)path), child));
            return this;
        }

        public Builder children(Object ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            CollectionUtils.addAll(this.children, (Object[])values);
            return this;
        }

        public Builder clientVersionHeader(String value) {
            this.clientVersionHeader = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Config config() {
            return this.config;
        }

        public Builder config(Config value) {
            this.config = (Config)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Optional<List<MediaType>> consumes() {
            return Utils.opt(this.consumes);
        }

        public Builder consumes(MediaType ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.consumes = CollectionUtils.addAll(this.consumes, (Object[])values);
            return this;
        }

        public Builder copy() {
            throw new NoSuchMethodError("Not implemented.");
        }

        public Builder debug() {
            super.debug();
            return this;
        }

        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder debugDefault(Enablement value) {
            this.defaultSettings().set("RestContext.debugDefault", AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public BeanCreator<DebugEnablement> debugEnablement() {
            if (this.debugEnablement == null) {
                this.debugEnablement = this.createDebugEnablement(this.beanStore, this.resource);
            }
            return this.debugEnablement;
        }

        public Builder debugEnablement(Class<? extends DebugEnablement> value) {
            this.debugEnablement().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder debugEnablement(DebugEnablement value) {
            this.debugEnablement().impl((Object)((DebugEnablement)AssertionUtils.assertArgNotNull((String)"value", (Object)value)));
            return this;
        }

        public Builder defaultAccept(String value) {
            if (Utils.ne((CharSequence)value)) {
                this.defaultRequestHeaders(new Header[]{HttpHeaders.accept((String)value)});
            }
            return this;
        }

        public Builder defaultCharset(Charset value) {
            this.defaultCharset = (Charset)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public DefaultClassList defaultClasses() {
            return this.defaultClasses;
        }

        public Builder defaultClasses(Class<?> ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.defaultClasses().add(values);
            return this;
        }

        public Builder defaultContentType(String value) {
            if (Utils.ne((CharSequence)value)) {
                this.defaultRequestHeaders(new Header[]{HttpHeaders.contentType((String)value)});
            }
            return this;
        }

        public NamedAttributeMap defaultRequestAttributes() {
            if (this.defaultRequestAttributes == null) {
                this.defaultRequestAttributes = this.createDefaultRequestAttributes(this.beanStore(), this.resource());
            }
            return this.defaultRequestAttributes;
        }

        public Builder defaultRequestAttributes(NamedAttribute ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.defaultRequestAttributes().add(values);
            return this;
        }

        public HeaderList defaultRequestHeaders() {
            if (this.defaultRequestHeaders == null) {
                this.defaultRequestHeaders = this.createDefaultRequestHeaders(this.beanStore(), this.resource());
            }
            return this.defaultRequestHeaders;
        }

        public Builder defaultRequestHeaders(Header ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.defaultRequestHeaders().setDefault(values);
            return this;
        }

        public HeaderList defaultResponseHeaders() {
            if (this.defaultResponseHeaders == null) {
                this.defaultResponseHeaders = this.createDefaultResponseHeaders(this.beanStore(), this.resource());
            }
            return this.defaultResponseHeaders;
        }

        public Builder defaultResponseHeaders(Header ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.defaultResponseHeaders().setDefault(values);
            return this;
        }

        public Builder defaultSetting(String key, Object value) {
            this.defaultSettings().set((String)AssertionUtils.assertArgNotNull((String)"key", (Object)key), value);
            return this;
        }

        public DefaultSettingsMap defaultSettings() {
            return this.defaultSettings;
        }

        public MethodList destroyMethods() {
            if (this.destroyMethods == null) {
                this.destroyMethods = this.createDestroyMethods(this.beanStore(), this.resource());
            }
            return this.destroyMethods;
        }

        public Builder disableContentParam() {
            return this.disableContentParam(true);
        }

        public Builder disableContentParam(boolean value) {
            this.disableContentParam = value;
            return this;
        }

        public EncoderSet.Builder encoders() {
            if (this.encoders == null) {
                this.encoders = this.createEncoders(this.beanStore(), this.resource());
            }
            return this.encoders;
        }

        @SafeVarargs
        public final Builder encoders(Class<? extends Encoder> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.encoders().add((Class[])value);
            return this;
        }

        public Builder encoders(Encoder ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.encoders().add(value);
            return this;
        }

        public MethodList endCallMethods() {
            if (this.endCallMethods == null) {
                this.endCallMethods = this.createEndCallMethods(this.beanStore(), this.resource());
            }
            return this.endCallMethods;
        }

        public EncoderSet.Builder getEncoders() {
            return this.encoders;
        }

        public String getInitParameter(String name) {
            return this.inner == null ? null : this.inner.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.inner == null ? new Vector().elements() : this.inner.getInitParameterNames();
        }

        public ParserSet.Builder getParsers() {
            return this.parsers;
        }

        public SerializerSet.Builder getSerializers() {
            return this.serializers;
        }

        public ServletContext getServletContext() {
            return Utils.nn((Object)this.inner) ? this.inner.getServletContext() : (Utils.nn((Object)((Object)this.parentContext)) ? this.parentContext.getBuilder().getServletContext() : null);
        }

        public String getServletName() {
            return this.inner == null ? null : this.inner.getServletName();
        }

        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder init(Supplier<?> resource) throws ServletException {
            if (this.initialized) {
                return this;
            }
            this.initialized = true;
            ResourceSupplier r = this.resource = new ResourceSupplier(this.resourceClass, (Supplier)AssertionUtils.assertArgNotNull((String)"resource", resource));
            Class<?> rc = this.resourceClass;
            this.beanStore = this.createBeanStore(resource).build().addBean(Builder.class, (Object)this).addBean(ResourceSupplier.class, (Object)this.resource).addBean(ServletConfig.class, Utils.nn((Object)this.inner) ? this.inner : this).addBean(ServletContext.class, (Object)(Utils.nn((Object)this.inner) ? this.inner : this).getServletContext());
            if (this.rootBeanStore == null) {
                this.rootBeanStore = this.beanStore;
                this.beanStore = BeanStore.of((BeanStore)this.rootBeanStore, (Object)r.get());
            }
            BeanStore bs = this.beanStore;
            this.beanStore.add(BeanStore.class, (Object)bs);
            this.varResolver = this.createVarResolver(bs, r, rc);
            this.beanStore.add(VarResolver.class, (Object)((VarResolver)this.varResolver.build()));
            this.config = (Config)this.beanStore.add(Config.class, (Object)this.createConfig(bs, r, rc));
            this.beanStore.add(VarResolver.class, (Object)((VarResolver)this.varResolver.bean(Config.class, (Object)this.config).build()));
            ClassInfoTyped rci = ClassInfo.of(this.resourceClass);
            rci.getAllFields().stream().filter(x -> x.hasAnnotation(RestInject.class)).forEach(x -> Utils.opt((Object)x.get(resource.get())).ifPresent(y -> this.beanStore.add(x.getFieldType().inner(), y, RestInjectAnnotation.name(x.getAnnotations(RestInject.class).findFirst().map(AnnotationInfo::inner).orElse(null)))));
            rci.getAllMethods().stream().filter(x -> x.hasAnnotation(RestInject.class)).forEach(x -> {
                Class rt = x.getReturnType().inner();
                String name = RestInjectAnnotation.name(x.getAnnotations(RestInject.class).findFirst().map(AnnotationInfo::inner).orElse(null));
                if (!DELAYED_INJECTION.contains(rt) && !DELAYED_INJECTION_NAMES.contains(name)) {
                    this.beanStore.createMethodFinder(rt).find(Builder::isRestBeanMethod).run(y -> this.beanStore.add(rt, y, name));
                }
            });
            VarResolverSession vrs = ((VarResolver)this.varResolver().build()).createSession();
            AnnotationWorkList work = AnnotationWorkList.of((VarResolverSession)vrs, CollectionUtils.rstream((List)AP.find((ClassInfo)rci, new AnnotationTraversal[0])).filter(Context.CONTEXT_APPLY_FILTER));
            this.apply(work);
            this.beanContext().apply(work);
            this.partSerializer().apply(work);
            this.partParser().apply(work);
            this.jsonSchemaGenerator().apply(work);
            Builder.runInitHooks(bs, this.resource());
            rci.getAllFields().stream().filter(x -> x.hasAnnotation(RestInject.class)).forEach(x -> x.setIfNull(resource.get(), this.beanStore.getBean(x.getFieldType().inner(), RestInjectAnnotation.name(x.getAnnotations(RestInject.class).findFirst().map(AnnotationInfo::inner).orElse(null))).orElse(null)));
            return this;
        }

        public JsonSchemaGenerator.Builder jsonSchemaGenerator() {
            if (this.jsonSchemaGenerator == null) {
                this.jsonSchemaGenerator = this.createJsonSchemaGenerator(this.beanStore(), this.resource());
            }
            return this.jsonSchemaGenerator;
        }

        public Builder jsonSchemaGenerator(Class<? extends JsonSchemaGenerator> value) {
            this.jsonSchemaGenerator().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder jsonSchemaGenerator(JsonSchemaGenerator value) {
            this.jsonSchemaGenerator().impl((Context)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Logger logger() {
            if (this.logger == null) {
                this.logger = this.createLogger(this.beanStore(), this.resource, this.resourceClass);
            }
            return this.logger;
        }

        public Builder logger(Logger value) {
            this.logger = (Logger)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder maxInput(String value) {
            this.maxInput = StringUtils.parseLongWithSuffix((String)((String)AssertionUtils.assertArgNotNull((String)"value", (Object)value)));
            return this;
        }

        public Messages.Builder messages() {
            if (this.messages == null) {
                this.messages = this.createMessages(this.beanStore(), this.resource());
            }
            return this.messages;
        }

        public Builder messages(Class<? extends Messages> value) {
            this.messages().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder messages(Messages value) {
            this.messages().impl(AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public MethodExecStore.Builder methodExecStore() {
            if (this.methodExecStore == null) {
                this.methodExecStore = this.createMethodExecStore(this.beanStore(), this.resource());
            }
            return this.methodExecStore;
        }

        public Builder methodExecStore(Class<? extends MethodExecStore> value) {
            this.methodExecStore().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder methodExecStore(MethodExecStore value) {
            this.methodExecStore().impl(AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder parserListener(Class<? extends ParserListener> value) {
            if (ClassUtils.isNotVoid((Class)((Class)AssertionUtils.assertArgNotNull((String)"value", value)))) {
                this.parsers.forEach(x -> x.listener(value));
            }
            return this;
        }

        public ParserSet.Builder parsers() {
            if (this.parsers == null) {
                this.parsers = this.createParsers(this.beanStore(), this.resource());
            }
            return this.parsers;
        }

        @SafeVarargs
        public final Builder parsers(Class<? extends Parser> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.parsers().add((Class[])value);
            return this;
        }

        public Builder parsers(Parser ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.parsers().add(value);
            return this;
        }

        public HttpPartParser.Creator partParser() {
            if (this.partParser == null) {
                this.partParser = this.createPartParser(this.beanStore(), this.resource());
            }
            return this.partParser;
        }

        public Builder partParser(Class<? extends HttpPartParser> value) {
            this.partParser().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder partParser(HttpPartParser value) {
            this.partParser().impl(AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public HttpPartSerializer.Creator partSerializer() {
            if (this.partSerializer == null) {
                this.partSerializer = this.createPartSerializer(this.beanStore(), this.resource());
            }
            return this.partSerializer;
        }

        public Builder partSerializer(Class<? extends HttpPartSerializer> value) {
            this.partSerializer().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder partSerializer(HttpPartSerializer value) {
            this.partSerializer().impl(AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder path(String value) {
            if (Utils.ne((CharSequence)(value = StringUtils.trimLeadingSlashes((String)value)))) {
                this.path = value;
            }
            return this;
        }

        public MethodList postCallMethods() {
            if (this.postCallMethods == null) {
                this.postCallMethods = this.createPostCallMethods(this.beanStore(), this.resource());
            }
            return this.postCallMethods;
        }

        public MethodList postInitChildFirstMethods() {
            if (this.postInitChildFirstMethods == null) {
                this.postInitChildFirstMethods = this.createPostInitChildFirstMethods(this.beanStore(), this.resource());
            }
            return this.postInitChildFirstMethods;
        }

        public MethodList postInitMethods() {
            if (this.postInitMethods == null) {
                this.postInitMethods = this.createPostInitMethods(this.beanStore(), this.resource());
            }
            return this.postInitMethods;
        }

        public MethodList preCallMethods() {
            if (this.preCallMethods == null) {
                this.preCallMethods = this.createPreCallMethods(this.beanStore(), this.resource());
            }
            return this.preCallMethods;
        }

        public Optional<List<MediaType>> produces() {
            return Utils.opt(this.produces);
        }

        public Builder produces(MediaType ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.produces = CollectionUtils.addAll(this.produces, (Object[])values);
            return this;
        }

        public Builder renderResponseStackTraces() {
            this.renderResponseStackTraces = true;
            return this;
        }

        public Builder renderResponseStackTraces(boolean value) {
            this.renderResponseStackTraces = value;
            return this;
        }

        public Supplier<?> resource() {
            return Objects.requireNonNull(this.resource, "Resource not available. init(Object) has not been called.");
        }

        public <T> Optional<T> resourceAs(Class<T> type) {
            Object r = this.resource().get();
            return Utils.opt(((Class)AssertionUtils.assertArgNotNull((String)"type", type)).isInstance(r) ? type.cast(r) : null);
        }

        public ResponseProcessorList.Builder responseProcessors() {
            if (this.responseProcessors == null) {
                this.responseProcessors = this.createResponseProcessors(this.beanStore(), this.resource());
            }
            return this.responseProcessors;
        }

        @SafeVarargs
        public final Builder responseProcessors(Class<? extends ResponseProcessor> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.responseProcessors().add(value);
            return this;
        }

        public Builder responseProcessors(ResponseProcessor ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.responseProcessors().add(value);
            return this;
        }

        public RestChildren.Builder restChildren(RestContext restContext) throws Exception {
            if (this.restChildren == null) {
                this.restChildren = this.createRestChildren(this.beanStore(), this.resource(), restContext);
            }
            return this.restChildren;
        }

        public Builder restChildrenClass(Class<? extends RestChildren> value) {
            this.childrenClass = (Class)AssertionUtils.assertArgNotNull((String)"value", value);
            return this;
        }

        public RestOpArgList.Builder restOpArgs() {
            if (this.restOpArgs == null) {
                this.restOpArgs = this.createRestOpArgs(this.beanStore(), this.resource());
            }
            return this.restOpArgs;
        }

        @SafeVarargs
        public final Builder restOpArgs(Class<? extends RestOpArg> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.restOpArgs().add(value);
            return this;
        }

        public Builder restOpContextClass(Class<? extends RestOpContext> value) {
            this.opContextClass = (Class)AssertionUtils.assertArgNotNull((String)"value", value);
            return this;
        }

        public RestOperations.Builder restOperations(RestContext restContext) throws ServletException {
            if (this.restOperations == null) {
                this.restOperations = this.createRestOperations(this.beanStore(), this.resource(), (RestContext)((Object)AssertionUtils.assertArgNotNull((String)"restContext", (Object)((Object)restContext))));
            }
            return this.restOperations;
        }

        public BeanStore rootBeanStore() {
            return this.rootBeanStore;
        }

        public Builder serializerListener(Class<? extends SerializerListener> value) {
            if (ClassUtils.isNotVoid((Class)((Class)AssertionUtils.assertArgNotNull((String)"value", value)))) {
                this.serializers.forEach(x -> x.listener(value));
            }
            return this;
        }

        public SerializerSet.Builder serializers() {
            if (this.serializers == null) {
                this.serializers = this.createSerializers(this.beanStore(), this.resource());
            }
            return this.serializers;
        }

        @SafeVarargs
        public final Builder serializers(Class<? extends Serializer> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.serializers().add((Class[])value);
            return this;
        }

        public Builder serializers(Serializer ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.serializers().add(value);
            return this;
        }

        public MethodList startCallMethods() {
            if (this.startCallMethods == null) {
                this.startCallMethods = this.createStartCallMethods(this.beanStore(), this.resource());
            }
            return this.startCallMethods;
        }

        public BeanCreator<StaticFiles> staticFiles() {
            if (this.staticFiles == null) {
                this.staticFiles = this.createStaticFiles(this.beanStore, this.resource);
            }
            return this.staticFiles;
        }

        public Builder staticFiles(Class<? extends StaticFiles> value) {
            this.staticFiles().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder staticFiles(StaticFiles value) {
            this.staticFiles().impl((Object)((StaticFiles)AssertionUtils.assertArgNotNull((String)"value", (Object)value)));
            return this;
        }

        public BeanCreator<SwaggerProvider> swaggerProvider() {
            if (this.swaggerProvider == null) {
                this.swaggerProvider = this.createSwaggerProvider(this.beanStore, this.resource);
            }
            return this.swaggerProvider;
        }

        public Builder swaggerProvider(Class<? extends SwaggerProvider> value) {
            this.swaggerProvider().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder swaggerProvider(SwaggerProvider value) {
            this.swaggerProvider().impl((Object)((SwaggerProvider)AssertionUtils.assertArgNotNull((String)"value", (Object)value)));
            return this;
        }

        public ThrownStore.Builder thrownStore() {
            if (this.thrownStore == null) {
                this.thrownStore = this.createThrownStore(this.beanStore(), this.resource(), this.parentContext);
            }
            return this.thrownStore;
        }

        public Builder thrownStore(Class<? extends ThrownStore> value) {
            this.thrownStore().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder thrownStore(ThrownStore value) {
            this.thrownStore().impl(AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        public Builder uriAuthority(String value) {
            this.uriAuthority = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder uriContext(String value) {
            this.uriContext = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder uriRelativity(UriRelativity value) {
            this.uriRelativity = (UriRelativity)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder uriResolution(UriResolution value) {
            this.uriResolution = (UriResolution)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public VarResolver.Builder varResolver() {
            return this.varResolver;
        }

        @SafeVarargs
        public final Builder vars(Class<? extends Var> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.varResolver.vars((Class[])value);
            return this;
        }

        public Builder vars(Var ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.varResolver.vars(value);
            return this;
        }

        private static void runInitHooks(BeanStore beanStore, Supplier<?> resource) throws ServletException {
            Object r = resource.get();
            LinkedHashMap map = CollectionUtils.map();
            ClassInfo.ofProxy(r).getAllMethodsTopDown().stream().filter(y -> y.hasAnnotation(RestInit.class) && !y.hasParameter(RestOpContext.Builder.class)).forEach(y -> {
                String sig = y.getSignature();
                if (!map.containsKey(sig)) {
                    map.put(sig, y.accessible());
                }
            });
            for (MethodInfo m : map.values()) {
                if (!beanStore.hasAllParams((ExecutableInfo)m)) {
                    throw RestContext.servletException("Could not call @RestInit method {0}.{1}.  Could not find prerequisites: {2}.", Utils.cns((Object)m.getDeclaringClass()), m.getSignature(), beanStore.getMissingParams((ExecutableInfo)m));
                }
                try {
                    m.invoke(r, beanStore.getParams((ExecutableInfo)m));
                }
                catch (Exception e) {
                    throw RestContext.servletException(e, "Exception thrown from @RestInit method {0}.{1}.", Utils.cns((Object)m.getDeclaringClass()), m.getSignature());
                }
            }
        }

        protected BeanContext.Builder createBeanContext(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)BeanContext.create());
            beanStore.getBean(BeanContext.Builder.class).map(BeanContext.Builder::copy).ifPresent(x -> v.set(x));
            beanStore.getBean(BeanContext.class).ifPresent(x -> ((BeanContext.Builder)v.get()).impl((Context)x));
            return (BeanContext.Builder)v.get();
        }

        protected BeanStore.Builder createBeanStore(Supplier<?> resource) {
            Value v = Value.of((Object)BeanStore.create().parent(this.rootBeanStore()).outer(resource.get()));
            CollectionUtils.rstream((List)AP.find(Rest.class, (ClassInfo)ReflectionUtils.info(this.resourceClass), new AnnotationTraversal[0])).map(x -> ((Rest)x.inner()).beanStore()).filter(ClassUtils::isNotVoid).forEach(x -> ((BeanStore.Builder)v.get()).type(x));
            ((BeanStore.Builder)v.get()).build().createMethodFinder(BeanStore.class).find(Builder::isRestBeanMethod).run(x -> ((BeanStore.Builder)v.get()).impl(x));
            return (BeanStore.Builder)v.get();
        }

        protected BeanCreator<CallLogger> createCallLogger(BeanStore beanStore, Supplier<?> resource) {
            BeanCreator creator = beanStore.createBean(CallLogger.class).type(BasicCallLogger.class);
            this.defaultClasses().get(CallLogger.class).ifPresent(x -> creator.type(x));
            beanStore.getBean(CallLogger.class).ifPresent(x -> creator.impl(x));
            beanStore.createMethodFinder(CallLogger.class).find(Builder::isRestBeanMethod).run(x -> creator.impl(x));
            return creator;
        }

        protected Config createConfig(BeanStore beanStore, Supplier<?> resource, Class<?> resourceClass) {
            Value v = Value.empty();
            VarResolver vr = (VarResolver)beanStore.getBean(VarResolver.class).orElseThrow(() -> new IllegalArgumentException("VarResolver not found."));
            Value cfv = Value.empty();
            CollectionUtils.rstream((List)AP.find(Rest.class, (ClassInfo)ReflectionUtils.info(resourceClass), new AnnotationTraversal[0])).map(x -> ((Rest)x.inner()).config()).filter(Utils::ne).forEach(x -> cfv.set((Object)vr.resolve(x)));
            String cf = (String)cfv.orElse((Object)"");
            if (v.isEmpty() && "SYSTEM_DEFAULT".equals(cf)) {
                v.set((Object)Config.getSystemDefault());
            }
            if (v.isEmpty()) {
                Config.Builder cb = Config.create().varResolver(vr);
                if (!cf.isEmpty()) {
                    cb.name(cf);
                }
                v.set((Object)cb.build());
            }
            beanStore.getBean(Config.class).ifPresent(x -> v.set(x));
            beanStore.createMethodFinder(Config.class).addBean(Config.class, (Object)((Config)v.get())).find(Builder::isRestBeanMethod).run(x -> v.set(x));
            return (Config)v.get();
        }

        protected BeanCreator<DebugEnablement> createDebugEnablement(BeanStore beanStore, Supplier<?> resource) {
            BeanCreator creator = beanStore.createBean(DebugEnablement.class).type(BasicDebugEnablement.class);
            this.defaultClasses().get(DebugEnablement.class).ifPresent(x -> creator.type(x));
            beanStore.getBean(DebugEnablement.class).ifPresent(x -> creator.impl(x));
            beanStore.createMethodFinder(DebugEnablement.class).find(Builder::isRestBeanMethod).run(x -> creator.impl(x));
            return creator;
        }

        protected NamedAttributeMap createDefaultRequestAttributes(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)NamedAttributeMap.create());
            beanStore.getBean(NamedAttributeMap.class, "defaultRequestAttributes").ifPresent(x -> v.set(x));
            beanStore.createMethodFinder(NamedAttributeMap.class).addBean(NamedAttributeMap.class, (Object)((NamedAttributeMap)v.get())).find(x -> Builder.isRestBeanMethod(x, "defaultRequestAttributes")).run(x -> v.set(x));
            return (NamedAttributeMap)v.get();
        }

        protected HeaderList createDefaultRequestHeaders(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)HeaderList.create());
            beanStore.getBean(HeaderList.class, "defaultRequestHeaders").ifPresent(x -> v.set(x));
            beanStore.createMethodFinder(HeaderList.class).addBean(HeaderList.class, (Object)((HeaderList)v.get())).find(x -> Builder.isRestBeanMethod(x, "defaultRequestHeaders")).run(x -> v.set(x));
            return (HeaderList)v.get();
        }

        protected HeaderList createDefaultResponseHeaders(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)HeaderList.create());
            beanStore.getBean(HeaderList.class, "defaultResponseHeaders").ifPresent(x -> v.set(x));
            beanStore.createMethodFinder(HeaderList.class).addBean(HeaderList.class, (Object)((HeaderList)v.get())).find(x -> Builder.isRestBeanMethod(x, "defaultResponseHeaders")).run(x -> v.set(x));
            return (HeaderList)v.get();
        }

        protected MethodList createDestroyMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getAnnotatedMethods(resource, RestDestroy.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, (Object)((MethodList)v.get())).find(x -> Builder.isRestBeanMethod(x, "destroyMethods")).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        protected EncoderSet.Builder createEncoders(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)EncoderSet.create((BeanStore)beanStore).add(new Encoder[]{IdentityEncoder.INSTANCE}));
            this.defaultClasses().get(EncoderSet.class).ifPresent(x -> ((EncoderSet.Builder)v.get()).type(x));
            beanStore.getBean(EncoderSet.class).ifPresent(x -> ((EncoderSet.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(EncoderSet.class).addBean(EncoderSet.Builder.class, (Object)((EncoderSet.Builder)v.get())).find(Builder::isRestBeanMethod).run(x -> ((EncoderSet.Builder)v.get()).impl(x));
            return (EncoderSet.Builder)v.get();
        }

        protected MethodList createEndCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getAnnotatedMethods(resource, RestEndCall.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, (Object)((MethodList)v.get())).find(x -> Builder.isRestBeanMethod(x, "endCallMethods")).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        protected JsonSchemaGenerator.Builder createJsonSchemaGenerator(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)JsonSchemaGenerator.create());
            beanStore.getBean(JsonSchemaGenerator.Builder.class).map(JsonSchemaGenerator.Builder::copy).ifPresent(x -> v.set(x));
            beanStore.getBean(JsonSchemaGenerator.class).ifPresent(x -> ((JsonSchemaGenerator.Builder)v.get()).impl((Context)x));
            beanStore.createMethodFinder(JsonSchemaGenerator.class).addBean(JsonSchemaGenerator.Builder.class, (Object)((JsonSchemaGenerator.Builder)v.get())).find(Builder::isRestBeanMethod).run(x -> ((JsonSchemaGenerator.Builder)v.get()).impl((Context)x));
            return (JsonSchemaGenerator.Builder)v.get();
        }

        protected Logger createLogger(BeanStore beanStore, Supplier<?> resource, Class<?> resourceClass) {
            Value v = Value.of((Object)Logger.getLogger(Utils.cn(resourceClass)));
            beanStore.getBean(Logger.class).ifPresent(x -> v.set(x));
            beanStore.createMethodFinder(Logger.class).addBean(Logger.class, (Object)((Logger)v.get())).find(Builder::isRestBeanMethod).run(x -> v.set(x));
            return (Logger)v.get();
        }

        protected Messages.Builder createMessages(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Messages.create(this.resourceClass));
            beanStore.getBean(Messages.class).ifPresent(x -> ((Messages.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(Messages.class).addBean(Messages.Builder.class, (Object)((Messages.Builder)v.get())).find(Builder::isRestBeanMethod).run(x -> ((Messages.Builder)v.get()).impl(x));
            return (Messages.Builder)v.get();
        }

        protected MethodExecStore.Builder createMethodExecStore(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)MethodExecStore.create(beanStore)));
            this.defaultClasses().get(MethodExecStore.class).ifPresent(x -> ((MethodExecStore.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.getBean(MethodExecStore.class).ifPresent(x -> ((MethodExecStore.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(MethodExecStore.class).addBean(MethodExecStore.Builder.class, (Object)((MethodExecStore.Builder)((Object)v.get()))).find(Builder::isRestBeanMethod).run(x -> ((MethodExecStore.Builder)((Object)((Object)v.get()))).impl(x));
            return (MethodExecStore.Builder)((Object)v.get());
        }

        protected ParserSet.Builder createParsers(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)ParserSet.create((BeanStore)beanStore));
            this.defaultClasses().get(ParserSet.class).ifPresent(x -> ((ParserSet.Builder)v.get()).type(x));
            beanStore.getBean(ParserSet.class).ifPresent(x -> ((ParserSet.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(ParserSet.class).addBean(ParserSet.Builder.class, (Object)((ParserSet.Builder)v.get())).find(Builder::isRestBeanMethod).run(x -> ((ParserSet.Builder)v.get()).impl(x));
            return (ParserSet.Builder)v.get();
        }

        protected HttpPartParser.Creator createPartParser(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)HttpPartParser.creator().type(OpenApiParser.class));
            beanStore.getBean(HttpPartParser.Creator.class).map(HttpPartParser.Creator::copy).ifPresent(x -> v.set(x));
            beanStore.getBean(HttpPartParser.class).ifPresent(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            this.resourceAs(HttpPartParser.class).ifPresent(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            this.defaultClasses().get(HttpPartParser.class).ifPresent(x -> ((HttpPartParser.Creator)v.get()).type(x));
            beanStore.createMethodFinder(HttpPartParser.class).addBean(HttpPartParser.Creator.class, (Object)((HttpPartParser.Creator)v.get())).find(Builder::isRestBeanMethod).run(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            return (HttpPartParser.Creator)v.get();
        }

        protected HttpPartSerializer.Creator createPartSerializer(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)HttpPartSerializer.creator().type(OpenApiSerializer.class));
            beanStore.getBean(HttpPartSerializer.Creator.class).map(HttpPartSerializer.Creator::copy).ifPresent(x -> v.set(x));
            beanStore.getBean(HttpPartSerializer.class).ifPresent(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            this.resourceAs(HttpPartSerializer.class).ifPresent(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            this.defaultClasses().get(HttpPartSerializer.class).ifPresent(x -> ((HttpPartSerializer.Creator)v.get()).type(x));
            beanStore.createMethodFinder(HttpPartSerializer.class).addBean(HttpPartSerializer.Creator.class, (Object)((HttpPartSerializer.Creator)v.get())).find(Builder::isRestBeanMethod).run(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            return (HttpPartSerializer.Creator)v.get();
        }

        protected MethodList createPostCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getAnnotatedMethods(resource, RestPostCall.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, (Object)((MethodList)v.get())).find(x -> Builder.isRestBeanMethod(x, "postCallMethods")).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        protected MethodList createPostInitChildFirstMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getAnnotatedMethods(resource, RestPostInit.class, RestPostInit::childFirst));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, (Object)((MethodList)v.get())).find(x -> Builder.isRestBeanMethod(x, "postInitChildFirstMethods")).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        protected MethodList createPostInitMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getAnnotatedMethods(resource, RestPostInit.class, x -> !x.childFirst()));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, (Object)((MethodList)v.get())).find(x -> Builder.isRestBeanMethod(x, "postInitMethods")).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        protected MethodList createPreCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getAnnotatedMethods(resource, RestPreCall.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, (Object)((MethodList)v.get())).find(x -> Builder.isRestBeanMethod(x, "preCallMethods")).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        protected ResponseProcessorList.Builder createResponseProcessors(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)ResponseProcessorList.create(beanStore).add(ReaderProcessor.class, InputStreamProcessor.class, ThrowableProcessor.class, HttpResponseProcessor.class, HttpResourceProcessor.class, HttpEntityProcessor.class, ResponseBeanProcessor.class, PlainTextPojoProcessor.class, SerializedPojoProcessor.class)));
            beanStore.getBean(ResponseProcessorList.class).ifPresent(x -> ((ResponseProcessorList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(ResponseProcessorList.class).addBean(ResponseProcessorList.Builder.class, (Object)((ResponseProcessorList.Builder)((Object)v.get()))).find(Builder::isRestBeanMethod).run(x -> ((ResponseProcessorList.Builder)((Object)((Object)v.get()))).impl(x));
            return (ResponseProcessorList.Builder)((Object)v.get());
        }

        protected RestChildren.Builder createRestChildren(BeanStore beanStore, Supplier<?> resource, RestContext restContext) throws Exception {
            Value v = Value.of((Object)RestChildren.create(beanStore).type((Class)this.childrenClass));
            for (Object o : this.children) {
                Supplier<Object> so;
                String path = null;
                if (o instanceof RestChild) {
                    RestChild o2 = (RestChild)o;
                    path = o2.path;
                    Object o3 = o2.resource;
                    Supplier<Object> supplier = () -> o3;
                }
                Builder cb = null;
                if (o instanceof Class) {
                    Class oc = (Class)o;
                    if (oc == this.resourceClass) continue;
                    cb = RestContext.create(oc, restContext, this.inner);
                    if (beanStore.getBean(oc).isPresent()) {
                        so = () -> beanStore.getBean(oc).get();
                    } else {
                        Object o2 = beanStore.createBean(oc).builder(Builder.class, (Object)cb).run();
                        so = () -> o2;
                    }
                } else {
                    cb = RestContext.create(o.getClass(), restContext, this.inner);
                    so = () -> o;
                }
                if (Utils.nn((Object)path)) {
                    cb.path(path);
                }
                RestContext cc = cb.init(so).build();
                MethodInfo mi = ClassInfo.of((Object)so.get()).getMethod(x -> x.hasName("setContext") && x.hasParameterTypes(new Class[]{RestContext.class})).orElse(null);
                if (Utils.nn((Object)mi)) {
                    mi.accessible().invoke(so.get(), new Object[]{cc});
                }
                ((RestChildren.Builder)((Object)v.get())).add(cc);
            }
            beanStore.createMethodFinder(RestChildren.class).addBean(RestChildren.Builder.class, (Object)((RestChildren.Builder)((Object)v.get()))).find(Builder::isRestBeanMethod).run(x -> ((RestChildren.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestChildren.Builder)((Object)v.get());
        }

        protected RestOpArgList.Builder createRestOpArgs(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)RestOpArgList.create(beanStore).add(AttributeArg.class, ContentArg.class, FormDataArg.class, HasFormDataArg.class, HasQueryArg.class, HeaderArg.class, HttpServletRequestArgs.class, HttpServletResponseArgs.class, HttpSessionArgs.class, InputStreamParserArg.class, MethodArg.class, ParserArg.class, PathArg.class, PathRemainderArg.class, QueryArg.class, ReaderParserArg.class, RequestBeanArg.class, ResponseBeanArg.class, ResponseHeaderArg.class, ResponseCodeArg.class, RestContextArgs.class, RestSessionArgs.class, RestOpContextArgs.class, RestOpSessionArgs.class, RestRequestArgs.class, RestResponseArgs.class, DefaultArg.class)));
            beanStore.getBean(RestOpArgList.class).ifPresent(x -> ((RestOpArgList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(RestOpArgList.class).addBean(RestOpArgList.Builder.class, (Object)((RestOpArgList.Builder)((Object)v.get()))).find(Builder::isRestBeanMethod).run(x -> ((RestOpArgList.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestOpArgList.Builder)((Object)v.get());
        }

        protected RestOperations.Builder createRestOperations(BeanStore beanStore, Supplier<?> resource, RestContext restContext) throws ServletException {
            Value v = Value.of((Object)((Object)RestOperations.create(beanStore)));
            AnnotationProvider ap = restContext.getBeanContext().getAnnotationProvider();
            ClassInfo rci = ClassInfo.of(resource.get());
            LinkedHashMap initMap = CollectionUtils.map();
            ClassInfo.ofProxy(resource.get()).getAllMethodsTopDown().stream().filter(y -> y.hasAnnotation(RestInit.class) && y.hasParameter(RestOpContext.Builder.class)).forEach(y -> {
                String sig = y.getSignature();
                if (!initMap.containsKey(sig)) {
                    initMap.put(sig, y.accessible());
                }
            });
            for (MethodInfo mi : rci.getPublicMethods()) {
                List al = CollectionUtils.rstream((List)ap.find(mi, new AnnotationTraversal[0])).filter(RestOpAnnotation.REST_OP_GROUP).collect(Collectors.toList());
                if (al.isEmpty()) {
                    Predicate<MethodInfo> isRestAnnotatedInterface = x -> x.getDeclaringClass().isInterface() && Utils.nn(x.getDeclaringClass().getAnnotations(Rest.class).findFirst().map(AnnotationInfo::inner).orElse(null));
                    mi.getMatchingMethods().stream().filter(isRestAnnotatedInterface).forEach(x -> al.add(AnnotationInfo.of((Annotatable)x, (Annotation)RestOpAnnotation.DEFAULT)));
                }
                if (al.size() <= 0) continue;
                try {
                    if (mi.isNotPublic()) {
                        throw RestContext.servletException("@RestOp method {0}.{1} must be defined as public.", rci.inner().getName(), mi.getSimpleName());
                    }
                    Context.Builder rocb = RestOpContext.create(mi.inner(), restContext).beanStore(beanStore).type(this.opContextClass);
                    beanStore = BeanStore.of((BeanStore)beanStore, resource.get()).addBean(RestOpContext.Builder.class, (Object)rocb);
                    for (MethodInfo m : initMap.values()) {
                        if (!beanStore.hasAllParams((ExecutableInfo)m)) {
                            throw RestContext.servletException("Could not call @RestInit method {0}.{1}.  Could not find prerequisites: {2}.", Utils.cns((Object)m.getDeclaringClass()), m.getSignature(), beanStore.getMissingParams((ExecutableInfo)m));
                        }
                        try {
                            m.invoke(resource.get(), beanStore.getParams((ExecutableInfo)m));
                        }
                        catch (Exception e) {
                            throw RestContext.servletException(e, "Exception thrown from @RestInit method {0}.{1}.", Utils.cns((Object)m.getDeclaringClass()), m.getSignature());
                        }
                    }
                    RestOpContext roc = rocb.build();
                    String httpMethod = roc.getHttpMethod();
                    if ("RRPC".equals(httpMethod)) {
                        RestOpContext roc2 = RestOpContext.create(mi.inner(), restContext).dotAll().beanStore(restContext.getRootBeanStore()).type(RrpcRestOpContext.class).build();
                        ((RestOperations.Builder)((Object)v.get())).add("GET", roc2).add("POST", roc2);
                        continue;
                    }
                    ((RestOperations.Builder)((Object)v.get())).add(roc);
                }
                catch (Throwable e) {
                    throw RestContext.servletException(e, "Problem occurred trying to initialize methods on class {0}", rci.inner().getName());
                }
            }
            beanStore.createMethodFinder(RestOperations.class).addBean(RestOperations.Builder.class, (Object)((RestOperations.Builder)((Object)v.get()))).find(Builder::isRestBeanMethod).run(x -> ((RestOperations.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestOperations.Builder)((Object)v.get());
        }

        protected SerializerSet.Builder createSerializers(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)SerializerSet.create((BeanStore)beanStore));
            this.defaultClasses().get(SerializerSet.class).ifPresent(x -> ((SerializerSet.Builder)v.get()).type(x));
            beanStore.getBean(SerializerSet.class).ifPresent(x -> ((SerializerSet.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(SerializerSet.class).addBean(SerializerSet.Builder.class, (Object)((SerializerSet.Builder)v.get())).find(Builder::isRestBeanMethod).run(x -> ((SerializerSet.Builder)v.get()).impl(x));
            return (SerializerSet.Builder)v.get();
        }

        protected MethodList createStartCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)Builder.getAnnotatedMethods(resource, RestStartCall.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, (Object)((MethodList)v.get())).find(x -> Builder.isRestBeanMethod(x, "startCallMethods")).run(x -> v.set(x));
            return (MethodList)v.get();
        }

        protected BeanCreator<StaticFiles> createStaticFiles(BeanStore beanStore, Supplier<?> resource) {
            BeanCreator creator = beanStore.createBean(StaticFiles.class).type(BasicStaticFiles.class);
            this.defaultClasses().get(StaticFiles.class).ifPresent(x -> creator.type(x));
            beanStore.getBean(StaticFiles.class).ifPresent(x -> creator.impl(x));
            beanStore.createMethodFinder(StaticFiles.class).find(Builder::isRestBeanMethod).run(x -> creator.impl(x));
            return creator;
        }

        protected BeanCreator<SwaggerProvider> createSwaggerProvider(BeanStore beanStore, Supplier<?> resource) {
            BeanCreator creator = beanStore.createBean(SwaggerProvider.class).type(BasicSwaggerProvider.class);
            this.defaultClasses().get(SwaggerProvider.class).ifPresent(x -> creator.type(x));
            beanStore.getBean(SwaggerProvider.class).ifPresent(x -> creator.impl(x));
            beanStore.createMethodFinder(SwaggerProvider.class).find(Builder::isRestBeanMethod).run(x -> creator.impl(x));
            return creator;
        }

        protected ThrownStore.Builder createThrownStore(BeanStore beanStore, Supplier<?> resource, RestContext parent) {
            Value v = Value.of((Object)((Object)ThrownStore.create(beanStore).impl(parent == null ? null : parent.getThrownStore())));
            this.defaultClasses().get(ThrownStore.class).ifPresent(x -> ((ThrownStore.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.getBean(ThrownStore.class).ifPresent(x -> ((ThrownStore.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(ThrownStore.class).addBean(ThrownStore.Builder.class, (Object)((ThrownStore.Builder)((Object)v.get()))).find(Builder::isRestBeanMethod).run(x -> ((ThrownStore.Builder)((Object)((Object)v.get()))).impl(x));
            return (ThrownStore.Builder)((Object)v.get());
        }

        protected VarResolver.Builder createVarResolver(BeanStore beanStore, Supplier<?> resource, Class<?> resourceClass) {
            Value v = Value.of((Object)VarResolver.create().defaultVars().vars(VarList.of((Class[])new Class[]{ConfigVar.class, FileVar.class, LocalizationVar.class, RequestAttributeVar.class, RequestFormDataVar.class, RequestHeaderVar.class, RequestPathVar.class, RequestQueryVar.class, RequestVar.class, RequestSwaggerVar.class, SerializedRequestAttrVar.class, ServletInitParamVar.class, SwaggerVar.class, UrlVar.class, UrlEncodeVar.class, HtmlWidgetVar.class}).addDefault()).bean(FileFinder.class, (Object)((FileFinder)FileFinder.create((BeanStore)beanStore).cp(resourceClass, null, true).build())));
            beanStore.getBean(VarResolver.class).ifPresent(x -> ((VarResolver.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(VarResolver.class).addBean(VarResolver.Builder.class, (Object)((VarResolver.Builder)v.get())).find(Builder::isRestBeanMethod).run(x -> ((VarResolver.Builder)v.get()).impl(x));
            return (VarResolver.Builder)v.get();
        }
    }
}

