/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.html5;

import java.util.Map;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

@Html(format=HtmlFormat.XML)
public abstract class HtmlElement {
    private Map<String, Object> attrs;

    public HtmlElement _class(String value) {
        this.attr("class", value);
        return this;
    }

    public HtmlElement accesskey(String value) {
        this.attr("accesskey", value);
        return this;
    }

    public HtmlElement attr(String key, Object val) {
        if (this.attrs == null) {
            this.attrs = CollectionUtils.map();
        }
        if (val == null) {
            this.attrs.remove(key);
        } else {
            if ("url".equals(key) || "href".equals(key) || key.endsWith("action")) {
                val = StringUtils.toUri(val);
            }
            this.attrs.put(key, val);
        }
        return this;
    }

    public HtmlElement attrUri(String key, Object val) {
        if (this.attrs == null) {
            this.attrs = CollectionUtils.map();
        }
        this.attrs.put(key, StringUtils.toUri(val));
        return this;
    }

    public HtmlElement contenteditable(Object value) {
        this.attr("contenteditable", value);
        return this;
    }

    public HtmlElement dir(String value) {
        this.attr("dir", value);
        return this;
    }

    public <T> T getAttr(Class<T> type, String key) {
        return this.attrs == null ? null : (T)ConverterUtils.toType(this.attrs.get(key), type);
    }

    public String getAttr(String key) {
        return this.getAttr(String.class, key);
    }

    @Xml(format=XmlFormat.ATTRS)
    @Beanp(value="a")
    public Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public HtmlElement hidden(Object value) {
        this.attr("hidden", this.deminimize(value, "hidden"));
        return this;
    }

    public HtmlElement id(String value) {
        this.attr("id", value);
        return this;
    }

    public HtmlElement lang(String value) {
        this.attr("lang", value);
        return this;
    }

    public HtmlElement onabort(String value) {
        this.attr("onabort", value);
        return this;
    }

    public HtmlElement onblur(String value) {
        this.attr("onblur", value);
        return this;
    }

    public HtmlElement oncancel(String value) {
        this.attr("oncancel", value);
        return this;
    }

    public HtmlElement oncanplay(String value) {
        this.attr("oncanplay", value);
        return this;
    }

    public HtmlElement oncanplaythrough(String value) {
        this.attr("oncanplaythrough", value);
        return this;
    }

    public HtmlElement onchange(String value) {
        this.attr("onchange", value);
        return this;
    }

    public HtmlElement onclick(String value) {
        this.attr("onclick", value);
        return this;
    }

    public HtmlElement oncuechange(String value) {
        this.attr("oncuechange", value);
        return this;
    }

    public HtmlElement ondblclick(String value) {
        this.attr("ondblclick", value);
        return this;
    }

    public HtmlElement ondurationchange(String value) {
        this.attr("ondurationchange", value);
        return this;
    }

    public HtmlElement onemptied(String value) {
        this.attr("onemptied", value);
        return this;
    }

    public HtmlElement onended(String value) {
        this.attr("onended", value);
        return this;
    }

    public HtmlElement onerror(String value) {
        this.attr("onerror", value);
        return this;
    }

    public HtmlElement onfocus(String value) {
        this.attr("onfocus", value);
        return this;
    }

    public HtmlElement oninput(String value) {
        this.attr("oninput", value);
        return this;
    }

    public HtmlElement oninvalid(String value) {
        this.attr("oninvalid", value);
        return this;
    }

    public HtmlElement onkeydown(String value) {
        this.attr("onkeydown", value);
        return this;
    }

    public HtmlElement onkeypress(String value) {
        this.attr("onkeypress", value);
        return this;
    }

    public HtmlElement onkeyup(String value) {
        this.attr("onkeyup", value);
        return this;
    }

    public HtmlElement onload(String value) {
        this.attr("onload", value);
        return this;
    }

    public HtmlElement onloadeddata(String value) {
        this.attr("onloadeddata", value);
        return this;
    }

    public HtmlElement onloadedmetadata(String value) {
        this.attr("onloadedmetadata", value);
        return this;
    }

    public HtmlElement onloadstart(String value) {
        this.attr("onloadstart", value);
        return this;
    }

    public HtmlElement onmousedown(String value) {
        this.attr("onmousedown", value);
        return this;
    }

    public HtmlElement onmouseenter(String value) {
        this.attr("onmouseenter", value);
        return this;
    }

    public HtmlElement onmouseleave(String value) {
        this.attr("onmouseleave", value);
        return this;
    }

    public HtmlElement onmousemove(String value) {
        this.attr("onmousemove", value);
        return this;
    }

    public HtmlElement onmouseout(String value) {
        this.attr("onmouseout", value);
        return this;
    }

    public HtmlElement onmouseover(String value) {
        this.attr("onmouseover", value);
        return this;
    }

    public HtmlElement onmouseup(String value) {
        this.attr("onmouseup", value);
        return this;
    }

    public HtmlElement onmousewheel(String value) {
        this.attr("onmousewheel", value);
        return this;
    }

    public HtmlElement onpause(String value) {
        this.attr("onpause", value);
        return this;
    }

    public HtmlElement onplay(String value) {
        this.attr("onplay", value);
        return this;
    }

    public HtmlElement onplaying(String value) {
        this.attr("onplaying", value);
        return this;
    }

    public HtmlElement onprogress(String value) {
        this.attr("onprogress", value);
        return this;
    }

    public HtmlElement onratechange(String value) {
        this.attr("onratechange", value);
        return this;
    }

    public HtmlElement onreset(String value) {
        this.attr("onreset", value);
        return this;
    }

    public HtmlElement onresize(String value) {
        this.attr("onresize", value);
        return this;
    }

    public HtmlElement onscroll(String value) {
        this.attr("onscroll", value);
        return this;
    }

    public HtmlElement onseeked(String value) {
        this.attr("onseeked", value);
        return this;
    }

    public HtmlElement onseeking(String value) {
        this.attr("onseeking", value);
        return this;
    }

    public HtmlElement onselect(String value) {
        this.attr("onselect", value);
        return this;
    }

    public HtmlElement onshow(String value) {
        this.attr("onshow", value);
        return this;
    }

    public HtmlElement onstalled(String value) {
        this.attr("onstalled", value);
        return this;
    }

    public HtmlElement onsubmit(String value) {
        this.attr("onsubmit", value);
        return this;
    }

    public HtmlElement onsuspend(String value) {
        this.attr("onsuspend", value);
        return this;
    }

    public HtmlElement ontimeupdate(String value) {
        this.attr("ontimeupdate", value);
        return this;
    }

    public HtmlElement ontoggle(String value) {
        this.attr("ontoggle", value);
        return this;
    }

    public HtmlElement onvolumechange(String value) {
        this.attr("onvolumechange", value);
        return this;
    }

    public HtmlElement onwaiting(String value) {
        this.attr("onwaiting", value);
        return this;
    }

    @Beanp(value="a")
    public HtmlElement setAttrs(Map<String, Object> value) {
        if (Utils.nn(value)) {
            value.entrySet().forEach(x -> {
                String key = (String)x.getKey();
                if ("url".equals(key) || "href".equals(key) || key.endsWith("action")) {
                    x.setValue(StringUtils.toUri(x.getValue()));
                }
            });
        }
        this.attrs = value;
        return this;
    }

    public HtmlElement spellcheck(Object value) {
        this.attr("spellcheck", value);
        return this;
    }

    public HtmlElement style(String value) {
        this.attr("style", value);
        return this;
    }

    public HtmlElement tabindex(Object value) {
        this.attr("tabindex", value);
        return this;
    }

    public HtmlElement title(String value) {
        this.attr("title", value);
        return this;
    }

    public String toString() {
        return HtmlSerializer.DEFAULT_SIMPLE_SQ.toString(this);
    }

    public HtmlElement translate(Object value) {
        this.attr("translate", value);
        return this;
    }

    protected Object deminimize(Object value, String attr) {
        if (value instanceof Boolean) {
            Boolean value2 = (Boolean)value;
            if (Boolean.TRUE.equals(value2)) {
                return attr;
            }
            return null;
        }
        return value;
    }
}

