/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class CharValue
extends Value<Character> {
    public static CharValue create() {
        return CharValue.of(Character.valueOf('\u0000'));
    }

    public static CharValue of(Character value) {
        return new CharValue(value);
    }

    public CharValue(Character value) {
        super(value);
    }

    public CharValue add(Character x) {
        Character v = (Character)this.get();
        this.set(Character.valueOf((char)((v == null ? (char)'\u0000' : v.charValue()) + (x == null ? (char)'\u0000' : x.charValue()))));
        return this;
    }

    public Character addAndGet(Character x) {
        Character v = (Character)this.get();
        char result = (char)((v == null ? (char)'\u0000' : v.charValue()) + (x == null ? (char)'\u0000' : x.charValue()));
        this.set(Character.valueOf(result));
        return Character.valueOf(result);
    }

    public CharValue decrement() {
        Character v = (Character)this.get();
        this.set(Character.valueOf((char)((v == null ? (char)'\u0000' : v.charValue()) - '\u0001')));
        return this;
    }

    public Character decrementAndGet() {
        Character v = (Character)this.get();
        char result = (char)((v == null ? (char)'\u0000' : v.charValue()) - '\u0001');
        this.set(Character.valueOf(result));
        return Character.valueOf(result);
    }

    public CharValue increment() {
        Character v = (Character)this.get();
        this.set(Character.valueOf((char)((v == null ? (char)'\u0000' : v.charValue()) + '\u0001')));
        return this;
    }

    public Character incrementAndGet() {
        Character v = (Character)this.get();
        char result = (char)((v == null ? (char)'\u0000' : v.charValue()) + '\u0001');
        this.set(Character.valueOf(result));
        return Character.valueOf(result);
    }

    @Override
    public boolean is(Character value) {
        return Utils.eq((Character)this.get(), value);
    }

    public boolean isAny(Character ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        Character current = (Character)this.get();
        for (Character value : values) {
            if (!Utils.eq(current, value)) continue;
            return true;
        }
        return false;
    }

    public boolean isAny(String values) {
        if (values == null || values.isEmpty()) {
            return false;
        }
        Character current = (Character)this.get();
        if (current == null) {
            return false;
        }
        return values.indexOf(current.charValue()) >= 0;
    }
}

