/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.http.StatusLine;
import org.apache.juneau.ContextSession;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.MethodNotAllowed;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.logger.CallLogger;
import org.apache.juneau.rest.util.CachingHttpServletRequest;
import org.apache.juneau.rest.util.CachingHttpServletResponse;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPath;
import org.apache.juneau.rest.util.UrlPathMatch;

public class RestSession
extends ContextSession {
    private static final String REST_PATHVARS_ATTR = "juneau.pathVars";
    private final long startTime = System.currentTimeMillis();
    private final BeanStore beanStore;
    private CallLogger logger;
    private HttpServletRequest req;
    private HttpServletResponse res;
    private Map<String, String[]> queryParams;
    private final Object resource;
    private final RestContext context;
    private RestOpSession opSession;
    private String method;
    private String pathInfoUndecoded;
    private UrlPath urlPath;
    private UrlPathMatch urlPathMatch;
    private static AsciiSet VALID_METHOD_CHARS = AsciiSet.create().ranges("A-Z", "a-z", "0-9").chars("_-").build();

    public static Builder create(RestContext ctx) {
        return new Builder(AssertionUtils.assertArgNotNull("ctx", ctx));
    }

    public RestSession(Builder builder) {
        super(builder);
        this.context = builder.ctx;
        this.resource = builder.resource;
        this.beanStore = BeanStore.of(this.context.getBeanStore(), this.resource).addBean(RestContext.class, this.context);
        this.logger = this.beanStore.add(CallLogger.class, builder.logger);
        this.pathInfoUndecoded = builder.pathInfoUndecoded;
        this.req = this.beanStore.add(HttpServletRequest.class, builder.req);
        this.res = this.beanStore.add(HttpServletResponse.class, builder.res);
        this.urlPath = this.beanStore.add(UrlPath.class, builder.urlPath);
    }

    public RestSession debug(boolean value) throws IOException {
        if (value) {
            this.req = CachingHttpServletRequest.wrap(this.req);
            this.res = CachingHttpServletResponse.wrap(this.res);
            this.req.setAttribute("Debug", (Object)true);
        } else {
            this.req.removeAttribute("Debug");
        }
        return this;
    }

    public RestSession exception(Throwable value) {
        this.req.setAttribute("Exception", (Object)value);
        this.beanStore.addBean(Throwable.class, value);
        return this;
    }

    public RestSession finish() {
        try {
            this.req.setAttribute("ExecTime", (Object)(System.currentTimeMillis() - this.startTime));
            if (Utils.nn(this.opSession)) {
                this.opSession.finish();
            } else {
                this.res.flushBuffer();
            }
        }
        catch (Exception e) {
            this.exception(e);
        }
        if (Utils.nn(this.logger)) {
            this.logger.log(this.req, this.res);
        }
        return this;
    }

    public BeanStore getBeanStore() {
        return this.beanStore;
    }

    @Override
    public RestContext getContext() {
        return this.context;
    }

    public Throwable getException() {
        return (Throwable)this.req.getAttribute("Exception");
    }

    public String getMethod() throws NotFound {
        if (this.method == null) {
            Object x;
            Set<String> s1 = this.context.getAllowedMethodParams();
            Set<String> s2 = this.context.getAllowedMethodHeaders();
            if (!s1.isEmpty()) {
                x = this.getQueryParams().get("method");
                if (Utils.nn(x) && (s1.contains("*") || s1.contains(x[0]))) {
                    this.method = x[0];
                }
                if (this.method != null && !VALID_METHOD_CHARS.containsOnly(this.method)) {
                    throw new MethodNotAllowed();
                }
            }
            if (this.method == null && !s2.isEmpty()) {
                x = this.req.getHeader("X-Method");
                if (Utils.nn(x) && (s2.contains("*") || s2.contains(x))) {
                    this.method = x;
                }
                if (this.method != null && !VALID_METHOD_CHARS.containsOnly(this.method)) {
                    throw new MethodNotAllowed();
                }
            }
            if (this.method == null) {
                this.method = this.req.getMethod();
            }
            this.method = this.method.toUpperCase(Locale.ENGLISH);
        }
        return this.method;
    }

    public RestOpSession getOpSession() throws InternalServerError {
        if (this.opSession == null) {
            throw new InternalServerError("Op Session not created.", new Object[0]);
        }
        return this.opSession;
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathInfoUndecoded() {
        if (this.pathInfoUndecoded == null) {
            this.pathInfoUndecoded = RestUtils.getPathInfoUndecoded(this.req);
        }
        return this.pathInfoUndecoded;
    }

    public Map<String, String> getPathVars() {
        Map m = (Map)this.req.getAttribute(REST_PATHVARS_ATTR);
        return m == null ? CollectionUtils.mape() : m;
    }

    public Map<String, String[]> getQueryParams() {
        if (this.queryParams == null) {
            this.queryParams = this.req.getMethod().equalsIgnoreCase("POST") ? RestUtils.parseQuery(this.req.getQueryString(), CollectionUtils.map()) : this.req.getParameterMap();
        }
        return this.queryParams;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public Object getResource() {
        return this.resource;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public int getStatus() {
        return this.res.getStatus();
    }

    public UrlPath getUrlPath() {
        if (this.urlPath == null) {
            this.urlPath = UrlPath.of(this.getPathInfoUndecoded());
        }
        return this.urlPath;
    }

    public UrlPathMatch getUrlPathMatch() {
        return this.urlPathMatch;
    }

    public RestSession logger(CallLogger value) {
        this.logger = this.beanStore.add(CallLogger.class, value);
        return this;
    }

    public void run() throws Throwable {
        try {
            this.opSession = this.context.getRestOperations().findOperation(this).createSession(this).build();
            this.context.preCall(this.opSession);
            this.opSession.run();
            this.context.postCall(this.opSession);
            if (this.res.getStatus() == 0) {
                this.res.setStatus(200);
            }
            if (this.opSession.getResponse().hasContent()) {
                this.context.processResponse(this.opSession);
            }
        }
        catch (NotFound e) {
            if (this.getStatus() == 0) {
                this.status(404);
            }
            this.exception(e);
            this.context.handleNotFound(this);
        }
    }

    public RestSession status(int value) {
        this.res.setStatus(value);
        return this;
    }

    public RestSession status(StatusLine value) {
        if (Utils.nn(value)) {
            this.res.setStatus(value.getStatusCode());
        }
        return this;
    }

    public RestSession urlPathMatch(UrlPathMatch value) {
        this.urlPathMatch = this.beanStore.add(UrlPathMatch.class, value);
        return this;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a("context", this.context).a("resource", this.resource);
    }

    public static class Builder
    extends ContextSession.Builder {
        private CallLogger logger;
        private HttpServletRequest req;
        private HttpServletResponse res;
        private Object resource;
        private RestContext ctx;
        private String pathInfoUndecoded;
        private UrlPath urlPath;

        protected Builder(RestContext ctx) {
            super(AssertionUtils.assertArgNotNull("ctx", ctx));
            this.ctx = ctx;
        }

        @Override
        public RestSession build() {
            return new RestSession(this);
        }

        public String getPathInfoUndecoded() {
            if (this.pathInfoUndecoded == null) {
                this.pathInfoUndecoded = RestUtils.getPathInfoUndecoded(this.req);
            }
            return this.pathInfoUndecoded;
        }

        public UrlPath getUrlPath() {
            if (this.urlPath == null) {
                this.urlPath = UrlPath.of(this.getPathInfoUndecoded());
            }
            return this.urlPath;
        }

        public Builder logger(CallLogger value) {
            this.logger = value;
            return this;
        }

        public Builder pathVars(Map<String, String> value) {
            if (Utils.nn(value) && !value.isEmpty()) {
                TreeMap<String, String> m = (TreeMap<String, String>)this.req.getAttribute(RestSession.REST_PATHVARS_ATTR);
                if (m == null) {
                    m = new TreeMap<String, String>();
                    this.req.setAttribute(RestSession.REST_PATHVARS_ATTR, m);
                }
                m.putAll(value);
            }
            return this;
        }

        public HttpServletRequest req() {
            this.urlPath = null;
            this.pathInfoUndecoded = null;
            return this.req;
        }

        public Builder req(HttpServletRequest value) {
            this.req = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public HttpServletResponse res() {
            return this.res;
        }

        public Builder res(HttpServletResponse value) {
            this.res = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public Builder resource(Object value) {
            this.resource = value;
            return this;
        }
    }
}

