/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.Utils;

public class LocalFile {
    private final Class<?> clazz;
    private final String clazzPath;
    private final Path path;
    private final String name;
    private byte[] cache;

    public LocalFile(Class<?> clazz, String clazzPath) {
        this.clazz = AssertionUtils.assertArgNotNull("clazz", clazz);
        this.clazzPath = AssertionUtils.assertArgNotNull("clazzPath", clazzPath);
        this.path = null;
        int i = clazzPath.lastIndexOf(47);
        this.name = i == -1 ? clazzPath : clazzPath.substring(i + 1);
    }

    public LocalFile(Path path) {
        this.clazz = null;
        this.clazzPath = null;
        this.path = AssertionUtils.assertArgNotNull("path", path);
        Path fileName = path.getFileName();
        AssertionUtils.assertArg(fileName != null, "Argument 'path' must not be a root path (must have a filename).", new Object[0]);
        this.name = Utils.opt(fileName).map(Object::toString).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalFile cache() throws IOException {
        LocalFile localFile = this;
        synchronized (localFile) {
            this.cache = IoUtils.readBytes(this.read());
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream read() throws IOException {
        LocalFile localFile = this;
        synchronized (localFile) {
            if (Utils.nn(this.cache)) {
                return new ByteArrayInputStream(this.cache);
            }
        }
        if (Utils.nn(this.clazz)) {
            InputStream is = this.clazz.getResourceAsStream(this.clazzPath);
            if (is == null) {
                throw new IOException("Classpath resource not found: " + this.clazzPath + " (relative to " + Utils.cn(this.clazz) + ")");
            }
            return is;
        }
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public long size() throws IOException {
        return this.path == null ? -1L : Files.size(this.path);
    }
}

