/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.UnknownFormatConversionException;
import java.util.stream.Collectors;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.Cache2;
import org.apache.juneau.commons.collections.CacheMode;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public final class StringFormat {
    private static final CacheMode CACHE_MODE = CacheMode.parse(System.getProperty("juneau.StringFormat.caching", "FULL"));
    private static final Cache<String, StringFormat> CACHE = Cache.of(String.class, StringFormat.class).maxSize(1000).cacheMode(CACHE_MODE).build();
    private static final Cache2<Locale, String, MessageFormat> MESSAGE_FORMAT_CACHE = Cache2.of(Locale.class, String.class, MessageFormat.class).maxSize(100).threadLocal().cacheMode(CACHE_MODE).supplier((locale, content) -> new MessageFormat((String)content, (Locale)locale)).build();
    private static final Cache<Locale, NumberFormat> NUMBER_FORMAT_CACHE = Cache.of(Locale.class, NumberFormat.class).maxSize(50).threadLocal().cacheMode(CACHE_MODE).supplier(NumberFormat::getInstance).build();
    private static final Cache<Locale, DateFormat> DATE_FORMAT_CACHE = Cache.of(Locale.class, DateFormat.class).maxSize(50).threadLocal().cacheMode(CACHE_MODE).supplier(locale -> DateFormat.getDateTimeInstance(3, 3, locale)).build();
    private static final AsciiSet PRINTF_CONVERSION_CHARS = AsciiSet.of("bBhHsScCdoxXeEfgGaAtTn%");
    private static final AsciiSet PRINTF_FORMAT_CHARS = AsciiSet.of("-+ 0(#.*$");
    private final String pattern;
    private final Token[] tokens;

    public static String format(String pattern, Locale locale, Object ... args) {
        if (args.length == 0) {
            return pattern;
        }
        return StringFormat.of(pattern).format(locale, args);
    }

    public static String format(String pattern, Object ... args) {
        if (args.length == 0) {
            return pattern;
        }
        return StringFormat.of(pattern).format(args);
    }

    public static StringFormat of(String pattern) {
        AssertionUtils.assertArgNotNull("pattern", pattern);
        return CACHE.get(pattern, () -> new StringFormat(pattern));
    }

    private static void lit(List<Token> tokens, String pattern, int start) {
        if (start == pattern.length()) {
            return;
        }
        tokens.add(new LiteralToken(pattern.substring(start)));
    }

    private static void lit(List<Token> tokens, String pattern, int start, int end) {
        if (start == end) {
            return;
        }
        tokens.add(new LiteralToken(pattern.substring(start, end)));
    }

    private static void mf(List<Token> tokens, String pattern, int start, int end, int index) {
        tokens.add(new MessageFormatToken(pattern.substring(start, end), index));
    }

    private static int parseIndexMF(String s) {
        if (!s.matches("[0-9]+")) {
            throw new IllegalArgumentException("can't parse argument number: " + s);
        }
        return Integer.parseInt(s);
    }

    private static int parseIndexSF(String s) {
        return Integer.parseInt(s);
    }

    private static List<Token> parseTokens(String pattern) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int length = pattern.length();
        int i = 0;
        int sequentialIndex = 0;
        StateEnum state = StateEnum.S1;
        int nestedBracketDepth = 0;
        int mark = 0;
        while (i < length) {
            char ch = pattern.charAt(i++);
            if (state == StateEnum.S1) {
                if (ch == '%') {
                    StringFormat.lit(tokens, pattern, mark, i - 1);
                    state = StateEnum.S2;
                    mark = i;
                    continue;
                }
                if (ch == '{') {
                    StringFormat.lit(tokens, pattern, mark, i - 1);
                    state = StateEnum.S3;
                    mark = i - 1;
                    continue;
                }
                if (ch != '\'') continue;
                StringFormat.lit(tokens, pattern, mark, i - 1);
                state = StateEnum.S4;
                mark = i;
                continue;
            }
            if (state == StateEnum.S2) {
                if (ch == '%') {
                    tokens.add(new LiteralToken("%"));
                    state = StateEnum.S1;
                    mark = i;
                    continue;
                }
                if (ch == 'n') {
                    tokens.add(new LiteralToken(System.lineSeparator()));
                    state = StateEnum.S1;
                    mark = i;
                    continue;
                }
                if (ch == 't' || ch == 'T') continue;
                if (PRINTF_CONVERSION_CHARS.contains(ch)) {
                    StringFormat.sf(tokens, pattern, mark, i, sequentialIndex++);
                    state = StateEnum.S1;
                    mark = i;
                    continue;
                }
                if (PRINTF_FORMAT_CHARS.contains(ch) || Character.isDigit(ch)) continue;
                StringFormat.sf(tokens, pattern, mark, i, sequentialIndex++);
                state = StateEnum.S1;
                mark = i;
                continue;
            }
            if (state == StateEnum.S3) {
                if (ch == '{') {
                    ++nestedBracketDepth;
                    continue;
                }
                if (ch != '}') continue;
                if (nestedBracketDepth > 0) {
                    --nestedBracketDepth;
                    continue;
                }
                StringFormat.mf(tokens, pattern, mark + 1, i - 1, sequentialIndex++);
                state = StateEnum.S1;
                mark = i;
                continue;
            }
            if (ch != '\'') continue;
            if (mark == i - 1) {
                StringFormat.lit(tokens, pattern, mark, i);
                state = StateEnum.S1;
                mark = i;
                continue;
            }
            StringFormat.lit(tokens, pattern, mark, i - 1);
            state = StateEnum.S1;
            mark = i;
        }
        if (state == StateEnum.S1) {
            StringFormat.lit(tokens, pattern, mark);
        } else {
            if (state == StateEnum.S2) {
                throw new UnknownFormatConversionException("%");
            }
            if (state == StateEnum.S3) {
                throw new IllegalArgumentException("Unmatched braces in the pattern.");
            }
            StringFormat.lit(tokens, pattern, mark);
        }
        return tokens;
    }

    private static void sf(List<Token> tokens, String pattern, int start, int end, int index) {
        tokens.add(new StringFormatToken(pattern.substring(start, end), index));
    }

    private static String sf(Locale l, String s, Object o) {
        return String.format(l, s, CollectionUtils.a(o));
    }

    public StringFormat(String pattern) {
        this.pattern = AssertionUtils.assertArgNotNull("pattern", pattern);
        this.tokens = (Token[])StringFormat.parseTokens(pattern).toArray(Token[]::new);
    }

    public boolean equals(Object o) {
        StringFormat o2;
        return o instanceof StringFormat && Utils.eq(this, o2 = (StringFormat)o, (x, y) -> Utils.eq(x.pattern, y.pattern));
    }

    public String format(Locale locale, Object ... args) {
        StringBuilder sb = new StringBuilder(this.pattern.length() + 64);
        for (Token token : this.tokens) {
            token.append(sb, args, locale);
        }
        return sb.toString();
    }

    public String format(Object ... args) {
        return this.format(Locale.getDefault(), args);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toPattern() {
        return Arrays.stream(this.tokens).map(Object::toString).collect(Collectors.joining());
    }

    public String toString() {
        return this.pattern;
    }

    private static final class LiteralToken
    extends Token {
        private final String text;

        LiteralToken(String text) {
            this.text = text;
        }

        public String toString() {
            return "[L:" + this.text + "]";
        }

        @Override
        void append(StringBuilder sb, Object[] args, Locale locale) {
            sb.append(this.text);
        }
    }

    private static final class MessageFormatToken
    extends Token {
        private final char format;
        private final String content;
        private final int index;
        private final String placeholder;

        MessageFormatToken(String content, int index) {
            if (content.isBlank()) {
                this.content = null;
                this.index = index;
                this.format = (char)115;
                this.placeholder = "{" + index + "}";
            } else if (content.indexOf(44) == -1) {
                this.content = null;
                this.index = StringFormat.parseIndexMF(content);
                this.format = (char)115;
                this.placeholder = "{" + this.index + "}";
            } else {
                String[] tokens = content.split(",", 2);
                this.index = StringFormat.parseIndexMF(tokens[0]);
                this.content = "{0," + tokens[1] + "}";
                this.format = (char)111;
                this.placeholder = "{" + this.index + "," + tokens[1] + "}";
            }
        }

        public String toString() {
            return "[M:" + this.format + this.index + (String)(this.content == null ? "" : ":" + this.content) + "]";
        }

        @Override
        void append(StringBuilder sb, Object[] args, Locale locale) {
            if (args == null || this.index >= args.length || this.index < 0) {
                sb.append(this.placeholder);
                return;
            }
            Object o = args[this.index];
            Locale l = locale == null ? Locale.getDefault() : locale;
            switch (this.format) {
                case 's': {
                    if (o == null) {
                        sb.append("null");
                        break;
                    }
                    if (o instanceof Number) {
                        Number o2 = (Number)o;
                        sb.append(NUMBER_FORMAT_CACHE.get(l).format(o2));
                        break;
                    }
                    if (o instanceof Date) {
                        Date o2 = (Date)o;
                        sb.append(DATE_FORMAT_CACHE.get(l).format(o2));
                        break;
                    }
                    sb.append(o.toString());
                    break;
                }
                default: {
                    MessageFormat mf = MESSAGE_FORMAT_CACHE.get(l, this.content);
                    sb.append(mf.format(CollectionUtils.a(o)));
                }
            }
        }
    }

    private static final class StringFormatToken
    extends Token {
        private final char format;
        private final String content;
        private final int index;

        StringFormatToken(String content, int index) {
            int $ = content.indexOf(36);
            if ($ >= 0) {
                index = StringFormat.parseIndexSF(content.substring(0, $)) - 1;
                content = content.substring($ + 1);
            }
            this.format = (char)(content.length() == 1 ? (int)content.charAt(content.length() - 1) : 122);
            this.index = index;
            this.content = "%" + content;
        }

        public String toString() {
            return "[S:" + this.format + this.index + ":" + this.content + "]";
        }

        @Override
        void append(StringBuilder sb, Object[] args, Locale locale) {
            if (args == null || this.index >= args.length || this.index < 0) {
                throw new MissingFormatArgumentException(this.content);
            }
            Object o = args[this.index];
            Locale l = locale == null ? Locale.getDefault() : locale;
            boolean dl = locale == null || locale.equals(Locale.getDefault());
            switch (this.format) {
                case 'b': {
                    if (o == null) {
                        sb.append("false");
                    } else if (o instanceof Boolean) {
                        sb.append(o.toString());
                    } else {
                        sb.append("true");
                    }
                    return;
                }
                case 'B': {
                    if (o == null) {
                        sb.append("FALSE");
                    } else if (o instanceof Boolean) {
                        sb.append(o.toString().toUpperCase());
                    } else {
                        sb.append("TRUE");
                    }
                    return;
                }
                case 's': {
                    if (o == null) {
                        sb.append("null");
                        return;
                    }
                    sb.append(o.toString());
                    return;
                }
                case 'S': {
                    if (o == null) {
                        sb.append("NULL");
                        return;
                    }
                    sb.append(o.toString().toUpperCase());
                    return;
                }
                case 'd': {
                    if (o == null) {
                        sb.append("null");
                        return;
                    }
                    if (!(o instanceof Number)) break;
                    Number o2 = (Number)o;
                    if (dl) {
                        if (o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Short) {
                            sb.append(o);
                        } else {
                            sb.append(o2.longValue());
                        }
                        return;
                    }
                    sb.append(StringFormat.sf(l, "%d", o));
                    return;
                }
                case 'x': {
                    if (o == null) {
                        sb.append("null");
                        return;
                    }
                    if (o instanceof Integer) {
                        Integer o2 = (Integer)o;
                        sb.append(Integer.toHexString(o2));
                        return;
                    }
                    if (!(o instanceof Long)) break;
                    Long o2 = (Long)o;
                    sb.append(Long.toHexString(o2));
                    return;
                }
                case 'X': {
                    if (o == null) {
                        sb.append("NULL");
                        return;
                    }
                    if (o instanceof Integer) {
                        Integer o2 = (Integer)o;
                        sb.append(Integer.toHexString(o2).toUpperCase());
                        return;
                    }
                    if (!(o instanceof Long)) break;
                    Long o2 = (Long)o;
                    sb.append(Long.toHexString(o2).toUpperCase());
                    return;
                }
                case 'o': {
                    if (o == null) {
                        sb.append("null");
                        return;
                    }
                    if (o instanceof Integer) {
                        Integer o2 = (Integer)o;
                        sb.append(Integer.toOctalString(o2));
                        return;
                    }
                    if (!(o instanceof Long)) break;
                    Long o2 = (Long)o;
                    sb.append(Long.toOctalString(o2));
                    return;
                }
                case 'c': {
                    if (o == null) {
                        sb.append("null");
                        return;
                    }
                    if (o instanceof Character) {
                        sb.append(o);
                        return;
                    }
                    if (!(o instanceof Integer)) break;
                    Integer o2 = (Integer)o;
                    sb.append((char)o2.intValue());
                    return;
                }
                case 'C': {
                    if (o == null) {
                        sb.append("NULL");
                        return;
                    }
                    if (o instanceof Character) {
                        Character o2 = (Character)o;
                        sb.append(Character.toUpperCase(o2.charValue()));
                        return;
                    }
                    if (!(o instanceof Integer)) break;
                    Integer o2 = (Integer)o;
                    sb.append(Character.toUpperCase((char)o2.intValue()));
                    return;
                }
                case 'f': {
                    if (o == null) {
                        sb.append("null");
                        return;
                    }
                    if (!(o instanceof Number)) break;
                    sb.append(StringFormat.sf(l, "%f", o));
                    return;
                }
            }
            sb.append(StringFormat.sf(l, this.content, o));
        }
    }

    private static abstract class Token {
        private Token() {
        }

        abstract void append(StringBuilder var1, Object[] var2, Locale var3);
    }
}

