/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.jobhistory.errorcode;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.monitor.core.ob.Event;
import org.apache.linkis.monitor.core.ob.Observer;
import org.apache.linkis.monitor.jobhistory.entity.JobHistory;
import org.apache.linkis.monitor.jobhistory.errorcode.JobHistoryErrCodeHitEvent;
import org.apache.linkis.monitor.jobhistory.exception.AnomalyScannerException;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.PooledImsAlertUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A\u0001B\u0003\u0001%!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u0003E\u0001\u0011\u0005Q\tC\u0003J\u0001\u0011\u0005#J\u0001\u0010K_\nD\u0015n\u001d;pef,%O]8s\u0007>$W-\u00117feR\u001cVM\u001c3fe*\u0011aaB\u0001\nKJ\u0014xN]2pI\u0016T!\u0001C\u0005\u0002\u0015)|'\r[5ti>\u0014\u0018P\u0003\u0002\u000b\u0017\u00059Qn\u001c8ji>\u0014(B\u0001\u0007\u000e\u0003\u0019a\u0017N\\6jg*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019B\u0001A\n\u001aCA\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u0010\u000e\u0003mQ!\u0001H\u000f\u0002\u0005=\u0014'B\u0001\u0010\n\u0003\u0011\u0019wN]3\n\u0005\u0001Z\"\u0001C(cg\u0016\u0014h/\u001a:\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013!B;uS2\u001c(B\u0001\u0014\f\u0003\u0019\u0019w.\\7p]&\u0011\u0001f\t\u0002\b\u0019><w-\u001b8h\u0003\u0019\tG.\u001a:ugB!1\u0006\r\u001a>\u001b\u0005a#BA\u0017/\u0003\u0011)H/\u001b7\u000b\u0003=\nAA[1wC&\u0011\u0011\u0007\f\u0002\u0004\u001b\u0006\u0004\bCA\u001a;\u001d\t!\u0004\b\u0005\u00026+5\taG\u0003\u00028#\u00051AH]8pizJ!!O\u000b\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003sU\u0001\"A\u0010\"\u000e\u0003}R!\u0001Q!\u0002\u000b\u0005dWM\u001d;\u000b\u0005\u0011J\u0011BA\"@\u0005%\tE.\u001a:u\t\u0016\u001c8-\u0001\u0004=S:LGO\u0010\u000b\u0003\r\"\u0003\"a\u0012\u0001\u000e\u0003\u0015AQ!\u000b\u0002A\u0002)\na!\u001e9eCR,GcA&O'B\u0011A\u0003T\u0005\u0003\u001bV\u0011A!\u00168ji\")qj\u0001a\u0001!\u0006\tQ\r\u0005\u0002\u001b#&\u0011!k\u0007\u0002\u0006\u000bZ,g\u000e\u001e\u0005\u0006)\u000e\u0001\r!V\u0001\u000fU>\u0014\u0007*[:u_JLH*[:u!\t!b+\u0003\u0002X+\t\u0019\u0011I\\=")
public class JobHistoryErrorCodeAlertSender
implements Observer,
Logging {
    private final Map<String, AlertDesc> alerts;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        JobHistoryErrorCodeAlertSender jobHistoryErrorCodeAlertSender = this;
        synchronized (jobHistoryErrorCodeAlertSender) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public void update(Event e, Object jobHistoryList) {
        if (!(e instanceof JobHistoryErrCodeHitEvent)) {
            throw new AnomalyScannerException(21304, new StringBuilder(74).append("Wrong event that triggers JobHistoryErrorCodeAlertSender. Input DataType: ").append(e.getClass().getCanonicalName()).toString());
        }
        if (jobHistoryList == null || !(jobHistoryList instanceof List)) {
            throw new AnomalyScannerException(21304, new StringBuilder(64).append("Wrong input for JobHistoryErrorCodeAlertSender. Input DataType: ").append(jobHistoryList.getClass().getCanonicalName()).toString());
        }
        HashMap toSend = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)jobHistoryList).asScala()).foreach((Function1 & Serializable & scala.Serializable)a -> {
            if (a == null) {
                this.logger().warn("Ignore null input data");
                return BoxedUnit.UNIT;
            }
            if (!(a instanceof JobHistory)) {
                this.logger().warn(new StringBuilder(31).append("Ignore wrong input data Type : ").append(a.getClass().getCanonicalName()).toString());
                return BoxedUnit.UNIT;
            }
            JobHistory jobHistory = (JobHistory)a;
            String errorCode = String.valueOf(jobHistory.getErrorCode());
            if ($this.alerts.containsKey(errorCode) && $this.alerts.get(errorCode) instanceof ImsAlertDesc) {
                ImsAlertDesc alert = !toSend.containsKey(errorCode) ? (ImsAlertDesc)$this.alerts.get(errorCode) : (ImsAlertDesc)toSend.get(errorCode);
                String newInfo = !toSend.containsKey(errorCode) ? new StringBuilder(17).append(alert.alertInfo()).append("\n").append("[error_code] ").append(jobHistory.getErrorCode()).append(", ").append(jobHistory.getErrorDesc()).append("\n").toString() : alert.alertInfo();
                newInfo = new StringBuilder(85).append(newInfo).append("[job-info] ").append("submit-user: ").append(jobHistory.getSubmitUser()).append(", ").append("execute-user: ").append(jobHistory.getExecuteUser()).append(", ").append("engine_type: ").append(jobHistory.getEngineType()).append(", ").append("create_time: ").append(jobHistory.getCreatedTime()).append(", ").append("instance: ").append(jobHistory.getInstances()).append(". \n").toString();
                int newNumHit = alert.numHit() + 1;
                String x$1 = newInfo;
                int x$2 = newNumHit;
                String x$3 = alert.copy$default$1();
                String x$4 = alert.copy$default$2();
                String x$5 = alert.copy$default$3();
                Enumeration.Value x$6 = alert.copy$default$5();
                String x$7 = alert.copy$default$6();
                int x$8 = alert.copy$default$7();
                Set<Enumeration.Value> x$9 = alert.copy$default$8();
                Set<String> x$10 = alert.copy$default$9();
                Set<String> x$11 = alert.copy$default$10();
                long x$12 = alert.copy$default$12();
                return toSend.put(errorCode, alert.copy(x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$2, x$12));
            }
            if (!$this.alerts.containsKey(errorCode)) {
                this.logger().warn(new StringBuilder(33).append("Ignored unregistered error code: ").append(errorCode).toString());
                return BoxedUnit.UNIT;
            }
            if (!($this.alerts.get(errorCode) instanceof ImsAlertDesc)) {
                this.logger().warn(new StringBuilder(37).append("Ignored invalid alertDesc. DataType: ").append($this.alerts.get(errorCode).getClass().getCanonicalName()).toString());
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(toSend).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JobHistoryErrorCodeAlertSender.$anonfun$update$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            JobHistoryErrorCodeAlertSender.$anonfun$update$3(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$update$3(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            ImsAlertDesc alert = (ImsAlertDesc)tuple2._2();
            PooledImsAlertUtils$.MODULE$.addAlert(alert);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public JobHistoryErrorCodeAlertSender(Map<String, AlertDesc> alerts) {
        this.alerts = alerts;
        Logging.$init$((Logging)this);
    }
}

