/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.scheduled;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.monitor.config.MonitorConfig;
import org.apache.linkis.monitor.constants.Constants;
import org.apache.linkis.monitor.entity.IndexEntity;
import org.apache.linkis.monitor.until.HttpsUntils;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.MonitorAlertUtils;
import org.apache.linkis.monitor.utils.alert.ims.PooledImsAlertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:linkis-et-monitor.properties"}, encoding="UTF-8")
public class ResourceMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ResourceMonitor.class);

    @Scheduled(cron="${linkis.monitor.ecm.resource.cron}")
    public void ecmResourceTask() {
        String tenant = "";
        BigDecimal leftTotalMemory = new BigDecimal("0.0");
        BigDecimal leftTotalInstance = new BigDecimal("0.0");
        BigDecimal leftTotalCores = new BigDecimal("0.0");
        BigDecimal usedTotalMemory = new BigDecimal("0.0");
        BigDecimal usedTotalInstance = new BigDecimal("0.0");
        BigDecimal usedTotalCores = new BigDecimal("0.0");
        StringJoiner minorStr = new StringJoiner(",");
        StringJoiner majorStr = new StringJoiner(",");
        List emNodeVoList = new ArrayList();
        try {
            Map<String, Object> resultmap = HttpsUntils.sendHttp(null, null);
            Map data = MapUtils.getMap(resultmap, (Object)"data");
            emNodeVoList = data.getOrDefault("EMs", new ArrayList());
            logger.info("ResourceMonitor  response  {}:", resultmap);
        }
        catch (IOException e) {
            logger.warn("failed to get EcmResource data");
        }
        for (Map emNodeVoMap : emNodeVoList) {
            Map<String, AlertDesc> ecmResourceAlerts;
            List labels = (List)emNodeVoMap.get("labels");
            for (Map labelMap : labels) {
                tenant = "\u79df\u6237\u6807\u7b7e\uff1a\u516c\u5171\u8d44\u6e90";
                if (!labelMap.containsKey("tenant")) continue;
                tenant = "\u79df\u6237\u6807\u7b7e\uff1a" + labelMap.get("stringValue").toString();
            }
            Map leftResourceMap = MapUtils.getMap((Map)emNodeVoMap, (Object)"leftResource");
            String leftMemoryStr = leftResourceMap.getOrDefault("memory", "0").toString().trim();
            String leftCoresStr = leftResourceMap.getOrDefault("cores", "0").toString().trim();
            String leftInstanceStr = leftResourceMap.getOrDefault("instance", "0").toString().trim();
            BigDecimal leftMemory = new BigDecimal(leftMemoryStr);
            BigDecimal leftCores = new BigDecimal(leftCoresStr);
            BigDecimal leftInstance = new BigDecimal(leftInstanceStr);
            Map maxResourceMap = MapUtils.getMap((Map)emNodeVoMap, (Object)"maxResource");
            String maxMemoryStr = maxResourceMap.getOrDefault("memory", "0").toString().trim();
            String maxCoresStr = maxResourceMap.getOrDefault("cores", "0").toString().trim();
            String maxInstanceStr = maxResourceMap.getOrDefault("instance", "0").toString().trim();
            BigDecimal maxMemory = new BigDecimal(maxMemoryStr);
            BigDecimal maxCores = new BigDecimal(maxCoresStr);
            BigDecimal maxInstance = new BigDecimal(maxInstanceStr);
            Map usedResourceMap = MapUtils.getMap((Map)emNodeVoMap, (Object)"usedResource");
            String usedMemoryStr = usedResourceMap.getOrDefault("memory", "0").toString().trim();
            String usedCoresStr = usedResourceMap.getOrDefault("cores", "0").toString().trim();
            String usedInstanceStr = usedResourceMap.getOrDefault("instance", "0").toString().trim();
            BigDecimal usedMemory = new BigDecimal(usedMemoryStr);
            BigDecimal usedCores = new BigDecimal(usedCoresStr);
            BigDecimal usedInstance = new BigDecimal(usedInstanceStr);
            double memorydouble = leftMemory.divide(maxMemory, 2, RoundingMode.HALF_DOWN).doubleValue();
            double coresdouble = leftCores.divide(maxCores, 2, RoundingMode.HALF_DOWN).doubleValue();
            double instancedouble = leftInstance.divide(maxInstance, 2, RoundingMode.HALF_DOWN).doubleValue();
            Double majorValue = (Double)MonitorConfig.ECM_TASK_MAJOR.getValue();
            Double minorValue = (Double)MonitorConfig.ECM_TASK_MINOR.getValue();
            if (memorydouble <= majorValue || coresdouble <= majorValue || instancedouble <= majorValue) {
                majorStr.add(emNodeVoMap.get("instance").toString());
            } else if (memorydouble < minorValue || coresdouble < minorValue || instancedouble < minorValue) {
                minorStr.add(emNodeVoMap.get("instance").toString());
            }
            HashMap<String, String> replaceParm = new HashMap<String, String>();
            replaceParm.put("$tenant", tenant);
            if (StringUtils.isNotBlank((CharSequence)majorStr.toString())) {
                replaceParm.put("$instance", majorStr.toString());
                replaceParm.put("$ratio", majorValue.toString());
                ecmResourceAlerts = MonitorAlertUtils.getAlerts(Constants.ALERT_RESOURCE_MONITOR(), replaceParm);
                PooledImsAlertUtils.addAlert(ecmResourceAlerts.get("12004"));
            }
            if (StringUtils.isNotBlank((CharSequence)minorStr.toString())) {
                replaceParm.put("$instance", minorStr.toString());
                replaceParm.put("$ratio", minorValue.toString());
                ecmResourceAlerts = MonitorAlertUtils.getAlerts(Constants.ALERT_RESOURCE_MONITOR(), replaceParm);
                PooledImsAlertUtils.addAlert(ecmResourceAlerts.get("12003"));
            }
            this.resourceSendToIms(coresdouble, memorydouble, instancedouble, HttpsUntils.localHost, "LEFT");
            leftTotalMemory = leftTotalMemory.add(leftMemory);
            leftTotalCores = leftTotalCores.add(leftCores);
            leftTotalInstance = leftTotalInstance.add(leftInstance);
            usedTotalMemory = usedTotalMemory.add(usedMemory);
            usedTotalCores = usedTotalCores.add(usedCores);
            usedTotalInstance = usedTotalInstance.add(usedInstance);
        }
        this.resourceSendToIms(leftTotalCores.doubleValue(), leftTotalMemory.doubleValue(), leftTotalInstance.doubleValue(), HttpsUntils.localHost, "TOTAL_LEFT");
        this.resourceSendToIms(usedTotalCores.doubleValue(), usedTotalMemory.doubleValue(), usedTotalInstance.doubleValue(), HttpsUntils.localHost, "TOTAL_USED");
    }

    private void resourceSendToIms(Double coresdouble, Double memorydouble, Double instancedouble, String loaclhost, String name) {
        ArrayList<IndexEntity> list = new ArrayList<IndexEntity>();
        logger.info("ResourceMonitor  send  index ");
        String core = "ECM_CPU_";
        String memory = "ECM_MEMORY_";
        String instance = "ECM_INSTANCE_";
        list.add(new IndexEntity(core.concat(name), "CPU", "INDEX", loaclhost, String.valueOf(coresdouble)));
        list.add(new IndexEntity(memory.concat(name), "MEMORY", "INDEX", loaclhost, String.valueOf(memorydouble)));
        list.add(new IndexEntity(instance.concat(name), "INSTANCE", "INDEX", loaclhost, String.valueOf(instancedouble)));
        try {
            HttpsUntils.sendIndex(list);
        }
        catch (IOException e) {
            logger.warn("failed to send EcmResource index");
        }
    }
}

