/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.utils;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.SystemUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.filesystem.conf.WorkSpaceConfiguration;
import org.slf4j.Logger;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0003\u0006\u0001+!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003B\u0002\u001f\u0001A\u0003%\u0011\u0006C\u0004>\u0001\t\u0007I\u0011\u0002 \t\r-\u0003\u0001\u0015!\u0003@\u0011\u0015a\u0005\u0001\"\u0003N\u0011\u0015\t\u0006\u0001\"\u0003N\u0011\u0015\u0011\u0006\u0001\"\u0001T\u00055)6/\u001a:He>,\b/\u00138g_*\u00111\u0002D\u0001\u0006kRLGn\u001d\u0006\u0003\u001b9\t!BZ5mKNL8\u000f^3n\u0015\ty\u0001#\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\u0005j\u0011A\b\u0006\u0003\u0017}Q!\u0001\t\b\u0002\r\r|W.\\8o\u0013\t\u0011cDA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005Q\u0011\u0001C;tKJd\u0015n\u001d;\u0016\u0003%\u00022AK\u00182\u001b\u0005Y#B\u0001\u0017.\u0003\u001diW\u000f^1cY\u0016T!A\f\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00021W\tY\u0011I\u001d:bs\n+hMZ3s!\t\u0011\u0014H\u0004\u00024oA\u0011A\u0007G\u0007\u0002k)\u0011a\u0007F\u0001\u0007yI|w\u000e\u001e \n\u0005aB\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\r\u0002\u0013U\u001cXM\u001d'jgR\u0004\u0013AC+T\u000bJcujQ&F%V\tq\b\u0005\u0002A\u00136\t\u0011I\u0003\u0002C\u0007\u0006)An\\2lg*\u0011A)R\u0001\u000bG>t7-\u001e:sK:$(B\u0001$H\u0003\u0011)H/\u001b7\u000b\u0003!\u000bAA[1wC&\u0011!*\u0011\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u0006YQkU#S\u0019>\u001b5*\u0012*!\u0003\u0011Ig.\u001b;\u0015\u00039\u0003\"aF(\n\u0005AC\"\u0001B+oSR\faB]3ge\u0016\u001c\b.V:fe6\u000b\u0007/A\u0006jgV\u001bXM]#ySN$HC\u0001+X!\t9R+\u0003\u0002W1\t9!i\\8mK\u0006t\u0007\"\u0002-\t\u0001\u0004\t\u0014\u0001C;tKJt\u0017-\\3")
public class UserGroupInfo
implements Logging {
    private final ArrayBuffer<String> userList;
    private final ReentrantReadWriteLock USERLOCKER;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        UserGroupInfo userGroupInfo = this;
        synchronized (userGroupInfo) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ArrayBuffer<String> userList() {
        return this.userList;
    }

    private ReentrantReadWriteLock USERLOCKER() {
        return this.USERLOCKER;
    }

    private void init() {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.org$apache$linkis$filesystem$utils$UserGroupInfo$$refreshUserMap(), this.logger());
        Runnable runnable = new Runnable(this){
            private final /* synthetic */ UserGroupInfo $outer;

            public void run() {
                Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.org$apache$linkis$filesystem$utils$UserGroupInfo$$refreshUserMap(), this.$outer.logger());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.filesystem.utils.UserGroupInfo$$anon$1 )}, serializedLambda);
            }
        };
        Utils$.MODULE$.defaultScheduler().scheduleWithFixedDelay(runnable, 100000L, Predef$.MODULE$.Long2long((Long)WorkSpaceConfiguration.LOCAL_FILESYSTEM_USER_REFRESH_INTERVAL.getValue()), TimeUnit.MILLISECONDS);
    }

    public void org$apache$linkis$filesystem$utils$UserGroupInfo$$refreshUserMap() {
        ArrayBuffer tmpUsers = new ArrayBuffer();
        List passwd = null;
        passwd = SystemUtils.IS_OS_AIX ? FileUtil.readFile((String)"/etc/passwd") : ExecutingCommand.runNative((String)"getent passwd");
        for (String entry : passwd) {
            String[] split = entry.split(":");
            if (split.length <= 2) continue;
            String userName = split[0];
            tmpUsers.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userName}));
        }
        tmpUsers.sorted((Ordering)Ordering.String$.MODULE$);
        this.logger().info("user refresh user count {}", (Object)BoxesRunTime.boxToInteger((int)tmpUsers.length()));
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("Refresh users:{}", new Object[]{tmpUsers.mkString(",")});
        }
        if (tmpUsers.isEmpty()) {
            this.logger().warn("Refresh user map is empty");
            return;
        }
        this.USERLOCKER().writeLock().lock();
        Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
            this.userList().clear();
            return this.userList().$plus$plus$eq((TraversableOnce)tmpUsers);
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.USERLOCKER().writeLock().unlock());
    }

    public boolean isUserExist(String username) {
        this.USERLOCKER().readLock().lock();
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.userList().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals(username))), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.USERLOCKER().readLock().unlock()));
    }

    public UserGroupInfo() {
        Logging.$init$((Logging)this);
        this.userList = new ArrayBuffer();
        this.USERLOCKER = new ReentrantReadWriteLock();
        this.init();
    }
}

