/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.persistence.persistence.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.persistence.conf.PersistenceConf;
import org.apache.linkis.cs.persistence.dao.ContextIDMapper;
import org.apache.linkis.cs.persistence.entity.ExtraFieldClass;
import org.apache.linkis.cs.persistence.entity.PersistenceContextID;
import org.apache.linkis.cs.persistence.persistence.ContextIDPersistence;
import org.apache.linkis.cs.persistence.util.PersistenceUtils;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextIDPersistenceImpl
implements ContextIDPersistence {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ContextIDMapper contextIDMapper;
    private Class<PersistenceContextID> pClass = PersistenceContextID.class;
    private ObjectMapper json = BDPJettyServerHelper.jacksonJson();

    @Override
    public ContextID createContextID(ContextID contextID) throws CSErrorException {
        try {
            Pair<PersistenceContextID, ExtraFieldClass> pContextID = PersistenceUtils.transfer(contextID, this.pClass);
            ((PersistenceContextID)pContextID.getFirst()).setSource(this.json.writeValueAsString(pContextID.getSecond()));
            Date now = new Date();
            ((PersistenceContextID)pContextID.getFirst()).setCreateTime(now);
            ((PersistenceContextID)pContextID.getFirst()).setUpdateTime(now);
            ((PersistenceContextID)pContextID.getFirst()).setAccessTime(now);
            this.contextIDMapper.createContextID((PersistenceContextID)pContextID.getFirst());
            contextID.setContextId(((PersistenceContextID)pContextID.getFirst()).getContextId());
            return contextID;
        }
        catch (JsonProcessingException e) {
            this.logger.error("writeAsJson failed:", (Throwable)e);
            throw new CSErrorException(97000, e.getMessage());
        }
    }

    @Override
    public void deleteContextID(String contextId) {
        this.contextIDMapper.deleteContextID(contextId);
    }

    @Override
    public void updateContextID(ContextID contextID) throws CSErrorException {
        Pair<PersistenceContextID, ExtraFieldClass> pContextID = PersistenceUtils.transfer(contextID, this.pClass);
        if (null == ((PersistenceContextID)pContextID.getFirst()).getAccessTime()) {
            ((PersistenceContextID)pContextID.getFirst()).setUpdateTime(new Date());
        }
        this.contextIDMapper.updateContextID((PersistenceContextID)pContextID.getFirst());
    }

    @Override
    public ContextID getContextID(String contextId) throws CSErrorException {
        try {
            PersistenceContextID pContextID = this.contextIDMapper.getContextID(contextId);
            if (pContextID == null) {
                return null;
            }
            if (((Boolean)PersistenceConf.ENABLE_CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue()).booleanValue()) {
                if (StringUtils.isBlank((CharSequence)pContextID.getSource()) || StringUtils.isBlank((CharSequence)((CharSequence)PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue()))) {
                    this.logger.error("Source : {} of ContextID or CSID_REPLACE_PACKAGE_HEADER : {} cannot be empty.", (Object)pContextID.getSource(), PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue());
                } else if (pContextID.getSource().contains((CharSequence)PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Will replace package header of source : {} from : {} to : {}", new Object[]{pContextID.getSource(), PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue(), "org.apache.linkis"});
                    }
                    pContextID.setSource(pContextID.getSource().replaceAll((String)PersistenceConf.CS_DESERIALIZE_REPLACE_PACKAGE_HEADER.getValue(), "org.apache.linkis"));
                }
            }
            ExtraFieldClass extraFieldClass = (ExtraFieldClass)this.json.readValue(pContextID.getSource(), ExtraFieldClass.class);
            ContextID contextID = (ContextID)PersistenceUtils.transfer(extraFieldClass, pContextID);
            return contextID;
        }
        catch (IOException e) {
            this.logger.error("readJson failed:", (Throwable)e);
            throw new CSErrorException(97000, e.getMessage());
        }
    }

    @Override
    public List<PersistenceContextID> searchContextID(PersistenceContextID contextID) throws CSErrorException {
        PersistenceContextID persistenceContextID = new PersistenceContextID();
        persistenceContextID.setContextId(contextID.getContextId());
        persistenceContextID.setContextIDType(contextID.getContextIDType());
        return this.contextIDMapper.searchContextID(persistenceContextID);
    }

    @Override
    public List<PersistenceContextID> searchCSIDByTime(Date createTimeStart, Date createTimeEnd, Date updateTimeStart, Date updateTimeEnd, Date accessTimeStart, Date accessTimeEnd) {
        return this.contextIDMapper.getAllContextIDByTime(createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd, accessTimeStart, accessTimeEnd);
    }
}

