/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.scheduler;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.linkis.cs.server.conf.ContextServerConf;
import org.apache.linkis.cs.server.scheduler.CsScheduler;
import org.apache.linkis.cs.server.scheduler.HttpAnswerJob;
import org.apache.linkis.cs.server.scheduler.HttpJob;
import org.apache.linkis.cs.server.scheduler.impl.CsJobListener;
import org.apache.linkis.cs.server.scheduler.impl.CsSchedulerJob;
import org.apache.linkis.cs.server.service.Service;
import org.apache.linkis.scheduler.Scheduler;
import org.apache.linkis.scheduler.listener.JobListener;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.SchedulerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultCsScheduler
implements CsScheduler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private List<Service> services;

    @Override
    public void addService(Service service) {
        this.services.add(service);
    }

    @Override
    public Service[] getServices() {
        return this.services.toArray(new Service[0]);
    }

    @Override
    public void submit(HttpJob job) throws InterruptedException {
        Job csJob = this.buildJob(job);
        csJob.setJobListener((JobListener)new CsJobListener());
        this.scheduler.submit((SchedulerEvent)csJob);
        if (job instanceof HttpAnswerJob) {
            HttpAnswerJob answerJob = (HttpAnswerJob)job;
            answerJob.getResponseProtocol().waitTimeEnd(ContextServerConf.CS_SCHEDULER_JOB_WAIT_MILLS);
        }
    }

    private Job buildJob(HttpJob job) {
        CsSchedulerJob csJob = new CsSchedulerJob();
        csJob.setId(job.getRequestProtocol().getUsername());
        csJob.set(job);
        Optional<Service> service = Arrays.stream(this.getServices()).filter(s -> s.ifAccept(job)).findFirst();
        if (service.isPresent()) {
            this.logger.info(String.format("find %s service to execute job", service.get().getName()));
            csJob.setConsuemr(service.get()::accept);
        }
        return csJob;
    }
}

