/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.Tags;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmMetricPoller
implements MetricPoller {
    private static final String CLASS = "class";
    private static final Thread.State[] VALID_STATES = Thread.State.values();
    private static final MonitorConfig LOADED_CLASS_COUNT = MonitorConfig.builder("loadedClassCount").withTag("class", ClassLoadingMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig TOTAL_LOADED_CLASS_COUNT = MonitorConfig.builder("totalLoadedClassCount").withTag("class", ClassLoadingMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig UNLOADED_CLASS_COUNT = MonitorConfig.builder("unloadedClassCount").withTag("class", ClassLoadingMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig TOTAL_COMPILATION_TIME = MonitorConfig.builder("totalCompilationTime").withTag("class", CompilationMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig COLLECTION_COUNT = MonitorConfig.builder("collectionCount").withTag("class", GarbageCollectorMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig COLLECTION_TIME = MonitorConfig.builder("collectionTime").withTag("class", GarbageCollectorMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig COMMITTED_USAGE = MonitorConfig.builder("committedUsage").withTag("class", MemoryPoolMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig INIT_USAGE = MonitorConfig.builder("initUsage").withTag("class", MemoryPoolMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig MAX_USAGE = MonitorConfig.builder("maxUsage").withTag("class", MemoryPoolMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig ACTUAL_USAGE = MonitorConfig.builder("actualUsage").withTag("class", MemoryPoolMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig AVAILABLE_PROCESSORS = MonitorConfig.builder("availableProcessors").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig LOAD_AVERAGE = MonitorConfig.builder("systemLoadAverage").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig MAX_FILE_DESCRIPTOR_COUNT = MonitorConfig.builder("maxFileDescriptorCount").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig OPEN_FILE_DESCRIPTOR_COUNT = MonitorConfig.builder("openFileDescriptorCount").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig COMMITTED_VIRTUAL_MEMORY_SIZE = MonitorConfig.builder("committedVirtualMemorySize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig TOTAL_PHYSICAL_MEMORY_SIZE = MonitorConfig.builder("totalPhysicalMemorySize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig FREE_PHYSICAL_MEMORY_SIZE = MonitorConfig.builder("freePhysicalMemorySize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig TOTAL_SWAP_SPACE_SIZE = MonitorConfig.builder("totalSwapSpaceSize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig FREE_SWAP_SPACE_SIZE = MonitorConfig.builder("freeSwapSpaceSize").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig PROCESS_CPU_LOAD = MonitorConfig.builder("processCpuLoad").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig SYSTEM_CPU_LOAD = MonitorConfig.builder("systemCpuLoad").withTag("class", OperatingSystemMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig DAEMON_THREAD_COUNT = MonitorConfig.builder("daemonThreadCount").withTag("class", ThreadMXBean.class.getSimpleName()).withTag(DataSourceType.GAUGE).build();
    private static final MonitorConfig[] THREAD_COUNTS = new MonitorConfig[VALID_STATES.length];
    private static final MonitorConfig TOTAL_STARTED_THREAD_COUNT = MonitorConfig.builder("totalStartedThreadCount").withTag("class", ThreadMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig THREAD_BLOCKED_COUNT = MonitorConfig.builder("threadBlockedCount").withTag("class", ThreadMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig THREAD_BLOCKED_TIME = MonitorConfig.builder("threadBlockedTime").withTag("class", ThreadMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig THREAD_WAITED_COUNT = MonitorConfig.builder("threadWaitedCount").withTag("class", ThreadMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final MonitorConfig THREAD_WAITED_TIME = MonitorConfig.builder("threadWaitedTime").withTag("class", ThreadMXBean.class.getSimpleName()).withTag(DataSourceType.COUNTER).build();
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmMetricPoller.class);
    private static final int IDX_BLOCKED_COUNT = 0;
    private static final int IDX_BLOCKED_TIME = 1;
    private static final int IDX_WAITED_COUNT = 2;
    private static final int IDX_WAITED_TIME = 3;
    private static final long[] BASE_THREAD_COUNTS = new long[]{0L, 0L, 0L, 0L};
    private static final Map<Thread.State, Integer> STATE_LOOKUP = new HashMap<Thread.State, Integer>();
    private ThreadInfo[] lastThreadInfos = new ThreadInfo[0];

    @Override
    public final List<Metric> poll(MetricFilter filter) {
        return this.poll(filter, false);
    }

    @Override
    public final List<Metric> poll(MetricFilter filter, boolean reset) {
        long now = System.currentTimeMillis();
        MetricList metrics = new MetricList(filter);
        this.addClassLoadingMetrics(now, metrics);
        this.addCompilationMetrics(now, metrics);
        this.addGarbageCollectorMetrics(now, metrics);
        this.addMemoryPoolMetrics(now, metrics);
        this.addOperatingSystemMetrics(now, metrics);
        this.addThreadMetrics(now, metrics);
        return metrics.getList();
    }

    private void addClassLoadingMetrics(long timestamp, MetricList metrics) {
        ClassLoadingMXBean bean = ManagementFactory.getClassLoadingMXBean();
        metrics.add(new Metric(LOADED_CLASS_COUNT, timestamp, bean.getLoadedClassCount()));
        metrics.add(new Metric(TOTAL_LOADED_CLASS_COUNT, timestamp, bean.getTotalLoadedClassCount()));
        metrics.add(new Metric(UNLOADED_CLASS_COUNT, timestamp, bean.getUnloadedClassCount()));
    }

    private void addCompilationMetrics(long timestamp, MetricList metrics) {
        CompilationMXBean bean = ManagementFactory.getCompilationMXBean();
        metrics.add(new Metric(TOTAL_COMPILATION_TIME, timestamp, bean.getTotalCompilationTime()));
    }

    private void addGarbageCollectorMetrics(long timestamp, MetricList metrics) {
        List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean bean : beans) {
            Tag id = Tags.newTag("id", bean.getName());
            metrics.add(new Metric(COLLECTION_COUNT.withAdditionalTag(id), timestamp, bean.getCollectionCount()));
            metrics.add(new Metric(COLLECTION_TIME.withAdditionalTag(id), timestamp, bean.getCollectionTime()));
        }
    }

    private void addMemoryPoolMetrics(long timestamp, MetricList metrics) {
        List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean bean : beans) {
            BasicTagList tags = BasicTagList.of("id", bean.getName(), "memtype", bean.getType().name());
            this.addMemoryUsageMetrics(tags, timestamp, bean.getUsage(), metrics);
        }
    }

    private void addMemoryUsageMetrics(TagList tags, long timestamp, MemoryUsage usage, MetricList metrics) {
        metrics.add(new Metric(COMMITTED_USAGE.withAdditionalTags(tags), timestamp, usage.getCommitted()));
        metrics.add(new Metric(INIT_USAGE.withAdditionalTags(tags), timestamp, usage.getInit()));
        metrics.add(new Metric(ACTUAL_USAGE.withAdditionalTags(tags), timestamp, usage.getUsed()));
        metrics.add(new Metric(MAX_USAGE.withAdditionalTags(tags), timestamp, usage.getMax()));
    }

    private void addOperatingSystemMetrics(long timestamp, MetricList metrics) {
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        metrics.add(new Metric(AVAILABLE_PROCESSORS, timestamp, bean.getAvailableProcessors()));
        metrics.add(new Metric(LOAD_AVERAGE, timestamp, bean.getSystemLoadAverage()));
        this.addOptionalMetric(MAX_FILE_DESCRIPTOR_COUNT, timestamp, bean, "getMaxFileDescriptorCount", metrics);
        this.addOptionalMetric(OPEN_FILE_DESCRIPTOR_COUNT, timestamp, bean, "getOpenFileDescriptorCount", metrics);
        this.addOptionalMetric(COMMITTED_VIRTUAL_MEMORY_SIZE, timestamp, bean, "getCommittedVirtualMemorySize", metrics);
        this.addOptionalMetric(TOTAL_PHYSICAL_MEMORY_SIZE, timestamp, bean, "getTotalPhysicalMemorySize", metrics);
        this.addOptionalMetric(FREE_PHYSICAL_MEMORY_SIZE, timestamp, bean, "getFreePhysicalMemorySize", metrics);
        this.addOptionalMetric(TOTAL_SWAP_SPACE_SIZE, timestamp, bean, "getTotalSwapSpaceSize", metrics);
        this.addOptionalMetric(FREE_SWAP_SPACE_SIZE, timestamp, bean, "getFreeSwapSpaceSize", metrics);
        this.addOptionalMetric(PROCESS_CPU_LOAD, timestamp, bean, "getProcessCpuLoad", metrics);
        this.addOptionalMetric(SYSTEM_CPU_LOAD, timestamp, bean, "getSystemCpuLoad", metrics);
    }

    private void addThreadMetrics(long timestamp, MetricList metrics) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        metrics.add(new Metric(DAEMON_THREAD_COUNT, timestamp, bean.getDaemonThreadCount()));
        metrics.add(new Metric(TOTAL_STARTED_THREAD_COUNT, timestamp, bean.getTotalStartedThreadCount()));
        this.addDetailedThreadMetrics(timestamp, metrics);
    }

    private void addDetailedThreadMetrics(long timestamp, MetricList metrics) {
        int i;
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        if (!bean.isThreadContentionMonitoringSupported()) {
            return;
        }
        if (!bean.isThreadContentionMonitoringEnabled()) {
            bean.setThreadContentionMonitoringEnabled(true);
        }
        ThreadInfo[] threadInfo = bean.dumpAllThreads(false, false);
        Arrays.sort(threadInfo, (a, b) -> {
            long diff = b.getThreadId() - a.getThreadId();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        long[] stateCounts = new long[VALID_STATES.length];
        for (int i2 = 0; i2 < stateCounts.length; ++i2) {
            stateCounts[i2] = 0L;
        }
        long blockedCount = 0L;
        long blockedTime = 0L;
        long waitedCount = 0L;
        long waitedTime = 0L;
        int l = this.lastThreadInfos.length - 1;
        for (i = threadInfo.length - 1; i >= 0; --i) {
            long currId = threadInfo[i].getThreadId();
            while (l >= 0 && this.lastThreadInfos[l].getThreadId() < currId) {
                --l;
            }
            if (l >= 0 && this.lastThreadInfos[l].getThreadId() > currId) {
                BASE_THREAD_COUNTS[0] = BASE_THREAD_COUNTS[0] + this.lastThreadInfos[l].getBlockedCount();
                BASE_THREAD_COUNTS[1] = BASE_THREAD_COUNTS[1] + this.lastThreadInfos[l].getBlockedTime();
                BASE_THREAD_COUNTS[2] = BASE_THREAD_COUNTS[2] + this.lastThreadInfos[l].getWaitedCount();
                BASE_THREAD_COUNTS[3] = BASE_THREAD_COUNTS[3] + this.lastThreadInfos[l].getWaitedTime();
            }
            int n = STATE_LOOKUP.get((Object)threadInfo[i].getThreadState());
            stateCounts[n] = stateCounts[n] + 1L;
            blockedCount += threadInfo[i].getBlockedCount();
            blockedTime += threadInfo[i].getBlockedTime();
            waitedCount += threadInfo[i].getWaitedCount();
            waitedTime += threadInfo[i].getWaitedTime();
        }
        metrics.add(new Metric(THREAD_BLOCKED_COUNT, timestamp, blockedCount + BASE_THREAD_COUNTS[0]));
        metrics.add(new Metric(THREAD_BLOCKED_TIME, timestamp, (blockedTime + BASE_THREAD_COUNTS[1]) / 1000L));
        metrics.add(new Metric(THREAD_WAITED_COUNT, timestamp, waitedCount + BASE_THREAD_COUNTS[2]));
        metrics.add(new Metric(THREAD_WAITED_TIME, timestamp, (waitedTime + BASE_THREAD_COUNTS[3]) / 1000L));
        for (i = 0; i < stateCounts.length; ++i) {
            metrics.add(new Metric(THREAD_COUNTS[i], timestamp, stateCounts[i]));
        }
        this.lastThreadInfos = threadInfo;
    }

    private void addOptionalMetric(MonitorConfig config, long timestamp, Object obj, String methodName, MetricList metrics) {
        try {
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Number value = (Number)method.invoke(obj, new Object[0]);
            metrics.add(new Metric(config, timestamp, value));
        }
        catch (Exception e) {
            String msg = String.format("failed to get value for %s.%s", obj.getClass().getName(), methodName);
            LOGGER.debug(msg, (Throwable)e);
        }
    }

    static {
        for (int i = 0; i < VALID_STATES.length; ++i) {
            Thread.State state = VALID_STATES[i];
            STATE_LOOKUP.put(state, i);
            JvmMetricPoller.THREAD_COUNTS[i] = MonitorConfig.builder("threadCount").withTag(CLASS, ThreadMXBean.class.getSimpleName()).withTag("state", state.toString()).withTag(DataSourceType.GAUGE).build();
        }
    }

    private static class MetricList {
        private final MetricFilter filter;
        private final List<Metric> list;

        public MetricList(MetricFilter filter) {
            this.filter = filter;
            this.list = new ArrayList<Metric>();
        }

        public void add(Metric m) {
            if (this.filter.matches(m.getConfig())) {
                this.list.add(m);
            }
        }

        public List<Metric> getList() {
            return this.list;
        }
    }
}

