/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.BDPConfiguration;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.exception.LinkisException;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.apache.linkis.server.conf.ServerConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.web.filter.CharacterEncodingFilter;

@SpringBootApplication(scanBasePackages={"org.apache.linkis", "com.webank.wedatasphere"})
@EnableDiscoveryClient
@RefreshScope
@EnableFeignClients
@EnableRetry
public class DataWorkCloudApplication
extends SpringBootServletInitializer {
    private static final Logger logger = LoggerFactory.getLogger(DataWorkCloudApplication.class);
    private static ConfigurableApplicationContext applicationContext;
    private static ServiceInstance serviceInstance;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void main(String[] args) throws ReflectiveOperationException {
        SpringApplication application = new SpringApplication(new Class[]{DataWorkCloudApplication.class});
        application.addListeners(new ApplicationListener[]{new ApplicationListener<ApplicationPreparedEvent>(){

            public void onApplicationEvent(ApplicationPreparedEvent applicationPreparedEvent) {
                logger.info("add config from config server...");
                if (applicationContext == null) {
                    applicationContext = applicationPreparedEvent.getApplicationContext();
                }
                DataWorkCloudApplication.addRemoteConfig();
                logger.info("initialize DataWorkCloud spring application...");
                DataWorkCloudApplication.initDWCApplication();
            }
        }});
        application.addListeners(new ApplicationListener[]{new ApplicationListener<RefreshScopeRefreshedEvent>(){

            public void onApplicationEvent(RefreshScopeRefreshedEvent applicationEvent) {
                logger.info("refresh config from config server...");
                DataWorkCloudApplication.updateRemoteConfig();
            }
        }});
        String listeners = (String)ServerConfiguration.BDP_SERVER_SPRING_APPLICATION_LISTENERS().getValue();
        if (StringUtils.isNotBlank((CharSequence)listeners)) {
            for (String listener : listeners.split(",")) {
                application.addListeners(new ApplicationListener[]{(ApplicationListener)Class.forName(listener).newInstance()});
            }
        }
        if ("true".equals(ServerConfiguration.IS_GATEWAY().getValue())) {
            application.setWebApplicationType(WebApplicationType.REACTIVE);
        }
        applicationContext = application.run(args);
    }

    public static void updateRemoteConfig() {
        DataWorkCloudApplication.addOrUpdateRemoteConfig((Environment)applicationContext.getEnvironment(), true);
    }

    public static void addRemoteConfig() {
        DataWorkCloudApplication.addOrUpdateRemoteConfig((Environment)applicationContext.getEnvironment(), false);
    }

    private static void addOrUpdateRemoteConfig(Environment env, boolean isUpdateOrNot) {
        StandardEnvironment environment = (StandardEnvironment)env;
        PropertySource propertySource = environment.getPropertySources().get("bootstrapProperties");
        if (propertySource == null) {
            return;
        }
        CompositePropertySource source = (CompositePropertySource)propertySource;
        for (String key : source.getPropertyNames()) {
            Object val = source.getProperty(key);
            if (val == null) continue;
            if (isUpdateOrNot) {
                logger.info("update remote config => " + key + " = " + source.getProperty(key));
                BDPConfiguration.set((String)key, (String)val.toString());
                continue;
            }
            logger.info("add remote config => " + key + " = " + source.getProperty(key));
            BDPConfiguration.setIfNotExists((String)key, (String)val.toString());
        }
    }

    private static void initDWCApplication() {
        String hostName;
        if (Configuration.PREFER_IP_ADDRESS()) {
            hostName = applicationContext.getEnvironment().getProperty("spring.cloud.client.ip-address");
            logger.info("using ip address replace hostname, because linkis.discovery.prefer-ip-address: true");
        } else {
            hostName = applicationContext.getEnvironment().getProperty("eureka.instance.hostname", "");
            if (StringUtils.isBlank((CharSequence)hostName)) {
                hostName = Utils.getComputerName();
            }
        }
        serviceInstance = new ServiceInstance();
        serviceInstance.setApplicationName(applicationContext.getEnvironment().getProperty("spring.application.name"));
        serviceInstance.setInstance(hostName + ":" + applicationContext.getEnvironment().getProperty("server.port"));
        LinkisException.setApplicationName((String)serviceInstance.getApplicationName());
        LinkisException.setHostname((String)hostName);
        LinkisException.setHostPort((int)Integer.parseInt(applicationContext.getEnvironment().getProperty("server.port")));
    }

    public static ServiceInstance getServiceInstance() {
        return serviceInstance;
    }

    public static String getApplicationName() {
        return serviceInstance.getApplicationName();
    }

    public static String getInstance() {
        return serviceInstance.getInstance();
    }

    public static void setProperty(String key, String value) {
        BDPConfiguration.set((String)key, (String)value);
    }

    public static void setPropertyIfNotExists(String key, String value) {
        BDPConfiguration.setIfNotExists((String)key, (String)value);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(new Class[]{DataWorkCloudApplication.class});
    }

    @Bean
    public ObjectMapper defaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        return objectMapper;
    }

    @Bean
    public WebServerFactoryCustomizer<JettyServletWebServerFactory> jettyFactoryCustomizer() {
        return new WebServerFactoryCustomizer<JettyServletWebServerFactory>(){

            public void customize(JettyServletWebServerFactory jettyServletWebServerFactory) {
                jettyServletWebServerFactory.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

                    public void customize(Server server) {
                        Handler[] childHandlersByClass = server.getChildHandlersByClass(WebAppContext.class);
                        WebAppContext webApp = (WebAppContext)childHandlersByClass[0];
                        FilterHolder filterHolder = new FilterHolder(CharacterEncodingFilter.class);
                        filterHolder.setInitParameter("encoding", (String)Configuration.BDP_ENCODING().getValue());
                        filterHolder.setInitParameter("forceEncoding", "true");
                        webApp.addFilter(filterHolder, "/*", EnumSet.allOf(DispatcherType.class));
                        BDPJettyServerHelper.setupSpringRestApiContextHandler((ServletContextHandler)webApp);
                        if (((Boolean)ServerConfiguration.BDP_SERVER_SOCKET_MODE().getValue()).booleanValue()) {
                            BDPJettyServerHelper.setupControllerServer((ServletContextHandler)webApp);
                        }
                        if (!((Boolean)ServerConfiguration.BDP_SERVER_DISTINCT_MODE().getValue()).booleanValue()) {
                            BDPJettyServerHelper.setupWebAppContext(webApp);
                        }
                    }
                }});
            }
        };
    }
}

