/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark;

import io.swagger.annotations.Api;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.engineplugin.spark.utils.DataFrameResponse;
import org.apache.linkis.engineplugin.spark.utils.DirectPushCache;
import org.apache.linkis.server.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"DirectPush"})
@RestController
@RequestMapping(path={"directpush"})
public class DirectPushRestfulApi {
    private static final Logger logger = LoggerFactory.getLogger(DirectPushRestfulApi.class);

    @RequestMapping(path={"pull"}, method={RequestMethod.POST})
    public Message getDirectPushResult(HttpServletRequest req, @RequestBody Map<String, Object> json) {
        Message message = null;
        try {
            String taskId = json.getOrDefault("taskId", null);
            if (taskId == null) {
                message = Message.error((String)"taskId is null");
                return message;
            }
            int fetchSize = (Integer)json.getOrDefault("fetchSize", 1000);
            DataFrameResponse response = DirectPushCache.fetchResultSetOfDataFrame(taskId, fetchSize);
            message = response.dataFrame() == null ? Message.error((String)("No result found for taskId: " + taskId)) : Message.ok().data("data", response.dataFrame()).data("hasMoreData", (Object)response.hasMoreData());
        }
        catch (Exception e) {
            logger.error("Failed to get direct push result", (Throwable)e);
            message = Message.error((String)("Failed to get direct push result: " + e.getMessage()));
        }
        return message;
    }
}

