/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.python.executor;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.computation.executor.rs.RsOutputStream;
import org.apache.linkis.engineconn.launch.EngineConnServer$;
import org.apache.linkis.governance.common.utils.GovernanceUtils$;
import org.apache.linkis.manager.engineplugin.common.conf.EngineConnPluginConf$;
import org.apache.linkis.manager.engineplugin.python.conf.PythonEngineConfiguration$;
import org.apache.linkis.manager.engineplugin.python.errorcode.LinkisPythonErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.python.exception.ExecuteException;
import org.apache.linkis.manager.engineplugin.python.exception.ExecuteException$;
import org.apache.linkis.manager.engineplugin.python.exception.PythonExecuteError;
import org.apache.linkis.manager.engineplugin.python.executor.Python;
import org.apache.linkis.manager.engineplugin.python.executor.PythonInterpretRequest;
import org.apache.linkis.manager.engineplugin.python.executor.PythonSession$;
import org.apache.linkis.manager.engineplugin.python.utils.Kind;
import org.apache.linkis.manager.engineplugin.python.utils.Kind$;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.domain.BooleanType$;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.domain.DoubleType$;
import org.apache.linkis.storage.domain.FloatType$;
import org.apache.linkis.storage.domain.IntType$;
import org.apache.linkis.storage.domain.StringType$;
import org.apache.linkis.storage.domain.TimestampType$;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.ResultSetWriter$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.slf4j.Logger;
import py4j.GatewayServer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tUd\u0001\u0002\u001b6\u0001\u0011CQa\u0015\u0001\u0005\u0002QCqA\u000e\u0001C\u0002\u0013-q\u000b\u0003\u0004_\u0001\u0001\u0006I\u0001\u0017\u0005\n?\u0002\u0001\r\u00111A\u0005\n\u0001D\u0011\u0002\u001c\u0001A\u0002\u0003\u0007I\u0011B7\t\u0013M\u0004\u0001\u0019!A!B\u0013\t\u0007\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0003v\u0011%a\b\u00011AA\u0002\u0013%Q\u0010C\u0005\u0000\u0001\u0001\u0007\t\u0011)Q\u0005m\"Y\u0011\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0002\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!a\u0006\t\u0017\u0005m\u0001\u00011A\u0001B\u0003&\u0011Q\u0001\u0005\f\u0003;\u0001\u0001\u0019!A!B\u0013\ty\u0002C\u0005\u0002<\u0001\u0001\r\u0011\"\u0003\u0002>!I\u0011Q\t\u0001A\u0002\u0013%\u0011q\t\u0005\t\u0003\u0017\u0002\u0001\u0015)\u0003\u0002@!I\u0011Q\n\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002R!I\u0011q\f\u0001C\u0002\u0013%\u0011\u0011\r\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002d!Y\u0011\u0011\u000f\u0001A\u0002\u0003\u0007I\u0011BA:\u0011-\t)\b\u0001a\u0001\u0002\u0004%I!a\u001e\t\u0017\u0005m\u0004\u00011A\u0001B\u0003&\u0011Q\u0005\u0005\n\u0003{\u0002\u0001\u0019!C\u0005\u0003\u007fB\u0011\"a\"\u0001\u0001\u0004%I!!#\t\u0011\u00055\u0005\u0001)Q\u0005\u0003\u0003C\u0011\"a$\u0001\u0005\u0004%I!a\u001d\t\u0011\u0005E\u0005\u0001)A\u0005\u0003KAq!a%\u0001\t\u0013\t)\nC\u0004\u0002\u0018\u0002!\t!!'\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u00111\u0015\u0001\u0005\n\u0005\u0015\u0006bBAT\u0001\u0011\u0005\u0011\u0011\u0014\u0005\u0007I\u0002!\t!!+\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003\u001f\u0004A\u0011AAi\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002l\u0002!\t!!*\t\u000f\u00055\b\u0001\"\u0001\u0002p\"9\u00111 \u0001\u0005\u0002\u0005u\bb\u0002B\n\u0001\u0011\u0005!Q\u0003\u0005\b\u0005g\u0001A\u0011\u0001B\u001b\u000f\u001d\u0011Y$\u000eE\u0001\u0005{1a\u0001N\u001b\t\u0002\t}\u0002BB*0\t\u0003\u0011\t\u0005\u0003\u0005\u0003D=\"\ta\fB#\u0011)\u0011YfLI\u0001\n\u0003y#Q\f\u0005\t\u0005gzC\u0011A\u0018\u0002t\ti\u0001+\u001f;i_:\u001cVm]:j_:T!AN\u001c\u0002\u0011\u0015DXmY;u_JT!\u0001O\u001d\u0002\rALH\u000f[8o\u0015\tQ4(\u0001\u0007f]\u001eLg.\u001a9mk\u001eLgN\u0003\u0002={\u00059Q.\u00198bO\u0016\u0014(B\u0001 @\u0003\u0019a\u0017N\\6jg*\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0007\u0001\u00192\u0001A#L!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fMB\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0006kRLGn\u001d\u0006\u0003!v\naaY8n[>t\u0017B\u0001*N\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A+\u0011\u0005Y\u0003Q\"A\u001b\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!aW$\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002^5\nyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013AF3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003\u0005\u0004\"A\u00196\u000e\u0003\rT!\u0001Z3\u0002\u000f\u0015DXmY;uK*\u0011aG\u001a\u0006\u0003O\"\f1bY8naV$\u0018\r^5p]*\u0011\u0011.P\u0001\u000bK:<\u0017N\\3d_:t\u0017BA6d\u0005Y)enZ5oK\u0016CXmY;uS>t7i\u001c8uKb$\u0018AG3oO&tW-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;`I\u0015\fHC\u00018r!\t1u.\u0003\u0002q\u000f\n!QK\\5u\u0011\u001d\u0011X!!AA\u0002\u0005\f1\u0001\u001f\u00132\u0003])gnZ5oK\u0016CXmY;uS>t7i\u001c8uKb$\b%A\u0007hCR,w/Y=TKJ4XM]\u000b\u0002mB\u0011qO_\u0007\u0002q*\t\u00110\u0001\u0003qsRR\u0017BA>y\u000559\u0015\r^3xCf\u001cVM\u001d<fe\u0006\tr-\u0019;fo\u0006L8+\u001a:wKJ|F%Z9\u0015\u00059t\bb\u0002:\t\u0003\u0003\u0005\rA^\u0001\u000fO\u0006$Xm^1z'\u0016\u0014h/\u001a:!\u0003\u001d\u0001(o\\2fgN,\"!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005!A.\u00198h\u0015\t\ty!\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003\u0013\u0011q\u0001\u0015:pG\u0016\u001c8/A\u0006qe>\u001cWm]:`I\u0015\fHc\u00018\u0002\u001a!A!oCA\u0001\u0002\u0004\t)!\u0001\u0005qe>\u001cWm]:!\u0003\u001d\u0001(o\\7jg\u0016\u0004R!WA\u0011\u0003KI1!a\t[\u0005\u001d\u0001&o\\7jg\u0016\u0004B!a\n\u000269!\u0011\u0011FA\u0019!\r\tYcR\u0007\u0003\u0003[Q1!a\fD\u0003\u0019a$o\\8u}%\u0019\u00111G$\u0002\rA\u0013X\rZ3g\u0013\u0011\t9$!\u000f\u0003\rM#(/\u001b8h\u0015\r\t\u0019dR\u0001\u0018af$\bn\u001c8TGJL\u0007\u000f^%oSRL\u0017\r\\5{K\u0012,\"!a\u0010\u0011\u0007\u0019\u000b\t%C\u0002\u0002D\u001d\u0013qAQ8pY\u0016\fg.A\u000eqsRDwN\\*de&\u0004H/\u00138ji&\fG.\u001b>fI~#S-\u001d\u000b\u0004]\u0006%\u0003\u0002\u0003:\u0010\u0003\u0003\u0005\r!a\u0010\u00021ALH\u000f[8o'\u000e\u0014\u0018\u000e\u001d;J]&$\u0018.\u00197ju\u0016$\u0007%\u0001\u0007pkR\u0004X\u000f^*ue\u0016\fW.\u0006\u0002\u0002RA!\u00111KA-\u001b\t\t)FC\u0002\u0002X\u0015\f!A]:\n\t\u0005m\u0013Q\u000b\u0002\u000f%N|U\u000f\u001e9viN#(/Z1n\u00035yW\u000f\u001e9viN#(/Z1nA\u0005I\u0011/^3ss2{7m[\u000b\u0003\u0003G\u0002RARA3\u0003SJ1!a\u001aH\u0005\u0015\t%O]1z!\r1\u00151N\u0005\u0004\u0003[:%\u0001\u0002\"zi\u0016\f!\"];fefdunY6!\u0003\u0011\u0019w\u000eZ3\u0016\u0005\u0005\u0015\u0012\u0001C2pI\u0016|F%Z9\u0015\u00079\fI\b\u0003\u0005s-\u0005\u0005\t\u0019AA\u0013\u0003\u0015\u0019w\u000eZ3!\u0003\r\u0001\u0018\u000eZ\u000b\u0003\u0003\u0003\u0003RARAB\u0003KI1!!\"H\u0005\u0019y\u0005\u000f^5p]\u00069\u0001/\u001b3`I\u0015\fHc\u00018\u0002\f\"A!/GA\u0001\u0002\u0004\t\t)\u0001\u0003qS\u0012\u0004\u0013\u0001\u00069zi\"|g\u000eR3gCVdGOV3sg&|g.A\u000bqsRDwN\u001c#fM\u0006,H\u000e\u001e,feNLwN\u001c\u0011\u0002\u0019\u001d,G\u000fU=WKJ\u001c\u0018n\u001c8\u0015\u0005\u0005\u0015\u0012\u0001B5oSR$\u0012A\\\u0001\u001ag\u0016$XI\\4j]\u0016,\u00050Z2vi&|gnQ8oi\u0016DH\u000fF\u0002o\u0003?Ca!!) \u0001\u0004\t\u0017!F3oO&tW-\u0012=fGV$xN]\"p]R,\u0007\u0010^\u0001\fS:LGoR1uK^\f\u00170F\u0001o\u0003=a\u0017M_=J]&$x)\u0019;fo\u0006LHc\u00018\u0002,\"9\u0011\u0011\u000f\u0012A\u0002\u0005\u0015\u0012!G8o!f$\bn\u001c8TGJL\u0007\u000f^%oSRL\u0017\r\\5{K\u0012$2A\\AY\u0011\u001d\tih\ta\u0001\u0003g\u00032ARA[\u0013\r\t9l\u0012\u0002\u0004\u0013:$\u0018!D4fiN#\u0018\r^3nK:$8/\u0006\u0002\u0002>B\u0019a+a0\n\u0007\u0005\u0005WG\u0001\fQsRDwN\\%oi\u0016\u0014\bO]3u%\u0016\fX/Z:u\u0003U\u0019X\r^*uCR,W.\u001a8ug\u001aKg.[:iK\u0012$b!a\b\u0002H\u0006-\u0007bBAeK\u0001\u0007\u0011QE\u0001\u0004_V$\bbBAgK\u0001\u0007\u0011qH\u0001\u0006KJ\u0014xN]\u0001\rCB\u0004XM\u001c3PkR\u0004X\u000f\u001e\u000b\u0004]\u0006M\u0007bBAkM\u0001\u0007\u0011QE\u0001\b[\u0016\u001c8/Y4f\u0003E\t\u0007\u000f]3oI\u0016\u0013(o\u001c:PkR\u0004X\u000f\u001e\u000b\u0004]\u0006m\u0007bBAkO\u0001\u0007\u0011QE\u0001\taJLg\u000e\u001e'pOR\u0019a.!9\t\u000f\u0005\r\b\u00061\u0001\u0002f\u0006\u0019An\\4\u0011\u0007\u0019\u000b9/C\u0002\u0002j\u001e\u00131!\u00118z\u0003\u0015\u0019Gn\\:f\u0003\u001d9W\r^&j]\u0012,\"!!=\u0011\t\u0005M\u0018q_\u0007\u0003\u0003kT!AT\u001c\n\t\u0005e\u0018Q\u001f\u0002\u0005\u0017&tG-\u0001\u0005dQ\u0006tw-\u001a#U)\u0011\tyPa\u0004\u0011\t\t\u0005!1B\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u00051Am\\7bS:T1A!\u0003>\u0003\u001d\u0019Ho\u001c:bO\u0016LAA!\u0004\u0003\u0004\tAA)\u0019;b)f\u0004X\rC\u0004\u0003\u0012-\u0002\r!!\n\u0002\u0005\u0011$\u0018AB:i_^$e\tF\u0004o\u0005/\u0011ICa\f\t\u000f\teA\u00061\u0001\u0003\u001c\u0005!A-\u0019;b!\u0019\u0011iBa\t\u0003(5\u0011!q\u0004\u0006\u0005\u0005C\ti!\u0001\u0003vi&d\u0017\u0002\u0002B\u0013\u0005?\u0011A\u0001T5tiB1!Q\u0004B\u0012\u0003KDqAa\u000b-\u0001\u0004\u0011i#\u0001\u0004tG\",W.\u0019\t\u0007\u0005;\u0011\u0019#!\n\t\u000f\tEB\u00061\u0001\u0003.\u00051\u0001.Z1eKJ\f\u0001b\u001d5po\"#V\n\u0014\u000b\u0004]\n]\u0002b\u0002B\u001d[\u0001\u0007\u0011Q]\u0001\fQRlGnQ8oi\u0016tG/A\u0007QsRDwN\\*fgNLwN\u001c\t\u0003->\u001a2aL#L)\t\u0011i$A\bde\u0016\fG/\u001a$bW\u0016\u001c\u0006.\u001a7m)\u0019\u00119Ea\u0015\u0003XA!!\u0011\nB(\u001b\t\u0011YE\u0003\u0003\u0003N\u00055\u0011AA5p\u0013\u0011\u0011\tFa\u0013\u0003\t\u0019KG.\u001a\u0005\b\u0005+\n\u0004\u0019AA\u0013\u0003\u0019\u00198M]5qi\"I!\u0011L\u0019\u0011\u0002\u0003\u0007\u0011QE\u0001\tM&dW\rV=qK\u0006I2M]3bi\u00164\u0015m[3TQ\u0016dG\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yF\u000b\u0003\u0002&\t\u00054F\u0001B2!\u0011\u0011)Ga\u001c\u000e\u0005\t\u001d$\u0002\u0002B5\u0005W\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t5t)\u0001\u0006b]:|G/\u0019;j_:LAA!\u001d\u0003h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0015ALH\u000f[8o!\u0006$\b\u000e")
public class PythonSession
implements Logging {
    private final ExecutionContextExecutorService executor;
    private EngineExecutionContext engineExecutionContext;
    private GatewayServer gatewayServer;
    private Process process;
    private Promise<String> promise;
    private boolean pythonScriptInitialized;
    private final RsOutputStream outputStream;
    private final byte[] queryLock;
    private String code;
    private Option<String> pid;
    private final String pythonDefaultVersion;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        PythonSession pythonSession = this;
        synchronized (pythonSession) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ExecutionContextExecutorService executor() {
        return this.executor;
    }

    private EngineExecutionContext engineExecutionContext() {
        return this.engineExecutionContext;
    }

    private void engineExecutionContext_$eq(EngineExecutionContext x$1) {
        this.engineExecutionContext = x$1;
    }

    private GatewayServer gatewayServer() {
        return this.gatewayServer;
    }

    private void gatewayServer_$eq(GatewayServer x$1) {
        this.gatewayServer = x$1;
    }

    private Process process() {
        return this.process;
    }

    private void process_$eq(Process x$1) {
        this.process = x$1;
    }

    private boolean pythonScriptInitialized() {
        return this.pythonScriptInitialized;
    }

    private void pythonScriptInitialized_$eq(boolean x$1) {
        this.pythonScriptInitialized = x$1;
    }

    private RsOutputStream outputStream() {
        return this.outputStream;
    }

    private byte[] queryLock() {
        return this.queryLock;
    }

    private String code() {
        return this.code;
    }

    private void code_$eq(String x$1) {
        this.code = x$1;
    }

    private Option<String> pid() {
        return this.pid;
    }

    private void pid_$eq(Option<String> x$1) {
        this.pid = x$1;
    }

    private String pythonDefaultVersion() {
        return this.pythonDefaultVersion;
    }

    private String getPyVersion() {
        if (EngineConnServer$.MODULE$.getEngineCreationContext().getOptions() != null) {
            return EngineConnServer$.MODULE$.getEngineCreationContext().getOptions().getOrDefault(EngineConnPluginConf$.MODULE$.PYTHON_VERSION_KEY(), "python");
        }
        return (String)PythonEngineConfiguration$.MODULE$.PYTHON_VERSION().getValue();
    }

    public void init() {
    }

    public void setEngineExecutionContext(EngineExecutionContext engineExecutorContext) {
        EngineExecutionContext engineExecutionContext = engineExecutorContext;
        EngineExecutionContext engineExecutionContext2 = this.engineExecutionContext();
        if (engineExecutionContext == null ? engineExecutionContext2 != null : !engineExecutionContext.equals(engineExecutionContext2)) {
            this.engineExecutionContext_$eq(engineExecutorContext);
            this.outputStream().reset(this.engineExecutionContext());
            this.outputStream().ready();
            return;
        }
    }

    private void initGateway() {
        String userDefinePythonVersion = (String)new Some((Object)this.pythonDefaultVersion()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "python");
        this.logger().info(new java.lang.StringBuilder(34).append("System userDefinePythonVersion => ").append(userDefinePythonVersion).toString());
        String pythonExec = "python3".equalsIgnoreCase(userDefinePythonVersion) ? (String)PythonEngineConfiguration$.MODULE$.PYTHON_VERSION().getValue() : "python";
        this.logger().info(new java.lang.StringBuilder(14).append("pythonExec => ").append(pythonExec).toString());
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        int port2 = port;
        this.gatewayServer_$eq(new GatewayServer((Object)this, port2));
        this.gatewayServer().start();
        this.logger().info(new java.lang.StringBuilder(30).append("Python executor file path is: ").append(this.getClass().getClassLoader().getResource("python/python.py").toURI()).toString());
        StringBuilder pythonClasspath = new StringBuilder(PythonSession$.MODULE$.pythonPath());
        String pyFiles = (String)PythonEngineConfiguration$.MODULE$.PYTHON_PATH().getValue(EngineConnServer$.MODULE$.getEngineCreationContext().getOptions());
        this.logger().info(new java.lang.StringBuilder(11).append("pyFiles => ").append(pyFiles).toString());
        Object object = StringUtils.isNotEmpty((CharSequence)pyFiles) ? pythonClasspath.$plus$plus$eq(File.pathSeparator).$plus$plus$eq(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pyFiles.split(","))).mkString(File.pathSeparator)) : BoxedUnit.UNIT;
        CommandLine cmd = CommandLine.parse((String)pythonExec);
        cmd.addArgument(PythonSession$.MODULE$.createFakeShell("python/python.py", PythonSession$.MODULE$.createFakeShell$default$2()).getAbsolutePath(), false);
        cmd.addArgument(Integer.toString(port2), false);
        cmd.addArgument(pythonClasspath.toString(), false);
        java.util.List cmdList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd.toStrings())).toList()).asJava();
        ProcessBuilder builder = new ProcessBuilder(cmdList);
        Map<String, String> env = builder.environment();
        env.put("PYTHONPATH", pythonClasspath.toString());
        env.put("PYTHONUNBUFFERED", "YES");
        env.put("PYTHON_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)port2)));
        this.logger().info(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(builder.command()).asScala()).mkString(" "));
        builder.redirectErrorStream(true);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        this.process_$eq(builder.start());
        Utils$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.close();
            Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.pid().foreach((Function1 & Serializable & scala.Serializable)p -> Utils$.MODULE$.exec((String[])((Object[])new String[]{"kill", "-9", p}), 3000L)), this.logger());
        });
        Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int exitCode = this.process().waitFor();
            this.logger().info(new java.lang.StringBuilder(42).append("PythonExecutor has stopped with exit code ").append(exitCode).toString());
            return Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
                if ($this.promise != null && !$this.promise.isCompleted()) {
                    return $this.promise.failure((Throwable)((Object)new ExecuteException(LinkisPythonErrorCodeSummary.PYSPARK_PROCESSS_STOPPED.getErrorCode(), LinkisPythonErrorCodeSummary.PYSPARK_PROCESSS_STOPPED.getErrorDesc())));
                }
                return BoxedUnit.UNIT;
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close());
        }, (ExecutionContext)this.executor());
        Utils$.MODULE$.waitUntil((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.pythonScriptInitialized(), (Duration)((TimeType)PythonEngineConfiguration$.MODULE$.PYTHON_LANGUAGE_REPL_INIT_TIME().getValue()).toDuration());
    }

    public void lazyInitGateway() {
        if (this.process() == null) {
            PythonSession pythonSession = this;
            synchronized (pythonSession) {
                if (this.process() == null) {
                    Utils$.MODULE$.tryThrow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.initGateway(), (Function1 & Serializable & scala.Serializable)t -> {
                        this.logger().error("initialize python executor failed, please ask administrator for help!", t);
                        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close(), this.logger());
                        throw t;
                    });
                }
            }
            return;
        }
    }

    public void execute(String code) {
        block12: {
            if (!this.pythonScriptInitialized()) {
                throw new IllegalStateException("PythonSession process cannot be initialized, please ask administrator for help.");
            }
            this.promise = Promise$.MODULE$.apply();
            this.code_$eq(Kind$.MODULE$.getRealCode(code));
            byte[] byArray = this.queryLock();
            synchronized (byArray) {
                this.queryLock().notify();
            }
            try {
                try {
                    Await$.MODULE$.result((Awaitable)this.promise.future(), (Duration)Duration$.MODULE$.Inf());
                }
                catch (Throwable t) {
                    String x$1 = t.getMessage();
                    int x$2 = ExecuteException$.MODULE$.$lessinit$greater$default$1();
                    ExecuteException exception = new ExecuteException(x$2, x$1);
                    exception.initCause(t);
                    throw t;
                }
            }
            catch (Throwable throwable) {
                this.outputStream().flush();
                String outStr = this.outputStream().toString();
                if (StringUtils.isNotBlank((CharSequence)outStr)) {
                    Record[] output = (Record[])Utils$.MODULE$.tryQuietly((Function0 & Serializable & scala.Serializable)() -> ResultSetWriter$.MODULE$.getRecordByRes(outStr, (long)BoxesRunTime.unboxToInt((Object)PythonEngineConfiguration$.MODULE$.PYTHON_CONSOLE_OUTPUT_LINE_LIMIT().getValue())));
                    String res = output != null ? output.toString() : "";
                    this.logger().info(new java.lang.StringBuilder(13).append("result is {").append(res).append("} ").toString());
                    if (StringUtils.isNotBlank((CharSequence)res)) {
                        this.engineExecutionContext().appendStdout(res);
                    }
                }
                throw throwable;
            }
            this.outputStream().flush();
            String outStr = this.outputStream().toString();
            if (!StringUtils.isNotBlank((CharSequence)outStr)) break block12;
            Record[] output = (Record[])Utils$.MODULE$.tryQuietly((Function0 & Serializable & scala.Serializable)() -> ResultSetWriter$.MODULE$.getRecordByRes(outStr, (long)BoxesRunTime.unboxToInt((Object)PythonEngineConfiguration$.MODULE$.PYTHON_CONSOLE_OUTPUT_LINE_LIMIT().getValue())));
            String res = output != null ? output.toString() : "";
            this.logger().info(new java.lang.StringBuilder(13).append("result is {").append(res).append("} ").toString());
            if (StringUtils.isNotBlank((CharSequence)res)) {
                this.engineExecutionContext().appendStdout(res);
            }
        }
    }

    public void onPythonScriptInitialized(int pid) {
        this.pid_$eq((Option<String>)new Some((Object)Integer.toString(pid)));
        this.pythonScriptInitialized_$eq(true);
        this.logger().info(new java.lang.StringBuilder(48).append("Python executor has been initialized with pid(").append(pid).append(").").toString());
    }

    public PythonInterpretRequest getStatements() {
        byte[] byArray = this.queryLock();
        synchronized (byArray) {
            while (this.code() == null) {
                this.queryLock().wait();
            }
        }
        PythonInterpretRequest request = new PythonInterpretRequest(this.code());
        this.code_$eq(null);
        return request;
    }

    public Promise<String> setStatementsFinished(String out, boolean error) {
        this.logger().info(new java.lang.StringBuilder(51).append("A python code finished, has some errors happened? ").append(error).append(".").toString());
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(10L), this.logger());
        if (!error) {
            return this.promise.success((Object)this.outputStream().toString());
        }
        if (this.promise.isCompleted()) {
            this.logger().info("promise is completed and should start another python gateway");
            this.close();
            return null;
        }
        return this.promise.failure((Throwable)((Object)new PythonExecuteError(LinkisPythonErrorCodeSummary.PYTHON_EXECUTE_ERROR.getErrorCode(), out)));
    }

    public void appendOutput(String message) {
        if (!this.pythonScriptInitialized()) {
            this.logger().info(message);
            return;
        }
        this.outputStream().write(message.getBytes("utf-8"));
    }

    public void appendErrorOutput(String message) {
        if (!this.pythonScriptInitialized()) {
            this.logger().info(message);
            return;
        }
        this.logger().error(message);
        this.engineExecutionContext().appendStdout(new java.lang.StringBuilder(16).append("errorMessage is ").append(message).toString());
    }

    public void printLog(Object log) {
        if (this.engineExecutionContext() != null) {
            this.engineExecutionContext().appendStdout(new java.lang.StringBuilder(32).append("+++++++++++++++\n").append(log.toString()).append("\n+++++++++++++++").toString());
            return;
        }
        this.logger().warn("engine context is null can not send log");
    }

    public void close() {
        Object object;
        this.logger().info("python executor ready to close");
        if (this.process() != null) {
            if (this.gatewayServer() != null) {
                Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.gatewayServer().shutdown(), this.logger());
                this.gatewayServer_$eq(null);
            }
            IOUtils.closeQuietly((OutputStream)this.outputStream());
            object = Utils$.MODULE$.tryAndErrorMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.pid().foreach((Function1 & Serializable & scala.Serializable)p -> {
                    PythonSession.$anonfun$close$3(this, p);
                    return BoxedUnit.UNIT;
                });
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.process().destroy());
                this.process_$eq(null);
                this.pythonScriptInitialized_$eq(false);
            }, "process close failed", this.logger());
        } else {
            object = BoxedUnit.UNIT;
        }
        this.logger().info("python executor Finished to close");
    }

    public Kind getKind() {
        return new Python();
    }

    public DataType changeDT(String dt) {
        String string = dt;
        if ("int".equals(string) ? true : ("int16".equals(string) ? true : ("int32".equals(string) ? true : "int64".equals(string)))) {
            return IntType$.MODULE$;
        }
        if ("float".equals(string) ? true : ("float16".equals(string) ? true : ("float32".equals(string) ? true : "float64".equals(string)))) {
            return FloatType$.MODULE$;
        }
        if ("double".equals(string)) {
            return DoubleType$.MODULE$;
        }
        if ("bool".equals(string)) {
            return BooleanType$.MODULE$;
        }
        if ("datetime64[ns]".equals(string) ? true : ("datetime64[ns,tz]".equals(string) ? true : "timedelta[ns]".equals(string))) {
            return TimestampType$.MODULE$;
        }
        if ("category".equals(string) ? true : "object".equals(string)) {
            return StringType$.MODULE$;
        }
        return StringType$.MODULE$;
    }

    public void showDF(java.util.List<java.util.List<Object>> data, java.util.List<String> schema, java.util.List<String> header) {
        ResultSetWriter writer = this.engineExecutionContext().createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE());
        int length = schema.size() - 1;
        ObjectRef list = ObjectRef.create((Object)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Column col = new Column((String)header.get(i), this.changeDT((String)schema.get(i)), null);
            list$1.elem = (List)((List)list$1.elem).$colon$plus((Object)col, List$.MODULE$.canBuildFrom());
        });
        TableMetaData metaData = new TableMetaData((Column[])((List)list.elem).toArray(ClassTag$.MODULE$.apply(Column.class)));
        writer.addMetaData((MetaData)metaData);
        int size = data.size() - 1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> writer.addRecord((Record)new TableRecord((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)data.get(i)).asScala()).toArray(ClassTag$.MODULE$.Any()))));
        this.engineExecutionContext().sendResultSet(writer);
    }

    public void showHTML(Object htmlContent) {
        long startTime = System.currentTimeMillis();
        ResultSetWriter writer = this.engineExecutionContext().createResultSetWriter(ResultSetFactory$.MODULE$.HTML_TYPE());
        LineMetaData metaData = new LineMetaData(null);
        writer.addMetaData((MetaData)metaData);
        writer.addRecord((Record)new LineRecord(htmlContent.toString()));
        this.logger().warn(new java.lang.StringBuilder(28).append("Time taken: ").append(ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))).append(", done with html").toString());
        this.engineExecutionContext().sendResultSet(writer);
    }

    public static final /* synthetic */ void $anonfun$close$3(PythonSession $this, String p) {
        $this.logger().info(new java.lang.StringBuilder(45).append("Try to kill pyspark process with: [kill -15 ").append(p).append("]").toString());
        GovernanceUtils$.MODULE$.killProcess(String.valueOf(p), new java.lang.StringBuilder(26).append("kill pyspark process,pid: ").append($this.pid()).toString(), false);
    }

    public PythonSession() {
        Logging.$init$((Logging)this);
        this.executor = Utils$.MODULE$.newCachedExecutionContext(5, "Python-Session-Thread-", Utils$.MODULE$.newCachedExecutionContext$default$3());
        this.pythonScriptInitialized = false;
        this.outputStream = new RsOutputStream();
        this.queryLock = new byte[0];
        this.pid = None$.MODULE$;
        this.pythonDefaultVersion = this.getPyVersion();
    }
}

