/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.execution;

import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorCodeSummary$;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorException;
import org.apache.linkis.orchestrator.execution.AsyncTaskResponse;
import org.apache.linkis.orchestrator.execution.Execution;
import org.apache.linkis.orchestrator.execution.ExecutionTask;
import org.apache.linkis.orchestrator.execution.TaskConsumer;
import org.apache.linkis.orchestrator.execution.TaskManager;
import org.apache.linkis.orchestrator.execution.TaskResponse;
import org.apache.linkis.orchestrator.execution.TaskScheduler;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M3Q\u0001C\u0005\u0002\u0002QAQa\n\u0001\u0005\u0002!BqA\u000b\u0001C\u0002\u001b\u00051\u0006C\u00040\u0001\t\u0007i\u0011\u0001\u0019\t\u000fQ\u0002!\u0019!D\u0001k!)\u0011\b\u0001C\u0001u!)a\b\u0001C!\u007f!)Q\n\u0001C!\u001d\n\t\u0012IY:ue\u0006\u001cG/\u0012=fGV$\u0018n\u001c8\u000b\u0005)Y\u0011!C3yK\u000e,H/[8o\u0015\taQ\"\u0001\u0007pe\u000eDWm\u001d;sCR|'O\u0003\u0002\u000f\u001f\u00051A.\u001b8lSNT!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u00167}\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f\u001e\u001b\u0005I\u0011B\u0001\u0010\n\u0005%)\u00050Z2vi&|g\u000e\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u0005)Q\u000f^5mg*\u0011A%D\u0001\u0007G>lWn\u001c8\n\u0005\u0019\n#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"\u0001\b\u0001\u0002\u001bQ\f7o[*dQ\u0016$W\u000f\\3s+\u0005a\u0003C\u0001\u000f.\u0013\tq\u0013BA\u0007UCN\\7k\u00195fIVdWM]\u0001\fi\u0006\u001c8.T1oC\u001e,'/F\u00012!\ta\"'\u0003\u00024\u0013\tYA+Y:l\u001b\u0006t\u0017mZ3s\u00031!\u0018m]6D_:\u001cX/\\3s+\u00051\u0004C\u0001\u000f8\u0013\tA\u0014B\u0001\u0007UCN\\7i\u001c8tk6,'/A\u0003ti\u0006\u0014H\u000fF\u0001<!\t1B(\u0003\u0002>/\t!QK\\5u\u0003\u001d)\u00070Z2vi\u0016$\"\u0001Q\"\u0011\u0005q\t\u0015B\u0001\"\n\u00051!\u0016m]6SKN\u0004xN\\:f\u0011\u0015!e\u00011\u0001F\u00031\u0011xn\u001c;Fq\u0016\u001cG+Y:l!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0005qQf\u001c\u0018nY1m\u0015\tQ5\"A\u0003qY\u0006t7/\u0003\u0002M\u000f\nAQ\t_3d)\u0006\u001c8.\u0001\u0007fq\u0016\u001cW\u000f^3Bgft7\r\u0006\u0002P%B\u0011A\u0004U\u0005\u0003#&\u0011\u0011#Q:z]\u000e$\u0016m]6SKN\u0004xN\\:f\u0011\u0015!u\u00011\u0001F\u0001")
public abstract class AbstractExecution
implements Execution,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AbstractExecution abstractExecution = this;
        synchronized (abstractExecution) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public abstract TaskScheduler taskScheduler();

    public abstract TaskManager taskManager();

    public abstract TaskConsumer taskConsumer();

    public void start() {
        this.logger().info("execution start");
        this.taskScheduler().start();
        this.taskConsumer().init(this);
        this.taskConsumer().start();
    }

    @Override
    public TaskResponse execute(ExecTask rootExecTask) {
        ExecutionTask executionTask = this.taskManager().putExecTask(rootExecTask);
        executionTask.waitForCompleted();
        return executionTask.getResponse();
    }

    @Override
    public AsyncTaskResponse executeAsync(ExecTask rootExecTask) {
        if (rootExecTask == null) {
            throw new OrchestratorErrorException(OrchestratorErrorCodeSummary$.MODULE$.EXECUTION_ERROR_CODE(), "physicalPlan is null");
        }
        ExecutionTask executionTask = this.taskManager().putExecTask(rootExecTask);
        return new AsyncTaskResponse(null, executionTask){
            private final ExecutionTask executionTask$1;

            public void notifyMe(Function1<TaskResponse, BoxedUnit> listener) {
                this.executionTask$1.notifyMe(listener);
            }

            public TaskResponse waitForCompleted() {
                this.executionTask$1.waitForCompleted();
                return this.executionTask$1.getResponse();
            }
            {
                this.executionTask$1 = executionTask$1;
            }
        };
    }

    public AbstractExecution() {
        Logging.$init$((Logging)this);
    }
}

