/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.strategy;

import java.io.Serializable;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.orchestrator.core.ResultSet;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorCodeSummary$;
import org.apache.linkis.orchestrator.execution.ArrayResultSetTaskResponse;
import org.apache.linkis.orchestrator.execution.SucceedTaskResponse;
import org.apache.linkis.orchestrator.execution.TaskResponse;
import org.apache.linkis.orchestrator.execution.impl.DefaultFailedTaskResponse;
import org.apache.linkis.orchestrator.execution.impl.DefaultResultSetTaskResponse;
import org.apache.linkis.orchestrator.plans.logical.EndJobTaskDesc;
import org.apache.linkis.orchestrator.plans.logical.StartJobTaskDesc;
import org.apache.linkis.orchestrator.plans.logical.TaskDesc;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.plans.physical.JobExecTask;
import org.apache.linkis.orchestrator.plans.physical.ReheatableExecTask;
import org.apache.linkis.orchestrator.strategy.ExecTaskStatusInfo;
import org.apache.linkis.orchestrator.strategy.ResultSetExecTask;
import org.apache.linkis.orchestrator.strategy.StatusInfoExecTask;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000153Aa\u0002\u0005\u0001'!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u00030\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015q\u0004\u0001\"\u0011@\u0011\u00151\u0005\u0001\"\u0015H\u0011\u0015A\u0005\u0001\"\u0011J\u0005e9\u0015\r\u001e5feN#(/\u0019;fOfTuNY#yK\u000e$\u0016m]6\u000b\u0005%Q\u0011\u0001C:ue\u0006$XmZ=\u000b\u0005-a\u0011\u0001D8sG\",7\u000f\u001e:bi>\u0014(BA\u0007\u000f\u0003\u0019a\u0017N\\6jg*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u000b\u001d?\r2\u0003CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003!\u0001\b._:jG\u0006d'BA\r\u000b\u0003\u0015\u0001H.\u00198t\u0013\tYbCA\u0006K_\n,\u00050Z2UCN\\\u0007CA\u000b\u001e\u0013\tqbC\u0001\nSK\",\u0017\r^1cY\u0016,\u00050Z2UCN\\\u0007C\u0001\u0011\"\u001b\u0005A\u0011B\u0001\u0012\t\u0005E\u0011Vm];miN+G/\u0012=fGR\u000b7o\u001b\t\u0003A\u0011J!!\n\u0005\u0003%M#\u0018\r^;t\u0013:4w.\u0012=fGR\u000b7o\u001b\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nQ!\u001e;jYNT!a\u000b\u0007\u0002\r\r|W.\\8o\u0013\ti\u0003FA\u0004M_\u001e<\u0017N\\4\u0002\u000fA\f'/\u001a8ugB\u0019\u0001gM\u001b\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012Q!\u0011:sCf\u0004\"!\u0006\u001c\n\u0005]2\"\u0001C#yK\u000e$\u0016m]6\u0002\u0011\rD\u0017\u000e\u001c3sK:\fa\u0001P5oSRtDcA\u001e={A\u0011\u0001\u0005\u0001\u0005\u0006]\r\u0001\ra\f\u0005\u0006q\r\u0001\raL\u0001\bKb,7-\u001e;f)\u0005\u0001\u0005CA!E\u001b\u0005\u0011%BA\"\u000b\u0003%)\u00070Z2vi&|g.\u0003\u0002F\u0005\naA+Y:l%\u0016\u001c\bo\u001c8tK\u00069a.Z<O_\u0012,G#A\u001b\u0002\u0015\r\fg.\u0012=fGV$X-F\u0001K!\t\u00014*\u0003\u0002Mc\t9!i\\8mK\u0006t\u0007")
public class GatherStrategyJobExecTask
extends JobExecTask
implements ReheatableExecTask,
ResultSetExecTask,
StatusInfoExecTask {
    private Logger logger;
    private boolean org$apache$linkis$orchestrator$plans$physical$ReheatableExecTask$$isReheating;
    private volatile boolean bitmap$0;

    @Override
    public void addExecTaskStatusInfo(ExecTaskStatusInfo execTaskStatusInfo) {
        StatusInfoExecTask.addExecTaskStatusInfo$(this, execTaskStatusInfo);
    }

    @Override
    public Map<String, ExecTaskStatusInfo> getChildrenExecTaskStatusInfo() {
        return StatusInfoExecTask.getChildrenExecTaskStatusInfo$(this);
    }

    @Override
    public String parseChildrenErrorInfo(Map<String, ExecTaskStatusInfo> errorExecTasks) {
        return StatusInfoExecTask.parseChildrenErrorInfo$(this, errorExecTasks);
    }

    @Override
    public Option<Map<String, ExecTaskStatusInfo>> getErrorChildrenExecTasks() {
        return StatusInfoExecTask.getErrorChildrenExecTasks$(this);
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public void addResultSet(ArrayResultSetTaskResponse resultSetTaskResponse) {
        ResultSetExecTask.addResultSet$(this, resultSetTaskResponse);
    }

    @Override
    public void removeResultSet() {
        ResultSetExecTask.removeResultSet$(this);
    }

    @Override
    public Map<String, ArrayResultSetTaskResponse> getChildrenResultSet() {
        return ResultSetExecTask.getChildrenResultSet$(this);
    }

    @Override
    public void setReheating() {
        ReheatableExecTask.setReheating$(this);
    }

    @Override
    public void setReheated() {
        ReheatableExecTask.setReheated$(this);
    }

    @Override
    public boolean getReheating() {
        return ReheatableExecTask.getReheating$(this);
    }

    private Logger logger$lzycompute() {
        GatherStrategyJobExecTask gatherStrategyJobExecTask = this;
        synchronized (gatherStrategyJobExecTask) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public boolean org$apache$linkis$orchestrator$plans$physical$ReheatableExecTask$$isReheating() {
        return this.org$apache$linkis$orchestrator$plans$physical$ReheatableExecTask$$isReheating;
    }

    @Override
    public void org$apache$linkis$orchestrator$plans$physical$ReheatableExecTask$$isReheating_$eq(boolean x$1) {
        this.org$apache$linkis$orchestrator$plans$physical$ReheatableExecTask$$isReheating = x$1;
    }

    @Override
    public TaskResponse execute() {
        TaskDesc taskDesc = this.getTaskDesc();
        if (taskDesc instanceof StartJobTaskDesc) {
            return super.execute();
        }
        if (taskDesc instanceof EndJobTaskDesc) {
            SucceedTaskResponse succeedTaskResponse;
            if (this.getPhysicalContext().isCompleted()) {
                String msg = new StringBuilder(54).append("PhysicalContext is completed, Job").append(this.getIDInfo()).append(" will be mark Failed ").toString();
                this.logger().info(msg);
                return new DefaultFailedTaskResponse(null, msg){};
            }
            Option<Map<String, ExecTaskStatusInfo>> errorExecTasks = this.getErrorChildrenExecTasks();
            if (errorExecTasks.isDefined()) {
                String errorReason = this.parseChildrenErrorInfo((Map<String, ExecTaskStatusInfo>)((Map)errorExecTasks.get()));
                this.getPhysicalContext().markFailed(errorReason, null);
                return new DefaultFailedTaskResponse(errorReason, OrchestratorErrorCodeSummary$.MODULE$.STAGE_ERROR_CODE(), null);
            }
            Map<String, ArrayResultSetTaskResponse> execIdToResponse = this.getChildrenResultSet();
            if (execIdToResponse != null && execIdToResponse.nonEmpty()) {
                ArrayBuffer resultSets = new ArrayBuffer();
                execIdToResponse.values().foreach((Function1 & Serializable & scala.Serializable)response -> resultSets.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])response.getResultSets()))));
                DefaultResultSetTaskResponse response2 = new DefaultResultSetTaskResponse((ResultSet[])resultSets.toArray(ClassTag$.MODULE$.apply(ResultSet.class)));
                succeedTaskResponse = response2;
            } else {
                succeedTaskResponse = new SucceedTaskResponse(null){};
            }
            SucceedTaskResponse response3 = succeedTaskResponse;
            this.logger().debug(new StringBuilder(59).append("Job").append(this.getIDInfo()).append(" end execute finished, now to mark executionTask succeed").toString());
            this.getPhysicalContext().markSucceed(response3);
            return response3;
        }
        throw new MatchError((Object)taskDesc);
    }

    @Override
    public ExecTask newNode() {
        GatherStrategyJobExecTask task = new GatherStrategyJobExecTask(null, null);
        task.setTaskDesc(this.getTaskDesc());
        return task;
    }

    @Override
    public boolean canExecute() {
        return !this.getReheating();
    }

    public GatherStrategyJobExecTask(ExecTask[] parents, ExecTask[] children) {
        super(parents, children);
        ReheatableExecTask.$init$(this);
        ResultSetExecTask.$init$(this);
        Logging.$init$((Logging)this);
        StatusInfoExecTask.$init$(this);
    }
}

