/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.common.util;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.ByteType;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.engineplugin.common.conf.EngineConnPluginConf$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class NodeResourceUtils$ {
    public static NodeResourceUtils$ MODULE$;
    private Logger LOG;
    private final String JAVA_MEMORY_UNIT_G;
    private final String JAVA_MEMORY_UNIT_M;
    private final String JAVA_MEMORY_UNIT_K;
    private final String JAVA_MEMORY_UNIT_B;
    private String JAVA_MEMORY_REGEX;

    static {
        new NodeResourceUtils$();
    }

    private Logger LOG() {
        return this.LOG;
    }

    private void LOG_$eq(Logger x$1) {
        this.LOG = x$1;
    }

    public String JAVA_MEMORY_UNIT_G() {
        return this.JAVA_MEMORY_UNIT_G;
    }

    public String JAVA_MEMORY_UNIT_M() {
        return this.JAVA_MEMORY_UNIT_M;
    }

    public String JAVA_MEMORY_UNIT_K() {
        return this.JAVA_MEMORY_UNIT_K;
    }

    public String JAVA_MEMORY_UNIT_B() {
        return this.JAVA_MEMORY_UNIT_B;
    }

    public String JAVA_MEMORY_REGEX() {
        return this.JAVA_MEMORY_REGEX;
    }

    public void JAVA_MEMORY_REGEX_$eq(String x$1) {
        this.JAVA_MEMORY_REGEX = x$1;
    }

    public void appendMemoryUnitIfMissing(Map<String, String> properties) {
        Objects.requireNonNull(properties);
        if (properties.containsKey(EngineConnPluginConf$.MODULE$.JAVA_ENGINE_REQUEST_MEMORY().key())) {
            String settingClientMemory = properties.get(EngineConnPluginConf$.MODULE$.JAVA_ENGINE_REQUEST_MEMORY().key());
            if (StringUtils.isBlank((CharSequence)settingClientMemory)) {
                properties.remove(EngineConnPluginConf$.MODULE$.JAVA_ENGINE_REQUEST_MEMORY().key());
                return;
            }
            properties.put(EngineConnPluginConf$.MODULE$.JAVA_ENGINE_REQUEST_MEMORY().key(), this.formatJavaOptionMemoryWithDefaultUnitG(settingClientMemory));
            return;
        }
    }

    public String formatJavaOptionMemory(String memory, String defaultUnit) {
        Predef$.MODULE$.assert(StringUtils.isNotBlank((CharSequence)memory));
        String memoryTmp = memory.toUpperCase(Locale.getDefault()).trim();
        if (!Pattern.matches(this.JAVA_MEMORY_REGEX(), memoryTmp)) {
            this.LOG().error("the java option memory: '{}' format error, use default 1G replaced", new Object[]{memory});
            return new StringBuilder(11).append(1).append(this.JAVA_MEMORY_UNIT_G()).toString();
        }
        if (memoryTmp.endsWith(this.JAVA_MEMORY_UNIT_G()) || memoryTmp.endsWith(this.JAVA_MEMORY_UNIT_M()) || memoryTmp.endsWith(this.JAVA_MEMORY_UNIT_K())) {
            return memoryTmp;
        }
        if (memoryTmp.endsWith(this.JAVA_MEMORY_UNIT_B())) {
            return memoryTmp.substring(0, memoryTmp.length() - 1);
        }
        return new StringBuilder(0).append(memoryTmp).append(defaultUnit).toString();
    }

    public String formatJavaOptionMemoryWithDefaultUnitG(String memory) {
        return this.formatJavaOptionMemory(memory, this.JAVA_MEMORY_UNIT_G());
    }

    public LoadInstanceResource applyAsLoadInstanceResource(Map<String, String> properties) {
        this.appendMemoryUnitIfMissing(properties);
        return new LoadInstanceResource(((ByteType)EngineConnPluginConf$.MODULE$.JAVA_ENGINE_REQUEST_MEMORY().getValue(properties)).toLong(), BoxesRunTime.unboxToInt((Object)EngineConnPluginConf$.MODULE$.JAVA_ENGINE_REQUEST_CORES().getValue(properties)), EngineConnPluginConf$.MODULE$.JAVA_ENGINE_REQUEST_INSTANCE());
    }

    private NodeResourceUtils$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
        this.JAVA_MEMORY_UNIT_G = "G";
        this.JAVA_MEMORY_UNIT_M = "M";
        this.JAVA_MEMORY_UNIT_K = "K";
        this.JAVA_MEMORY_UNIT_B = "B";
        this.JAVA_MEMORY_REGEX = "^[1-9]\\d*[gGmMkK]?[bB]?$";
    }
}

