/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.springframework.cloud.netflix.eureka.RestTemplateTimeoutProperties;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.lang.Nullable;

public class DefaultEurekaClientHttpRequestFactorySupplier
implements EurekaClientHttpRequestFactorySupplier {
    private final RestTemplateTimeoutProperties restTemplateTimeoutProperties;

    @Deprecated
    public DefaultEurekaClientHttpRequestFactorySupplier() {
        this.restTemplateTimeoutProperties = new RestTemplateTimeoutProperties();
    }

    public DefaultEurekaClientHttpRequestFactorySupplier(RestTemplateTimeoutProperties restTemplateTimeoutProperties) {
        this.restTemplateTimeoutProperties = restTemplateTimeoutProperties;
    }

    @Override
    public ClientHttpRequestFactory get(SSLContext sslContext, @Nullable HostnameVerifier hostnameVerifier) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (sslContext != null) {
            httpClientBuilder = httpClientBuilder.setSSLContext(sslContext);
        }
        if (hostnameVerifier != null) {
            httpClientBuilder = httpClientBuilder.setSSLHostnameVerifier(hostnameVerifier);
        }
        if (this.restTemplateTimeoutProperties != null) {
            httpClientBuilder.setDefaultRequestConfig(this.buildRequestConfig());
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        return requestFactory;
    }

    private RequestConfig buildRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(this.restTemplateTimeoutProperties.getConnectTimeout()).setConnectionRequestTimeout(this.restTemplateTimeoutProperties.getConnectRequestTimeout()).setSocketTimeout(this.restTemplateTimeoutProperties.getSocketTimeout()).build();
    }
}

