/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.governance.common.protocol.conf.TenantRequest;
import org.apache.linkis.governance.common.protocol.conf.TenantResponse;
import org.apache.linkis.manager.am.vo.ConfigVo;
import org.apache.linkis.rpc.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMUtils {
    private static Logger logger = LoggerFactory.getLogger(EMUtils.class);

    public static String getTenant(String username, String creator) {
        Sender sender = Sender.getSender((String)((String)Configuration.CLOUD_CONSOLE_CONFIGURATION_SPRING_APPLICATION_NAME().getValue()));
        TenantResponse response = (TenantResponse)sender.ask((Object)new TenantRequest(username, creator));
        if (StringUtils.isBlank((CharSequence)response.tenant()) && StringUtils.isBlank((CharSequence)(response = (TenantResponse)sender.ask((Object)new TenantRequest(username, "*"))).tenant())) {
            response = (TenantResponse)sender.ask((Object)new TenantRequest("*", creator));
        }
        return response.tenant();
    }

    public static List<ConfigVo> getUserConf(String username, String creator, String engineType) {
        ArrayList<ConfigVo> configlist = new ArrayList<ConfigVo>();
        try {
            String url = MessageFormat.format("/api/rest_j/v1/configuration/getFullTreesByAppName?creator={0}&engineType={1}", creator, engineType);
            HttpGet httpGet = new HttpGet(Configuration.getGateWayURL() + url);
            httpGet.addHeader("Token-User", username);
            httpGet.addHeader("Token-Code", (String)Configuration.LINKIS_TOKEN().getValue());
            String responseStr = EntityUtils.toString((HttpEntity)HttpClients.createDefault().execute((HttpUriRequest)httpGet).getEntity());
            JsonNode fullTree = new ObjectMapper().readTree(responseStr).get("data").get("fullTree");
            for (JsonNode node : fullTree) {
                JsonNode settingsList = node.get("settings");
                for (JsonNode key : settingsList) {
                    configlist.add(new ConfigVo(key.get("key").asText(), key.get("defaultValue").asText(), key.get("configValue").asText()));
                }
            }
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u7528\u6237\u914d\u7f6e\u4fe1\u606f\u5931\u8d25(Failed to obtain user configuration information)");
        }
        return configlist.stream().filter(confInfo -> {
            String configValue = confInfo.getConfigValue();
            String defaultValue = confInfo.getDefaultValue();
            return StringUtils.isNotBlank((CharSequence)configValue) && !configValue.equals("null") || StringUtils.isNotBlank((CharSequence)defaultValue) && !defaultValue.equals("null");
        }).collect(Collectors.toList());
    }

    public static String getConfValue(List<ConfigVo> configVoList, String confKey) {
        String confValue = "0";
        for (ConfigVo configVo : configVoList) {
            if (!configVo.getKey().equals(confKey) || !StringUtils.isBlank((CharSequence)(confValue = configVo.getConfigValue()))) continue;
            confValue = configVo.getDefaultValue();
        }
        return EMUtils.removeUnit(confValue);
    }

    public static String removeUnit(String input) {
        Pattern pattern = Pattern.compile("(\\d+)([gG])");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return input;
    }
}

