/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.conf;

import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.manager.common.entity.resource.Resource;

public enum ResourceStatus {
    normal,
    warn,
    critical;

    public static Float normalThreshold;
    public static Float warnThreshold;

    public static ResourceStatus measure(Resource leftResource, Resource maxResource) {
        if (leftResource != null && maxResource != null) {
            if (!leftResource.moreThan(maxResource.multiplied(warnThreshold.floatValue()))) {
                return critical;
            }
            if (!leftResource.moreThan(maxResource.multiplied(normalThreshold.floatValue()))) {
                return warn;
            }
            return normal;
        }
        return normal;
    }

    static {
        normalThreshold = (Float)CommonVars.apply((String)"wds.linkis.resourcemanager.resource.threashold.normal", (Object)Float.valueOf(0.5f)).getValue();
        warnThreshold = (Float)CommonVars.apply((String)"wds.linkis.resourcemanager.resource.threashold.warn", (Object)Float.valueOf(0.2f)).getValue();
    }
}

