/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.rm.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.common.exception.RMWarnException;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateRequest;
import org.apache.linkis.manager.rm.domain.RMLabelContainer;
import org.apache.linkis.manager.rm.exception.RMErrorCode;
import org.apache.linkis.manager.rm.external.service.ExternalResourceService;
import org.apache.linkis.manager.rm.external.yarn.YarnResourceIdentifier;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;

public final class AcrossClusterRulesJudgeUtils$
implements Logging {
    public static AcrossClusterRulesJudgeUtils$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new AcrossClusterRulesJudgeUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AcrossClusterRulesJudgeUtils$ acrossClusterRulesJudgeUtils$ = this;
        synchronized (acrossClusterRulesJudgeUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void targetClusterRuleCheck(YarnResource leftResource, YarnResource usedResource, YarnResource maxResource, YarnResource clusterMaxCapacity, YarnResource clusterUsedCapacity, int CPUThreshold, int MemoryThreshold, double CPUPercentageThreshold, double MemoryPercentageThreshold, double clusterCPUPercentageThreshold, double clusterMemoryPercentageThreshold) {
        if (leftResource != null && usedResource != null && maxResource != null && clusterMaxCapacity != null && clusterUsedCapacity != null) {
            double clusterUsedCPUPercentage = (double)clusterUsedCapacity.getQueueCores() / (double)clusterMaxCapacity.getQueueCores();
            double clusterUsedMemoryPercentage = (double)clusterUsedCapacity.getQueueMemory() / (double)clusterMaxCapacity.getQueueMemory();
            if (clusterUsedCPUPercentage >= clusterCPUPercentageThreshold || clusterUsedMemoryPercentage >= clusterMemoryPercentageThreshold) {
                throw new RMWarnException(RMErrorCode.ACROSS_CLUSTER_RULE_FAILED.getErrorCode(), new StringBuilder(110).append("clusterUsedCPUPercentage: ").append(clusterUsedCPUPercentage).append(", CPUPercentageThreshold: ").append(clusterCPUPercentageThreshold).append("clusterUsedMemoryPercentage: ").append(clusterUsedMemoryPercentage).append(", MemoryPercentageThreshold: ").append(clusterMemoryPercentageThreshold).toString());
            }
            long leftQueueMemory = leftResource.getQueueMemory() / (long)Math.pow(1024.0, 3.0);
            if (leftResource.getQueueCores() >= CPUThreshold && leftQueueMemory >= (long)MemoryThreshold) {
                double usedCPUPercentage = (double)usedResource.getQueueCores() / (double)maxResource.getQueueCores();
                double usedMemoryPercentage = (double)usedResource.getQueueMemory() / (double)maxResource.getQueueMemory();
                this.logger().info(new StringBuilder(135).append("cross cluster test in target rule check").append("usedCPUPercentage: ").append(usedCPUPercentage).append(", CPUPercentageThreshold: ").append(CPUPercentageThreshold).append("usedMemoryPercentage: ").append(usedMemoryPercentage).append(", MemoryPercentageThreshold: ").append(MemoryPercentageThreshold).toString());
                if (usedCPUPercentage >= CPUPercentageThreshold || usedMemoryPercentage >= MemoryPercentageThreshold) {
                    throw new RMWarnException(RMErrorCode.ACROSS_CLUSTER_RULE_FAILED.getErrorCode(), new StringBuilder(96).append("usedCPUPercentage: ").append(usedCPUPercentage).append(", CPUPercentageThreshold: ").append(CPUPercentageThreshold).append("usedMemoryPercentage: ").append(usedMemoryPercentage).append(", MemoryPercentageThreshold: ").append(MemoryPercentageThreshold).toString());
                }
                return;
            }
            throw new RMWarnException(RMErrorCode.ACROSS_CLUSTER_RULE_FAILED.getErrorCode(), new StringBuilder(78).append("leftResource.queueCores: ").append(leftResource.getQueueCores()).append(", CPUThreshold: ").append(CPUThreshold).append(",").append("leftQueueMemory: ").append(leftQueueMemory).append(", MemoryThreshold: ").append(MemoryThreshold).toString());
        }
    }

    public void originClusterRuleCheck(YarnResource usedResource, YarnResource maxResource, double CPUPercentageThreshold, double MemoryPercentageThreshold) {
        if (usedResource != null && maxResource != null) {
            double usedCPUPercentage = (double)usedResource.getQueueCores() / (double)maxResource.getQueueCores();
            double usedMemoryPercentage = (double)usedResource.getQueueMemory() / (double)maxResource.getQueueMemory();
            this.logger().info(new StringBuilder(135).append("cross cluster test in origin rule check").append("usedCPUPercentage: ").append(usedCPUPercentage).append(", CPUPercentageThreshold: ").append(CPUPercentageThreshold).append("usedMemoryPercentage: ").append(usedMemoryPercentage).append(", MemoryPercentageThreshold: ").append(MemoryPercentageThreshold).toString());
            if (usedCPUPercentage >= CPUPercentageThreshold || usedMemoryPercentage >= MemoryPercentageThreshold) {
                throw new RMWarnException(RMErrorCode.ACROSS_CLUSTER_RULE_FAILED.getErrorCode(), "origin cluster retry");
            }
            return;
        }
    }

    public void originClusterResourceCheck(EngineCreateRequest engineCreateRequest, Resource maxCapacity, Resource usedCapacity) {
        String acrossClusterTask = engineCreateRequest.getProperties().getOrDefault("acrossClusterTask", "false");
        String priorityCluster = (String)engineCreateRequest.getProperties().get("priorityCluster");
        if (StringUtils.isNotBlank((CharSequence)acrossClusterTask) && new StringOps(Predef$.MODULE$.augmentString(acrossClusterTask)).toBoolean() && StringUtils.isNotBlank((CharSequence)priorityCluster) && priorityCluster.equals("bdap")) {
            String originCPUPercentageThreshold = (String)engineCreateRequest.getProperties().get("originCPUPercentageThreshold");
            String originMemoryPercentageThreshold = (String)engineCreateRequest.getProperties().get("originMemoryPercentageThreshold");
            if (StringUtils.isNotBlank((CharSequence)originCPUPercentageThreshold) && StringUtils.isNotBlank((CharSequence)originMemoryPercentageThreshold)) {
                try {
                    this.originClusterRuleCheck((YarnResource)usedCapacity, (YarnResource)maxCapacity, new StringOps(Predef$.MODULE$.augmentString(originCPUPercentageThreshold)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(originMemoryPercentageThreshold)).toDouble());
                }
                catch (Exception ex) {
                    throw new RMWarnException(RMErrorCode.ACROSS_CLUSTER_RULE_FAILED.getErrorCode(), ex.getMessage());
                }
                return;
            }
            return;
        }
    }

    public void targetClusterResourceCheck(RMLabelContainer labelContainer, EngineCreateRequest engineCreateRequest, Resource maxCapacity, Resource usedCapacity, ExternalResourceService externalResourceService) {
        String acrossClusterTask = engineCreateRequest.getProperties().getOrDefault("acrossClusterTask", "false");
        String priorityCluster = (String)engineCreateRequest.getProperties().get("priorityCluster");
        if (StringUtils.isNotBlank((CharSequence)acrossClusterTask) && new StringOps(Predef$.MODULE$.augmentString(acrossClusterTask)).toBoolean() && StringUtils.isNotBlank((CharSequence)priorityCluster) && priorityCluster.equals("bdp")) {
            Resource leftResource = maxCapacity.minus(usedCapacity);
            String targetCPUThreshold = (String)engineCreateRequest.getProperties().get("targetCPUThreshold");
            String targetMemoryThreshold = (String)engineCreateRequest.getProperties().get("targetMemoryThreshold");
            String targetCPUPercentageThreshold = (String)engineCreateRequest.getProperties().get("targetCPUPercentageThreshold");
            String targetMemoryPercentageThreshold = (String)engineCreateRequest.getProperties().get("targetMemoryPercentageThreshold");
            double clusterCPUPercentageThreshold = AMConfiguration.ACROSS_CLUSTER_TOTAL_CPU_PERCENTAGE_THRESHOLD;
            double clusterMemoryPercentageThreshold = AMConfiguration.ACROSS_CLUSTER_TOTAL_MEMORY_PERCENTAGE_THRESHOLD;
            if (StringUtils.isNotBlank((CharSequence)targetCPUThreshold) && StringUtils.isNotBlank((CharSequence)targetMemoryThreshold) && StringUtils.isNotBlank((CharSequence)targetCPUPercentageThreshold) && StringUtils.isNotBlank((CharSequence)targetMemoryPercentageThreshold)) {
                NodeResource clusterYarnResource = externalResourceService.getResource(ResourceType.Yarn, labelContainer, new YarnResourceIdentifier("root"));
                Tuple2 tuple2 = new Tuple2((Object)clusterYarnResource.getMaxResource(), (Object)clusterYarnResource.getUsedResource());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Resource clusterMaxCapacity = (Resource)tuple2._1();
                Resource clusterUsedCapacity = (Resource)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)clusterMaxCapacity, (Object)clusterUsedCapacity);
                Resource clusterMaxCapacity2 = (Resource)tuple22._1();
                Resource clusterUsedCapacity2 = (Resource)tuple22._2();
                try {
                    this.targetClusterRuleCheck((YarnResource)leftResource, (YarnResource)usedCapacity, (YarnResource)maxCapacity, (YarnResource)clusterMaxCapacity2, (YarnResource)clusterUsedCapacity2, new StringOps(Predef$.MODULE$.augmentString(targetCPUThreshold)).toInt(), new StringOps(Predef$.MODULE$.augmentString(targetMemoryThreshold)).toInt(), new StringOps(Predef$.MODULE$.augmentString(targetCPUPercentageThreshold)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(targetMemoryPercentageThreshold)).toDouble(), clusterCPUPercentageThreshold, clusterMemoryPercentageThreshold);
                }
                catch (Exception ex) {
                    throw new RMWarnException(RMErrorCode.ACROSS_CLUSTER_RULE_FAILED.getErrorCode(), ex.getMessage());
                }
                return;
            }
            return;
        }
    }

    private AcrossClusterRulesJudgeUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

