/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry.endpoint;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

@Endpoint(id="serviceregistry")
public class ServiceRegistryEndpoint {
    private final ServiceRegistry serviceRegistry;
    private Registration registration;

    public ServiceRegistryEndpoint(ServiceRegistry<?> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    @WriteOperation
    public WebEndpointResponse<?> setStatus(String status) {
        Assert.notNull((Object)status, (String)"status may not by null");
        if (this.registration == null) {
            return new WebEndpointResponse((Object)"no registration found", HttpStatus.NOT_FOUND.value());
        }
        this.serviceRegistry.setStatus(this.registration, status);
        return new WebEndpointResponse();
    }

    @ReadOperation
    public WebEndpointResponse getStatus() {
        if (this.registration == null) {
            return new WebEndpointResponse((Object)"no registration found", HttpStatus.NOT_FOUND.value());
        }
        return new WebEndpointResponse(this.serviceRegistry.getStatus(this.registration));
    }
}

