/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.internal.shared;

import java.sql.DatabaseMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;

public final class SQLUtilities {
    private SQLUtilities() {
    }

    public static String getSimplifiedURL(DatabaseMetaData metadata) throws SQLException {
        int s2;
        String url = metadata.getURL();
        int s1 = url.indexOf(63);
        if (s1 < 0) {
            s1 = url.length();
        }
        if ((s2 = url.indexOf(59)) < 0) {
            s2 = url.length();
        }
        return url.substring(0, Math.min(s1, s2));
    }

    public static Boolean parseBoolean(String text) throws SQLException {
        if (text == null) {
            return null;
        }
        switch (text.length()) {
            case 0: {
                return null;
            }
            case 1: {
                switch (text.charAt(0)) {
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return Boolean.FALSE;
                    }
                    case '1': 
                    case 'T': 
                    case 'Y': 
                    case 't': 
                    case 'y': {
                        return Boolean.TRUE;
                    }
                }
                break;
            }
            default: {
                if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("yes")) {
                    return Boolean.TRUE;
                }
                if (!text.equalsIgnoreCase("false") && !text.equalsIgnoreCase("no")) break;
                return Boolean.FALSE;
            }
        }
        throw new SQLDataException(Errors.format((short)12, (Object)text, Boolean.class));
    }

    public static String escapeWildcards(String text, String escape) {
        if (text != null && !Strings.isNullOrEmpty((String)escape)) {
            char escapeChar = escape.charAt(0);
            StringBuilder buffer = null;
            int i = text.length();
            while (--i >= 0) {
                char c = text.charAt(i);
                if (c != '_' && c != '%' && (c != escapeChar || !text.startsWith(escape, i))) continue;
                if (buffer == null) {
                    buffer = new StringBuilder(text);
                }
                buffer.insert(i, escape);
            }
            if (buffer != null) {
                return buffer.toString();
            }
        }
        return text;
    }
}

