/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.InputRunResults;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.TriggerAfterKey;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.bucket.SingleBucketAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.opensearch.search.aggregations.support.AggregationPath;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.sort.SortOrder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/alerting/util/AggregationQueryRewriter;", "", "<init>", "()V", "Companion", "opensearch-alerting"})
public final class AggregationQueryRewriter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\rJ>\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000fJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/alerting/util/AggregationQueryRewriter$Companion;", "", "<init>", "()V", "rewriteQuery", "Lorg/opensearch/search/builder/SearchSourceBuilder;", "query", "prevResult", "Lorg/opensearch/commons/alerting/model/InputRunResults;", "triggers", "", "Lorg/opensearch/commons/alerting/model/Trigger;", "returnSampleDocs", "", "getAfterKeysFromSearchResponse", "", "", "Lorg/opensearch/commons/alerting/model/TriggerAfterKey;", "searchResponse", "Lorg/opensearch/action/search/SearchResponse;", "prevBucketLevelTriggerAfterKeys", "getSampleDocAggs", "Lorg/opensearch/search/aggregations/metrics/TopHitsAggregationBuilder;", "factory", "Lorg/opensearch/search/aggregations/bucket/composite/CompositeAggregationBuilder;", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nAggregationQueryRewriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AggregationQueryRewriter.kt\norg/opensearch/alerting/util/AggregationQueryRewriter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,171:1\n1869#2:172\n1869#2:173\n1870#2:178\n1870#2:179\n1869#2,2:180\n1374#2:182\n1460#2,2:183\n1374#2:185\n1460#2,5:186\n1462#2,3:191\n1869#2,2:194\n37#3:174\n36#3,3:175\n*S KotlinDebug\n*F\n+ 1 AggregationQueryRewriter.kt\norg/opensearch/alerting/util/AggregationQueryRewriter$Companion\n*L\n46#1:172\n76#1:173\n76#1:178\n46#1:179\n111#1:180,2\n153#1:182\n153#1:183,2\n154#1:185\n154#1:186,5\n153#1:191,3\n163#1:194,2\n80#1:174\n80#1:175,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SearchSourceBuilder rewriteQuery(@NotNull SearchSourceBuilder query, @Nullable InputRunResults prevResult, @NotNull List<? extends Trigger> triggers) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
            return this.rewriteQuery(query, prevResult, triggers, false);
        }

        @NotNull
        public final SearchSourceBuilder rewriteQuery(@NotNull SearchSourceBuilder query, @Nullable InputRunResults prevResult, @NotNull List<? extends Trigger> triggers, boolean returnSampleDocs) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
            Iterable $this$forEach$iv = triggers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Trigger trigger = (Trigger)element$iv;
                boolean bl = false;
                if (!(trigger instanceof BucketLevelTrigger)) continue;
                query.aggregation((PipelineAggregationBuilder)((BucketLevelTrigger)trigger).getBucketSelector());
                Object object = prevResult;
                if ((object != null && (object = object.getAggTriggersAfterKey()) != null ? (TriggerAfterKey)object.get(((BucketLevelTrigger)trigger).getId()) : null) == null) continue;
                AggregationPath parentBucketPath = AggregationPath.parse((String)((BucketLevelTrigger)trigger).getBucketSelector().getParentBucketPath());
                AggregatorFactories.Builder builder = query.aggregations();
                Intrinsics.checkNotNull((Object)builder, (String)"null cannot be cast to non-null type org.opensearch.search.aggregations.AggregatorFactories.Builder");
                Collection aggBuilders = builder.getAggregatorFactories();
                AggregationBuilder factory = null;
                int n = parentBucketPath.getPathElements().size();
                for (int i = 0; i < n; ++i) {
                    factory = null;
                    for (AggregationBuilder aggFactory : aggBuilders) {
                        if (!aggFactory.getName().equals(((AggregationPath.PathElement)parentBucketPath.getPathElements().get((int)i)).name)) continue;
                        aggBuilders = aggFactory.getSubAggregations();
                        factory = aggFactory;
                        break;
                    }
                    if (factory != null) continue;
                    throw new IllegalArgumentException("ParentBucketPath: " + parentBucketPath + " not found in input query results");
                }
                if (factory instanceof CompositeAggregationBuilder) {
                    if (returnSampleDocs) {
                        Set<String> docFieldTags = AlertingUtilsKt.parseSampleDocTags(CollectionsKt.listOf((Object)trigger));
                        List<TopHitsAggregationBuilder> sampleDocsAgg = Companion.getSampleDocAggs((CompositeAggregationBuilder)factory);
                        Iterable $this$forEach$iv2 = sampleDocsAgg;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            TopHitsAggregationBuilder agg = (TopHitsAggregationBuilder)element$iv2;
                            boolean bl2 = false;
                            if (!((Collection)docFieldTags).isEmpty()) {
                                Collection $this$toTypedArray$iv = docFieldTags;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                agg.fetchSource(new FetchSourceContext(true, thisCollection$iv.toArray(new String[0]), new String[0]));
                            }
                            if (((CompositeAggregationBuilder)factory).getSubAggregations().contains(agg)) continue;
                            ((CompositeAggregationBuilder)factory).subAggregation((AggregationBuilder)agg);
                        }
                        continue;
                    }
                    Map map = prevResult.getAggTriggersAfterKey();
                    Intrinsics.checkNotNull((Object)map);
                    Object v = map.get(((BucketLevelTrigger)trigger).getId());
                    Intrinsics.checkNotNull(v);
                    Map afterKey = ((TriggerAfterKey)v).getAfterKey();
                    ((CompositeAggregationBuilder)factory).aggregateAfter(afterKey);
                    continue;
                }
                throw new IllegalStateException("AfterKeys are not expected to be present in non CompositeAggregationBuilder");
            }
            return query;
        }

        public static /* synthetic */ SearchSourceBuilder rewriteQuery$default(Companion companion, SearchSourceBuilder searchSourceBuilder, InputRunResults inputRunResults, List list, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.rewriteQuery(searchSourceBuilder, inputRunResults, list, bl);
        }

        @NotNull
        public final Map<String, TriggerAfterKey> getAfterKeysFromSearchResponse(@NotNull SearchResponse searchResponse, @NotNull List<? extends Trigger> triggers, @Nullable Map<String, TriggerAfterKey> prevBucketLevelTriggerAfterKeys) {
            Intrinsics.checkNotNullParameter((Object)searchResponse, (String)"searchResponse");
            Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
            Map bucketLevelTriggerAfterKeys = new LinkedHashMap();
            Iterable $this$forEach$iv = triggers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Trigger trigger = (Trigger)element$iv;
                boolean bl = false;
                if (!(trigger instanceof BucketLevelTrigger)) continue;
                AggregationPath parentBucketPath = AggregationPath.parse((String)((BucketLevelTrigger)trigger).getBucketSelector().getParentBucketPath());
                Aggregations aggs = searchResponse.getAggregations();
                int n = parentBucketPath.getPathElements().size() - 1;
                for (int i = 0; i < n; ++i) {
                    Object v = aggs.asMap().get(((AggregationPath.PathElement)parentBucketPath.getPathElements().get((int)i)).name);
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.opensearch.search.aggregations.bucket.SingleBucketAggregation");
                    aggs = ((SingleBucketAggregation)v).getAggregations();
                }
                Map map = aggs.getAsMap();
                List list = parentBucketPath.getPathElements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathElements(...)");
                Aggregation lastAgg = (Aggregation)map.get(((AggregationPath.PathElement)CollectionsKt.last((List)list)).name);
                if (!(lastAgg instanceof CompositeAggregation)) continue;
                Map afterKey = ((CompositeAggregation)lastAgg).afterKey();
                Map<String, TriggerAfterKey> map2 = prevBucketLevelTriggerAfterKeys;
                TriggerAfterKey prevTriggerAfterKey = map2 != null ? map2.get(((BucketLevelTrigger)trigger).getId()) : null;
                bucketLevelTriggerAfterKeys.put(((BucketLevelTrigger)trigger).getId(), prevTriggerAfterKey == null ? new TriggerAfterKey(afterKey, afterKey == null) : (prevTriggerAfterKey.getLastPage() ? prevTriggerAfterKey : (afterKey == null ? new TriggerAfterKey(prevTriggerAfterKey.getAfterKey(), true) : new TriggerAfterKey(afterKey, false))));
            }
            return bucketLevelTriggerAfterKeys;
        }

        /*
         * WARNING - void declaration
         */
        private final List<TopHitsAggregationBuilder> getSampleDocAggs(CompositeAggregationBuilder factory) {
            void $this$flatMapTo$iv$iv;
            List defaultSortFields = CollectionsKt.listOf((Object)"_score");
            Collection collection = factory.getSubAggregations();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSubAggregations(...)");
            Object[] $this$flatMap$iv = (Object[])collection;
            boolean $i$f$flatMap = false;
            Object[] objectArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$flatMapTo$iv$iv2;
                AggregationBuilder it = (AggregationBuilder)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Object v = OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)it)).get(it.getName());
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Iterable $this$flatMap$iv2 = ((Map)v).values();
                boolean $i$f$flatMap2 = false;
                Iterable iterable = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                Iterator iterator = $this$flatMapTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv2;
                    Object field = element$iv$iv2 = iterator.next();
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(field, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    Map cfr_ignored_0 = (Map)field;
                    Iterable list$iv$iv = ((Map)field).values();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List aggregations = (List)destination$iv$iv;
            if (!((Collection)aggregations).isEmpty()) {
                defaultSortFields = aggregations;
            }
            TopHitsAggregationBuilder lowHitsAgg = AggregationBuilders.topHits((String)"low_hits").size(5);
            TopHitsAggregationBuilder topHitsAgg = AggregationBuilders.topHits((String)"top_hits").size(5);
            Iterable $this$forEach$iv = defaultSortFields;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                lowHitsAgg.sort(it, SortOrder.ASC);
                topHitsAgg.sort(it, SortOrder.DESC);
            }
            objectArray = new TopHitsAggregationBuilder[]{lowHitsAgg, topHitsAgg};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

